/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.kyori.adventure.key;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.kyori.adventure.key.KeyImpl;
import ca.stellardrift.permissionsex.ext.kyori.examination.Examinable;
import ca.stellardrift.permissionsex.ext.kyori.examination.ExaminableProperty;
import java.util.stream.Stream;

public interface Key
extends Comparable<Key>,
Examinable {
    public static final String MINECRAFT_NAMESPACE = "minecraft";

    public static @NonNull Key key(@NonNull String string) {
        return Key.key(string, ':');
    }

    public static @NonNull Key key(@NonNull String string, char character) {
        int index = string.indexOf(character);
        String namespace = index >= 1 ? string.substring(0, index) : MINECRAFT_NAMESPACE;
        String value = index >= 0 ? string.substring(index + 1) : string;
        return Key.key(namespace, value);
    }

    public static @NonNull Key key(@NonNull String namespace, @NonNull String value) {
        return new KeyImpl(namespace, value);
    }

    public @NonNull String namespace();

    public @NonNull String value();

    public @NonNull String asString();

    @Override
    default public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("namespace", this.namespace()), ExaminableProperty.of("value", this.value()));
    }

    @Override
    default public int compareTo(@NonNull Key that) {
        int value = this.value().compareTo(that.value());
        if (value != 0) {
            return KeyImpl.clampCompare(value);
        }
        return KeyImpl.clampCompare(this.namespace().compareTo(that.namespace()));
    }
}

