/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.kyori.adventure.nbt;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.kyori.adventure.nbt.BinaryTag;
import ca.stellardrift.permissionsex.ext.kyori.adventure.nbt.ByteArrayBinaryTag;
import ca.stellardrift.permissionsex.ext.kyori.adventure.nbt.ByteBinaryTag;
import ca.stellardrift.permissionsex.ext.kyori.adventure.nbt.DoubleBinaryTag;
import ca.stellardrift.permissionsex.ext.kyori.adventure.nbt.FloatBinaryTag;
import ca.stellardrift.permissionsex.ext.kyori.adventure.nbt.IntArrayBinaryTag;
import ca.stellardrift.permissionsex.ext.kyori.adventure.nbt.IntBinaryTag;
import ca.stellardrift.permissionsex.ext.kyori.adventure.nbt.LongArrayBinaryTag;
import ca.stellardrift.permissionsex.ext.kyori.adventure.nbt.LongBinaryTag;
import ca.stellardrift.permissionsex.ext.kyori.adventure.nbt.ShortBinaryTag;
import ca.stellardrift.permissionsex.ext.kyori.adventure.nbt.StringBinaryTag;

public interface CompoundTagSetter<R> {
    public @NonNull R put(@NonNull String var1, @NonNull BinaryTag var2);

    default public @NonNull R putBoolean(@NonNull String key, boolean value) {
        return this.put(key, value ? ByteBinaryTag.ONE : ByteBinaryTag.ZERO);
    }

    default public @NonNull R putByte(@NonNull String key, byte value) {
        return this.put(key, ByteBinaryTag.of(value));
    }

    default public @NonNull R putShort(@NonNull String key, short value) {
        return this.put(key, ShortBinaryTag.of(value));
    }

    default public @NonNull R putInt(@NonNull String key, int value) {
        return this.put(key, IntBinaryTag.of(value));
    }

    default public @NonNull R putLong(@NonNull String key, long value) {
        return this.put(key, LongBinaryTag.of(value));
    }

    default public @NonNull R putFloat(@NonNull String key, float value) {
        return this.put(key, FloatBinaryTag.of(value));
    }

    default public @NonNull R putDouble(@NonNull String key, double value) {
        return this.put(key, DoubleBinaryTag.of(value));
    }

    default public @NonNull R putByteArray(@NonNull String key, byte @NonNull [] value) {
        return this.put(key, ByteArrayBinaryTag.of(value));
    }

    default public @NonNull R putString(@NonNull String key, @NonNull String value) {
        return this.put(key, StringBinaryTag.of(value));
    }

    default public @NonNull R putIntArray(@NonNull String key, int @NonNull [] value) {
        return this.put(key, IntArrayBinaryTag.of(value));
    }

    default public @NonNull R putLongArray(@NonNull String key, long @NonNull [] value) {
        return this.put(key, LongArrayBinaryTag.of(value));
    }
}

