/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.kyori.adventure.nbt;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.index.qual.NonNegative;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.kyori.adventure.nbt.BinaryTag;
import ca.stellardrift.permissionsex.ext.kyori.adventure.nbt.BinaryTagType;
import ca.stellardrift.permissionsex.ext.kyori.adventure.nbt.BinaryTagTypes;
import ca.stellardrift.permissionsex.ext.kyori.adventure.nbt.ListBinaryTag;
import ca.stellardrift.permissionsex.ext.kyori.examination.ExaminableProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;

final class ListBinaryTagImpl
implements ListBinaryTag {
    static final ListBinaryTag EMPTY = new ListBinaryTagImpl(BinaryTagTypes.END, Collections.emptyList());
    private final List<BinaryTag> tags;
    private final BinaryTagType<? extends BinaryTag> type;
    private final int hashCode;

    ListBinaryTagImpl(BinaryTagType<? extends BinaryTag> type, List<BinaryTag> tags) {
        this.tags = tags;
        this.type = type;
        this.hashCode = tags.hashCode();
    }

    @Override
    public @NonNull BinaryTagType<? extends BinaryTag> listType() {
        return this.type;
    }

    @Override
    public int size() {
        return this.tags.size();
    }

    @Override
    public @NonNull BinaryTag get(@NonNegative int index) {
        return this.tags.get(index);
    }

    @Override
    public @NonNull ListBinaryTag set(int index, @NonNull BinaryTag newTag, @Nullable Consumer<BinaryTag> removedConsumer) {
        return this.edit(tags -> {
            BinaryTag oldTag = tags.set(index, newTag);
            if (removedConsumer != null) {
                removedConsumer.accept(oldTag);
            }
        }, newTag.type());
    }

    @Override
    public @NonNull ListBinaryTag remove(int index, @Nullable Consumer<BinaryTag> removedConsumer) {
        return this.edit(tags -> {
            BinaryTag tag = (BinaryTag)tags.remove(index);
            if (removedConsumer != null) {
                removedConsumer.accept(tag);
            }
        }, null);
    }

    @Override
    public @NonNull ListBinaryTag add(BinaryTag tag) {
        return this.edit(tags -> {
            ListBinaryTagImpl.noAddEnd(tag);
            if (this.type != BinaryTagTypes.END) {
                ListBinaryTagImpl.mustBeSameType(tag, this.type);
            }
            tags.add(tag);
        }, tag.type());
    }

    static void noAddEnd(BinaryTag tag) {
        if (tag.type() == BinaryTagTypes.END) {
            throw new IllegalArgumentException(String.format("Cannot add a %s to a %s", BinaryTagTypes.END, BinaryTagTypes.LIST));
        }
    }

    static void mustBeSameType(BinaryTag tag, BinaryTagType<? extends BinaryTag> type) {
        if (tag.type() != type) {
            throw new IllegalArgumentException(String.format("Trying to add tag of type %s to list of %s", tag.type(), type));
        }
    }

    private ListBinaryTag edit(Consumer<List<BinaryTag>> consumer, @Nullable BinaryTagType<? extends BinaryTag> maybeType) {
        ArrayList<BinaryTag> tags = new ArrayList<BinaryTag>(this.tags);
        consumer.accept(tags);
        BinaryTagType<? extends BinaryTag> type = this.type;
        if (maybeType != null && type == BinaryTagTypes.END) {
            type = maybeType;
        }
        return new ListBinaryTagImpl(type, tags);
    }

    @Override
    public @NonNull Stream<BinaryTag> stream() {
        return this.tags.stream();
    }

    @Override
    public Iterator<BinaryTag> iterator() {
        final Iterator<BinaryTag> iterator = this.tags.iterator();
        return new Iterator<BinaryTag>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public BinaryTag next() {
                return (BinaryTag)iterator.next();
            }

            @Override
            public void forEachRemaining(Consumer<? super BinaryTag> action) {
                iterator.forEachRemaining(action);
            }
        };
    }

    @Override
    public void forEach(Consumer<? super BinaryTag> action) {
        this.tags.forEach(action);
    }

    @Override
    public Spliterator<BinaryTag> spliterator() {
        return Spliterators.spliterator(this.tags, 1040);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof ListBinaryTagImpl && this.tags.equals(((ListBinaryTagImpl)that).tags);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("tags", this.tags), ExaminableProperty.of("type", this.type));
    }
}

