/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.kyori.adventure.platform.bukkit;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.kyori.adventure.audience.MessageType;
import ca.stellardrift.permissionsex.ext.kyori.adventure.bossbar.BossBar;
import ca.stellardrift.permissionsex.ext.kyori.adventure.identity.Identity;
import ca.stellardrift.permissionsex.ext.kyori.adventure.key.Key;
import ca.stellardrift.permissionsex.ext.kyori.adventure.platform.facet.Facet;
import ca.stellardrift.permissionsex.ext.kyori.adventure.platform.facet.FacetBase;
import ca.stellardrift.permissionsex.ext.kyori.adventure.platform.facet.Knob;
import ca.stellardrift.permissionsex.ext.kyori.adventure.sound.Sound;
import ca.stellardrift.permissionsex.ext.kyori.adventure.sound.SoundStop;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.serializer.craftbukkit.BukkitComponentSerializer;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.serializer.craftbukkit.MinecraftReflection;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.SoundCategory;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import us.myles.ViaVersion.api.Via;
import us.myles.ViaVersion.api.data.UserConnection;

class BukkitFacet<V extends CommandSender>
extends FacetBase<V> {
    protected BukkitFacet(@Nullable Class<? extends V> viewerClass) {
        super(viewerClass);
    }

    static final class TabList
    extends Message<Player>
    implements Facet.TabList<Player, String> {
        private static final boolean SUPPORTED = MinecraftReflection.hasMethod(Player.class, "setPlayerListHeader", String.class);

        TabList() {
            super(Player.class);
        }

        @Override
        public boolean isSupported() {
            return SUPPORTED && super.isSupported();
        }

        @Override
        public void send(Player viewer, @Nullable String header, @Nullable String footer) {
            if (header != null && footer != null) {
                viewer.setPlayerListHeaderFooter(header, footer);
            } else if (header != null) {
                viewer.setPlayerListHeader(header);
            } else if (footer != null) {
                viewer.setPlayerListFooter(footer);
            }
        }
    }

    static final class ViaHook
    implements Function<Player, UserConnection> {
        ViaHook() {
        }

        @Override
        public UserConnection apply(@NonNull Player player) {
            return Via.getManager().getConnection(player.getUniqueId());
        }
    }

    static class BossBar
    extends Message<Player>
    implements Facet.BossBar<Player> {
        protected final org.bukkit.boss.BossBar bar = Bukkit.createBossBar((String)"", (BarColor)BarColor.PINK, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);

        protected BossBar(@NonNull Collection<Player> viewers) {
            super(Player.class);
            this.bar.setVisible(false);
            for (Player viewer : viewers) {
                this.bar.addPlayer(viewer);
            }
        }

        @Override
        public void bossBarInitialized(@NonNull ca.stellardrift.permissionsex.ext.kyori.adventure.bossbar.BossBar bar) {
            Facet.BossBar.super.bossBarInitialized(bar);
            this.bar.setVisible(true);
        }

        @Override
        public void bossBarNameChanged(@NonNull ca.stellardrift.permissionsex.ext.kyori.adventure.bossbar.BossBar bar, @NonNull Component oldName, @NonNull Component newName) {
            if (!this.bar.getPlayers().isEmpty()) {
                this.bar.setTitle(this.createMessage((Player)this.bar.getPlayers().get(0), newName));
            }
        }

        @Override
        public void bossBarProgressChanged(@NonNull ca.stellardrift.permissionsex.ext.kyori.adventure.bossbar.BossBar bar, float oldPercent, float newPercent) {
            this.bar.setProgress((double)newPercent);
        }

        @Override
        public void bossBarColorChanged(@NonNull ca.stellardrift.permissionsex.ext.kyori.adventure.bossbar.BossBar bar,  @NonNull BossBar.Color oldColor,  @NonNull BossBar.Color newColor) {
            BarColor color = this.color(newColor);
            if (color != null) {
                this.bar.setColor(color);
            }
        }

        private @Nullable BarColor color( @NonNull BossBar.Color color) {
            if (color == BossBar.Color.PINK) {
                return BarColor.PINK;
            }
            if (color == BossBar.Color.BLUE) {
                return BarColor.BLUE;
            }
            if (color == BossBar.Color.RED) {
                return BarColor.RED;
            }
            if (color == BossBar.Color.GREEN) {
                return BarColor.GREEN;
            }
            if (color == BossBar.Color.YELLOW) {
                return BarColor.YELLOW;
            }
            if (color == BossBar.Color.PURPLE) {
                return BarColor.PURPLE;
            }
            if (color == BossBar.Color.WHITE) {
                return BarColor.WHITE;
            }
            Knob.logUnsupported(this, (Object)color);
            return null;
        }

        @Override
        public void bossBarOverlayChanged(@NonNull ca.stellardrift.permissionsex.ext.kyori.adventure.bossbar.BossBar bar,  @NonNull BossBar.Overlay oldOverlay,  @NonNull BossBar.Overlay newOverlay) {
            BarStyle style = this.style(newOverlay);
            if (style != null) {
                this.bar.setStyle(style);
            }
        }

        private @Nullable BarStyle style( @NonNull BossBar.Overlay overlay) {
            if (overlay == BossBar.Overlay.PROGRESS) {
                return BarStyle.SOLID;
            }
            if (overlay == BossBar.Overlay.NOTCHED_6) {
                return BarStyle.SEGMENTED_6;
            }
            if (overlay == BossBar.Overlay.NOTCHED_10) {
                return BarStyle.SEGMENTED_10;
            }
            if (overlay == BossBar.Overlay.NOTCHED_12) {
                return BarStyle.SEGMENTED_12;
            }
            if (overlay == BossBar.Overlay.NOTCHED_20) {
                return BarStyle.SEGMENTED_20;
            }
            Knob.logUnsupported(this, (Object)overlay);
            return null;
        }

        @Override
        public void bossBarFlagsChanged(@NonNull ca.stellardrift.permissionsex.ext.kyori.adventure.bossbar.BossBar bar, @NonNull Set<BossBar.Flag> flagsAdded, @NonNull Set<BossBar.Flag> flagsRemoved) {
            BarFlag flag;
            for (BossBar.Flag removeFlag : flagsRemoved) {
                flag = this.flag(removeFlag);
                if (flag == null) continue;
                this.bar.removeFlag(flag);
            }
            for (BossBar.Flag addFlag : flagsAdded) {
                flag = this.flag(addFlag);
                if (flag == null) continue;
                this.bar.addFlag(flag);
            }
        }

        private @Nullable BarFlag flag( @NonNull BossBar.Flag flag) {
            if (flag == BossBar.Flag.DARKEN_SCREEN) {
                return BarFlag.DARKEN_SKY;
            }
            if (flag == BossBar.Flag.PLAY_BOSS_MUSIC) {
                return BarFlag.PLAY_BOSS_MUSIC;
            }
            if (flag == BossBar.Flag.CREATE_WORLD_FOG) {
                return BarFlag.CREATE_FOG;
            }
            Knob.logUnsupported(this, (Object)flag);
            return null;
        }

        @Override
        public void addViewer(@NonNull Player viewer) {
            this.bar.addPlayer(viewer);
        }

        @Override
        public void removeViewer(@NonNull Player viewer) {
            this.bar.removePlayer(viewer);
        }

        @Override
        public boolean isEmpty() {
            return !this.bar.isVisible() || this.bar.getPlayers().isEmpty();
        }

        @Override
        public void close() {
            this.bar.removeAll();
        }
    }

    static class BossBarBuilder
    extends BukkitFacet<Player>
    implements Facet.BossBar.Builder<Player, BossBar> {
        private static final boolean SUPPORTED = MinecraftReflection.hasClass("org.bukkit.boss.BossBar");

        protected BossBarBuilder() {
            super(Player.class);
        }

        @Override
        public boolean isSupported() {
            return super.isSupported() && SUPPORTED;
        }

        @Override
        public @NonNull BossBar createBossBar(@NonNull Collection<Player> viewers) {
            return new BossBar(viewers);
        }
    }

    static class SoundWithCategory
    extends Sound {
        private static final boolean SUPPORTED = MinecraftReflection.hasMethod(Player.class, "stopSound", String.class, MinecraftReflection.findClass("org.bukkit.SoundCategory"));

        SoundWithCategory() {
        }

        @Override
        public boolean isSupported() {
            return super.isSupported() && SUPPORTED;
        }

        @Override
        public void playSound(@NonNull Player viewer, @NonNull ca.stellardrift.permissionsex.ext.kyori.adventure.sound.Sound sound, @NonNull Vector vector) {
            SoundCategory category = this.category(sound.source());
            if (category == null) {
                super.playSound(viewer, sound, vector);
            } else {
                String name = SoundWithCategory.name(sound.name());
                viewer.playSound(vector.toLocation(viewer.getWorld()), name, category, sound.volume(), sound.pitch());
            }
        }

        @Override
        public void stopSound(@NonNull Player viewer, @NonNull SoundStop stop) {
            SoundCategory category = this.category(stop.source());
            if (category == null) {
                super.stopSound(viewer, stop);
            } else {
                String name = SoundWithCategory.name(stop.sound());
                viewer.stopSound(name, category);
            }
        }

        private @Nullable SoundCategory category( @Nullable Sound.Source source) {
            if (source == null) {
                return null;
            }
            if (source == Sound.Source.MASTER) {
                return SoundCategory.MASTER;
            }
            if (source == Sound.Source.MUSIC) {
                return SoundCategory.MUSIC;
            }
            if (source == Sound.Source.RECORD) {
                return SoundCategory.RECORDS;
            }
            if (source == Sound.Source.WEATHER) {
                return SoundCategory.WEATHER;
            }
            if (source == Sound.Source.BLOCK) {
                return SoundCategory.BLOCKS;
            }
            if (source == Sound.Source.HOSTILE) {
                return SoundCategory.HOSTILE;
            }
            if (source == Sound.Source.NEUTRAL) {
                return SoundCategory.NEUTRAL;
            }
            if (source == Sound.Source.PLAYER) {
                return SoundCategory.PLAYERS;
            }
            if (source == Sound.Source.AMBIENT) {
                return SoundCategory.AMBIENT;
            }
            if (source == Sound.Source.VOICE) {
                return SoundCategory.VOICE;
            }
            Knob.logUnsupported(this, (Object)source);
            return null;
        }
    }

    static class Sound
    extends Position
    implements Facet.Sound<Player, Vector> {
        private static final boolean KEY_SUPPORTED = MinecraftReflection.hasClass("org.bukkit.NamespacedKey");
        private static final boolean STOP_SUPPORTED = MinecraftReflection.hasMethod(Player.class, "stopSound", String.class);

        Sound() {
        }

        @Override
        public void playSound(@NonNull Player viewer, @NonNull ca.stellardrift.permissionsex.ext.kyori.adventure.sound.Sound sound, @NonNull Vector vector) {
            String name = Sound.name(sound.name());
            Location location = vector.toLocation(viewer.getWorld());
            viewer.playSound(location, name, sound.volume(), sound.pitch());
        }

        @Override
        public void stopSound(@NonNull Player viewer, @NonNull SoundStop stop) {
            if (STOP_SUPPORTED) {
                String name = Sound.name(stop.sound());
                viewer.stopSound(name);
            }
        }

        protected static @NonNull String name(@Nullable Key name) {
            if (name == null) {
                return "";
            }
            if (KEY_SUPPORTED) {
                return name.asString();
            }
            return name.value();
        }
    }

    static class Position
    extends BukkitFacet<Player>
    implements Facet.Position<Player, Vector> {
        protected Position() {
            super(Player.class);
        }

        @Override
        public @NonNull Vector createPosition(@NonNull Player viewer) {
            return viewer.getLocation().toVector();
        }

        @Override
        public @NonNull Vector createPosition(double x, double y, double z) {
            return new Vector(x, y, z);
        }
    }

    static class Chat
    extends Message<CommandSender>
    implements Facet.Chat<CommandSender, String> {
        protected Chat() {
            super(CommandSender.class);
        }

        @Override
        public void sendMessage(@NonNull CommandSender viewer, @NonNull Identity source, @NonNull String message, @NonNull MessageType type) {
            viewer.sendMessage(message);
        }
    }

    static class Message<V extends CommandSender>
    extends BukkitFacet<V>
    implements Facet.Message<V, String> {
        protected Message(@Nullable Class<? extends V> viewerClass) {
            super(viewerClass);
        }

        @Override
        public @NonNull String createMessage(@NonNull V viewer, @NonNull Component message) {
            return BukkitComponentSerializer.legacy().serialize(message);
        }
    }
}

