/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.kyori.adventure.platform.bukkit;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.kyori.adventure.audience.MessageType;
import ca.stellardrift.permissionsex.ext.kyori.adventure.identity.Identity;
import ca.stellardrift.permissionsex.ext.kyori.adventure.nbt.BinaryTagIO;
import ca.stellardrift.permissionsex.ext.kyori.adventure.nbt.BinaryTagTypes;
import ca.stellardrift.permissionsex.ext.kyori.adventure.nbt.CompoundBinaryTag;
import ca.stellardrift.permissionsex.ext.kyori.adventure.nbt.ListBinaryTag;
import ca.stellardrift.permissionsex.ext.kyori.adventure.nbt.StringBinaryTag;
import ca.stellardrift.permissionsex.ext.kyori.adventure.platform.bukkit.BukkitAudience;
import ca.stellardrift.permissionsex.ext.kyori.adventure.platform.bukkit.BukkitFacet;
import ca.stellardrift.permissionsex.ext.kyori.adventure.platform.facet.Facet;
import ca.stellardrift.permissionsex.ext.kyori.adventure.platform.facet.FacetBase;
import ca.stellardrift.permissionsex.ext.kyori.adventure.platform.facet.Knob;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.TextComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.serializer.craftbukkit.BukkitComponentSerializer;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.serializer.craftbukkit.MinecraftComponentSerializer;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.serializer.craftbukkit.MinecraftReflection;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wither;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

class CraftBukkitFacet<V extends CommandSender>
extends FacetBase<V> {
    private static final @Nullable Class<? extends Player> CLASS_CRAFT_PLAYER = MinecraftReflection.findCraftClass("entity.CraftPlayer", Player.class);
    private static final @Nullable MethodHandle CRAFT_PLAYER_GET_HANDLE;
    private static final @Nullable MethodHandle ENTITY_PLAYER_GET_CONNECTION;
    private static final @Nullable MethodHandle PLAYER_CONNECTION_SEND_PACKET;
    private static final boolean SUPPORTED;
    private static final @Nullable Class<?> CLASS_CHAT_COMPONENT;
    private static final @Nullable Class<?> CLASS_MESSAGE_TYPE;
    private static final @Nullable Object MESSAGE_TYPE_CHAT;
    private static final @Nullable Object MESSAGE_TYPE_SYSTEM;
    private static final @Nullable Object MESSAGE_TYPE_ACTIONBAR;
    private static final @Nullable MethodHandle LEGACY_CHAT_PACKET_CONSTRUCTOR;
    private static final @Nullable MethodHandle CHAT_PACKET_CONSTRUCTOR;
    private static final @Nullable Class<?> CLASS_TITLE_PACKET;
    private static final @Nullable Class<?> CLASS_TITLE_ACTION;
    private static final MethodHandle CONSTRUCTOR_TITLE_MESSAGE;
    private static final @Nullable MethodHandle CONSTRUCTOR_TITLE_TIMES;
    private static final @Nullable Object TITLE_ACTION_TITLE;
    private static final @Nullable Object TITLE_ACTION_SUBTITLE;
    private static final @Nullable Object TITLE_ACTION_ACTIONBAR;
    private static final @Nullable Object TITLE_ACTION_CLEAR;
    private static final @Nullable Object TITLE_ACTION_RESET;

    protected CraftBukkitFacet(@Nullable Class<? extends V> viewerClass) {
        super(viewerClass);
    }

    @Override
    public boolean isSupported() {
        return super.isSupported() && SUPPORTED;
    }

    static {
        Class<?> craftPlayerClass = MinecraftReflection.findCraftClass("entity.CraftPlayer");
        Class<?> packetClass = MinecraftReflection.findNmsClass("Packet");
        MethodHandle craftPlayerGetHandle = null;
        MethodHandle entityPlayerGetConnection = null;
        MethodHandle playerConnectionSendPacket = null;
        if (craftPlayerClass != null && packetClass != null) {
            try {
                Method getHandleMethod = craftPlayerClass.getMethod("getHandle", new Class[0]);
                Class<?> entityPlayerClass = getHandleMethod.getReturnType();
                craftPlayerGetHandle = MinecraftReflection.lookup().unreflect(getHandleMethod);
                Field playerConnectionField = entityPlayerClass.getField("playerConnection");
                entityPlayerGetConnection = MinecraftReflection.lookup().unreflectGetter(playerConnectionField);
                Class<?> playerConnectionClass = playerConnectionField.getType();
                playerConnectionSendPacket = MinecraftReflection.lookup().findVirtual(playerConnectionClass, "sendPacket", MethodType.methodType(Void.TYPE, packetClass));
            }
            catch (Throwable error) {
                Knob.logError(error, "Failed to initialize CraftBukkit sendPacket", new Object[0]);
            }
        }
        CRAFT_PLAYER_GET_HANDLE = craftPlayerGetHandle;
        ENTITY_PLAYER_GET_CONNECTION = entityPlayerGetConnection;
        PLAYER_CONNECTION_SEND_PACKET = playerConnectionSendPacket;
        SUPPORTED = Knob.isEnabled("craftbukkit", true) && MinecraftComponentSerializer.isSupported() && CRAFT_PLAYER_GET_HANDLE != null && ENTITY_PLAYER_GET_CONNECTION != null && PLAYER_CONNECTION_SEND_PACKET != null;
        CLASS_CHAT_COMPONENT = MinecraftReflection.findNmsClass("IChatBaseComponent");
        CLASS_MESSAGE_TYPE = MinecraftReflection.findNmsClass("ChatMessageType");
        MESSAGE_TYPE_CHAT = MinecraftReflection.findEnum(CLASS_MESSAGE_TYPE, "CHAT", 0);
        MESSAGE_TYPE_SYSTEM = MinecraftReflection.findEnum(CLASS_MESSAGE_TYPE, "SYSTEM", 1);
        MESSAGE_TYPE_ACTIONBAR = MinecraftReflection.findEnum(CLASS_MESSAGE_TYPE, "GAME_INFO", 2);
        MethodHandle legacyChatPacketConstructor = null;
        MethodHandle chatPacketConstructor = null;
        try {
            if (CLASS_CHAT_COMPONENT != null) {
                Class<?> chatPacketClass = MinecraftReflection.needNmsClass("PacketPlayOutChat");
                chatPacketConstructor = MinecraftReflection.findConstructor(chatPacketClass, CLASS_CHAT_COMPONENT);
                if (chatPacketConstructor == null) {
                    if (CLASS_MESSAGE_TYPE != null) {
                        chatPacketConstructor = MinecraftReflection.findConstructor(chatPacketClass, CLASS_CHAT_COMPONENT, CLASS_MESSAGE_TYPE, UUID.class);
                    }
                } else {
                    chatPacketConstructor = MethodHandles.dropArguments(chatPacketConstructor, 1, new Class[]{CLASS_MESSAGE_TYPE == null ? Object.class : CLASS_MESSAGE_TYPE, UUID.class});
                }
                if ((legacyChatPacketConstructor = MinecraftReflection.findConstructor(chatPacketClass, CLASS_CHAT_COMPONENT, Byte.TYPE)) == null) {
                    legacyChatPacketConstructor = MinecraftReflection.findConstructor(chatPacketClass, CLASS_CHAT_COMPONENT, Integer.TYPE);
                }
            }
        }
        catch (Throwable error) {
            Knob.logError(error, "Failed to initialize PacketPlayOutChat constructor", new Object[0]);
        }
        CHAT_PACKET_CONSTRUCTOR = chatPacketConstructor;
        LEGACY_CHAT_PACKET_CONSTRUCTOR = legacyChatPacketConstructor;
        CLASS_TITLE_PACKET = MinecraftReflection.findNmsClass("PacketPlayOutTitle");
        CLASS_TITLE_ACTION = MinecraftReflection.findNmsClass("PacketPlayOutTitle$EnumTitleAction");
        CONSTRUCTOR_TITLE_MESSAGE = MinecraftReflection.findConstructor(CLASS_TITLE_PACKET, CLASS_TITLE_ACTION, CLASS_CHAT_COMPONENT);
        CONSTRUCTOR_TITLE_TIMES = MinecraftReflection.findConstructor(CLASS_TITLE_PACKET, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        TITLE_ACTION_TITLE = MinecraftReflection.findEnum(CLASS_TITLE_ACTION, "TITLE", 0);
        TITLE_ACTION_SUBTITLE = MinecraftReflection.findEnum(CLASS_TITLE_ACTION, "SUBTITLE", 1);
        TITLE_ACTION_ACTIONBAR = MinecraftReflection.findEnum(CLASS_TITLE_ACTION, "ACTIONBAR");
        TITLE_ACTION_CLEAR = MinecraftReflection.findEnum(CLASS_TITLE_ACTION, "CLEAR");
        TITLE_ACTION_RESET = MinecraftReflection.findEnum(CLASS_TITLE_ACTION, "RESET");
    }

    static final class TabList
    extends PacketFacet<Player>
    implements Facet.TabList<Player, Object> {
        private static final Class<?> CLIENTBOUND_TAB_LIST_PACKET = MinecraftReflection.findNmsClass("PacketPlayOutPlayerListHeaderFooter");
        private static final @Nullable MethodHandle CLIENTBOUND_TAB_LIST_PACKET_CTOR = MinecraftReflection.findConstructor(CLIENTBOUND_TAB_LIST_PACKET, new Class[0]);
        private static final @Nullable Field CRAFT_PLAYER_TAB_LIST_HEADER = MinecraftReflection.findField(CraftBukkitFacet.access$000(), "playerListHeader");
        private static final @Nullable Field CRAFT_PLAYER_TAB_LIST_FOOTER = MinecraftReflection.findField(CraftBukkitFacet.access$000(), "playerListFooter");
        private static final @Nullable MethodHandle CLIENTBOUND_TAB_LIST_PACKET_SET_HEADER = TabList.first(MinecraftReflection.findSetterOf(MinecraftReflection.findField(CLIENTBOUND_TAB_LIST_PACKET, "header", CraftBukkitFacet.access$1600())), MinecraftReflection.findSetterOf(MinecraftReflection.findField(CLIENTBOUND_TAB_LIST_PACKET, "a", CraftBukkitFacet.access$1600())));
        private static final @Nullable MethodHandle CLIENTBOUND_TAB_LIST_PACKET_SET_FOOTER = TabList.first(MinecraftReflection.findSetterOf(MinecraftReflection.findField(CLIENTBOUND_TAB_LIST_PACKET, "footer", CraftBukkitFacet.access$1600())), MinecraftReflection.findSetterOf(MinecraftReflection.findField(CLIENTBOUND_TAB_LIST_PACKET, "b", CraftBukkitFacet.access$1600())));

        TabList() {
        }

        private static MethodHandle first(MethodHandle ... handles) {
            for (int i = 0; i < handles.length; ++i) {
                MethodHandle handle = handles[i];
                if (handle == null) continue;
                return handle;
            }
            return null;
        }

        @Override
        public boolean isSupported() {
            return CLIENTBOUND_TAB_LIST_PACKET_CTOR != null && CLIENTBOUND_TAB_LIST_PACKET_SET_HEADER != null && CLIENTBOUND_TAB_LIST_PACKET_SET_FOOTER != null && super.isSupported();
        }

        @Override
        public void send(Player viewer, @Nullable Object header, @Nullable Object footer) {
            try {
                Object packet = CLIENTBOUND_TAB_LIST_PACKET_CTOR.invoke();
                if (CRAFT_PLAYER_TAB_LIST_HEADER != null && CRAFT_PLAYER_TAB_LIST_FOOTER != null) {
                    if (header == null) {
                        header = CRAFT_PLAYER_TAB_LIST_HEADER.get(viewer);
                    } else {
                        CRAFT_PLAYER_TAB_LIST_HEADER.set(viewer, header);
                    }
                    if (footer == null) {
                        footer = CRAFT_PLAYER_TAB_LIST_FOOTER.get(viewer);
                    } else {
                        CRAFT_PLAYER_TAB_LIST_FOOTER.set(viewer, footer);
                    }
                }
                CLIENTBOUND_TAB_LIST_PACKET_SET_HEADER.invoke(packet, header == null ? this.createMessage(viewer, (Component)Component.empty()) : header);
                CLIENTBOUND_TAB_LIST_PACKET_SET_FOOTER.invoke(packet, footer == null ? this.createMessage(viewer, (Component)Component.empty()) : footer);
                this.sendPacket(viewer, packet);
            }
            catch (Throwable thr) {
                Knob.logError(thr, "Failed to send tab list header and footer to %s", viewer);
            }
        }
    }

    static final class BossBarWither
    extends FakeEntity<Wither>
    implements Facet.BossBarEntity<Player, Location> {
        private volatile boolean initialized = false;

        private BossBarWither(@NonNull Collection<Player> viewers) {
            super(Wither.class, viewers.iterator().next().getWorld().getSpawnLocation());
            this.invisible(true);
            this.metadata(20, 890);
        }

        @Override
        public void bossBarInitialized(@NonNull ca.stellardrift.permissionsex.ext.kyori.adventure.bossbar.BossBar bar) {
            Facet.BossBarEntity.super.bossBarInitialized(bar);
            this.initialized = true;
        }

        @Override
        public @NonNull Location createPosition(@NonNull Player viewer) {
            Location position = super.createPosition(viewer);
            position.setPitch(position.getPitch() - 30.0f);
            position.setYaw(position.getYaw() + 0.0f);
            position.add(position.getDirection().multiply(40));
            return position;
        }

        @Override
        public boolean isEmpty() {
            return !this.initialized || this.viewers.isEmpty();
        }

        public static class Builder
        extends CraftBukkitFacet<Player>
        implements Facet.BossBar.Builder<Player, BossBarWither> {
            protected Builder() {
                super(Player.class);
            }

            @Override
            public @NonNull BossBarWither createBossBar(@NonNull Collection<Player> viewers) {
                return new BossBarWither(viewers);
            }
        }
    }

    static class FakeEntity<E extends Entity>
    extends PacketFacet<Player>
    implements Facet.FakeEntity<Player, Location>,
    Listener {
        private static final Class<? extends World> CLASS_CRAFT_WORLD = MinecraftReflection.findCraftClass("CraftWorld", World.class);
        private static final Class<?> CLASS_NMS_ENTITY = MinecraftReflection.findNmsClass("Entity");
        private static final Class<?> CLASS_NMS_LIVING_ENTITY = MinecraftReflection.findNmsClass("EntityLiving");
        private static final Class<?> CLASS_CRAFT_ENTITY = MinecraftReflection.findCraftClass("entity.CraftEntity");
        private static final Class<?> CLASS_DATA_WATCHER = MinecraftReflection.findNmsClass("DataWatcher");
        private static final MethodHandle CRAFT_WORLD_CREATE_ENTITY = MinecraftReflection.findMethod(CLASS_CRAFT_WORLD, "createEntity", CLASS_NMS_ENTITY, Location.class, Class.class);
        private static final MethodHandle CRAFT_ENTITY_GET_HANDLE = MinecraftReflection.findMethod(CLASS_CRAFT_ENTITY, "getHandle", CLASS_NMS_ENTITY, new Class[0]);
        private static final MethodHandle NMS_ENTITY_GET_BUKKIT_ENTITY = MinecraftReflection.findMethod(CLASS_NMS_ENTITY, "getBukkitEntity", CLASS_CRAFT_ENTITY, new Class[0]);
        private static final MethodHandle NMS_ENTITY_GET_DATA_WATCHER = MinecraftReflection.findMethod(CLASS_NMS_ENTITY, "getDataWatcher", CLASS_DATA_WATCHER, new Class[0]);
        private static final MethodHandle NMS_ENTITY_SET_LOCATION = MinecraftReflection.findMethod(CLASS_NMS_ENTITY, "setLocation", Void.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
        private static final MethodHandle NMS_ENTITY_SET_INVISIBLE = MinecraftReflection.findMethod(CLASS_NMS_ENTITY, "setInvisible", Void.TYPE, Boolean.TYPE);
        private static final MethodHandle DATA_WATCHER_WATCH = MinecraftReflection.findMethod(CLASS_DATA_WATCHER, "watch", Void.TYPE, Integer.TYPE, Object.class);
        private static final Class<?> CLASS_SPAWN_LIVING_PACKET = MinecraftReflection.findNmsClass("PacketPlayOutSpawnEntityLiving");
        private static final MethodHandle NEW_SPAWN_LIVING_PACKET = MinecraftReflection.findConstructor(CLASS_SPAWN_LIVING_PACKET, CLASS_NMS_LIVING_ENTITY);
        private static final Class<?> CLASS_ENTITY_DESTROY_PACKET = MinecraftReflection.findNmsClass("PacketPlayOutEntityDestroy");
        private static final MethodHandle NEW_ENTITY_DESTROY_PACKET = MinecraftReflection.findConstructor(CLASS_ENTITY_DESTROY_PACKET, int[].class);
        private static final Class<?> CLASS_ENTITY_METADATA_PACKET = MinecraftReflection.findNmsClass("PacketPlayOutEntityMetadata");
        private static final MethodHandle NEW_ENTITY_METADATA_PACKET = MinecraftReflection.findConstructor(CLASS_ENTITY_METADATA_PACKET, Integer.TYPE, CLASS_DATA_WATCHER, Boolean.TYPE);
        private static final Class<?> CLASS_ENTITY_TELEPORT_PACKET = MinecraftReflection.findNmsClass("PacketPlayOutEntityTeleport");
        private static final MethodHandle NEW_ENTITY_TELEPORT_PACKET = MinecraftReflection.findConstructor(CLASS_ENTITY_TELEPORT_PACKET, CLASS_NMS_ENTITY);
        private static final Class<?> CLASS_ENTITY_WITHER = MinecraftReflection.findNmsClass("EntityWither");
        private static final Class<?> CLASS_WORLD = MinecraftReflection.findNmsClass("World");
        private static final Class<?> CLASS_WORLD_SERVER = MinecraftReflection.findNmsClass("WorldServer");
        private static final MethodHandle CRAFT_WORLD_GET_HANDLE = MinecraftReflection.findMethod(CLASS_CRAFT_WORLD, "getHandle", CLASS_WORLD_SERVER, new Class[0]);
        private static final MethodHandle NEW_ENTITY_WITHER = MinecraftReflection.findConstructor(CLASS_ENTITY_WITHER, CLASS_WORLD);
        private static final boolean SUPPORTED = (CRAFT_WORLD_CREATE_ENTITY != null || NEW_ENTITY_WITHER != null && CRAFT_WORLD_GET_HANDLE != null) && CRAFT_ENTITY_GET_HANDLE != null && NMS_ENTITY_GET_BUKKIT_ENTITY != null && NMS_ENTITY_GET_DATA_WATCHER != null;
        private final E entity;
        private final Object entityHandle;
        protected final Set<Player> viewers;

        protected FakeEntity(@NonNull Class<E> entityClass, @NonNull Location location) {
            this(BukkitAudience.PLUGIN.get(), entityClass, location);
        }

        protected FakeEntity(@NonNull Plugin plugin, @NonNull Class<E> entityClass, @NonNull Location location) {
            Entity entity = null;
            Object handle = null;
            if (SUPPORTED) {
                try {
                    if (CRAFT_WORLD_CREATE_ENTITY != null) {
                        Object nmsEntity = CRAFT_WORLD_CREATE_ENTITY.invoke(location.getWorld(), location, entityClass);
                        entity = NMS_ENTITY_GET_BUKKIT_ENTITY.invoke(nmsEntity);
                    } else if (Wither.class.isAssignableFrom(entityClass) && NEW_ENTITY_WITHER != null) {
                        Object nmsEntity = NEW_ENTITY_WITHER.invoke(CRAFT_WORLD_GET_HANDLE.invoke(location.getWorld()));
                        entity = NMS_ENTITY_GET_BUKKIT_ENTITY.invoke(nmsEntity);
                    }
                    if (CLASS_CRAFT_ENTITY.isInstance(entity)) {
                        handle = CRAFT_ENTITY_GET_HANDLE.invoke(entity);
                    }
                }
                catch (Throwable error) {
                    Knob.logError(error, "Failed to create fake entity: %s", entityClass.getSimpleName());
                }
            }
            this.entity = entity;
            this.entityHandle = handle;
            this.viewers = new HashSet<Player>();
            if (this.isSupported()) {
                plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
            }
        }

        @Override
        public boolean isSupported() {
            return super.isSupported() && this.entity != null && this.entityHandle != null;
        }

        @EventHandler(ignoreCancelled=false, priority=EventPriority.MONITOR)
        public void onPlayerMove(PlayerMoveEvent event) {
            Player viewer = event.getPlayer();
            if (this.viewers.contains(viewer)) {
                this.teleport(viewer, this.createPosition(viewer));
            }
        }

        public @Nullable Object createSpawnPacket() {
            if (this.entity instanceof LivingEntity) {
                try {
                    return NEW_SPAWN_LIVING_PACKET.invoke(this.entityHandle);
                }
                catch (Throwable error) {
                    Knob.logError(error, "Failed to create spawn packet: %s", this.entity);
                }
            }
            return null;
        }

        public @Nullable Object createDespawnPacket() {
            try {
                return NEW_ENTITY_DESTROY_PACKET.invoke(this.entity.getEntityId());
            }
            catch (Throwable error) {
                Knob.logError(error, "Failed to create despawn packet: %s", this.entity);
                return null;
            }
        }

        public @Nullable Object createMetadataPacket() {
            try {
                Object dataWatcher = NMS_ENTITY_GET_DATA_WATCHER.invoke(this.entityHandle);
                return NEW_ENTITY_METADATA_PACKET.invoke(this.entity.getEntityId(), dataWatcher, false);
            }
            catch (Throwable error) {
                Knob.logError(error, "Failed to create update metadata packet: %s", this.entity);
                return null;
            }
        }

        public @Nullable Object createLocationPacket() {
            try {
                return NEW_ENTITY_TELEPORT_PACKET.invoke(this.entityHandle);
            }
            catch (Throwable error) {
                Knob.logError(error, "Failed to create teleport packet: %s", this.entity);
                return null;
            }
        }

        public void broadcastPacket(@Nullable Object packet) {
            for (Player viewer : this.viewers) {
                this.sendPacket(viewer, packet);
            }
        }

        @Override
        public @NonNull Location createPosition(@NonNull Player viewer) {
            return viewer.getLocation();
        }

        @Override
        public @NonNull Location createPosition(double x, double y, double z) {
            return new Location(null, x, y, z);
        }

        @Override
        public void teleport(@NonNull Player viewer, @Nullable Location position) {
            if (position == null) {
                this.viewers.remove(viewer);
                this.sendPacket(viewer, this.createDespawnPacket());
                return;
            }
            if (!this.viewers.contains(viewer)) {
                this.sendPacket(viewer, this.createSpawnPacket());
                this.viewers.add(viewer);
            }
            try {
                NMS_ENTITY_SET_LOCATION.invoke(this.entityHandle, position.getX(), position.getY(), position.getZ(), position.getPitch(), position.getYaw());
            }
            catch (Throwable error) {
                Knob.logError(error, "Failed to set entity location: %s %s", this.entity, position);
            }
            this.sendPacket(viewer, this.createLocationPacket());
        }

        @Override
        public void metadata(int position, @NonNull Object data) {
            if (DATA_WATCHER_WATCH != null) {
                try {
                    Object dataWatcher = NMS_ENTITY_GET_DATA_WATCHER.invoke(this.entityHandle);
                    DATA_WATCHER_WATCH.invoke(dataWatcher, position, data);
                }
                catch (Throwable error) {
                    Knob.logError(error, "Failed to set entity metadata: %s %s=%s", this.entity, position, data);
                }
                this.broadcastPacket(this.createMetadataPacket());
            }
        }

        @Override
        public void invisible(boolean invisible) {
            if (NMS_ENTITY_SET_INVISIBLE != null) {
                try {
                    NMS_ENTITY_SET_INVISIBLE.invoke(this.entityHandle, invisible);
                }
                catch (Throwable error) {
                    Knob.logError(error, "Failed to change entity visibility: %s", this.entity);
                }
            }
        }

        @Override
        @Deprecated
        public void health(float health) {
            if (this.entity instanceof Damageable) {
                Damageable entity = (Damageable)this.entity;
                entity.setHealth((double)health * (entity.getMaxHealth() - (double)0.1f) + (double)0.1f);
                this.broadcastPacket(this.createMetadataPacket());
            }
        }

        @Override
        public void name(@NonNull Component name) {
            this.entity.setCustomName(BukkitComponentSerializer.legacy().serialize(name));
            this.broadcastPacket(this.createMetadataPacket());
        }

        @Override
        public void close() {
            HandlerList.unregisterAll((Listener)this);
            for (Player viewer : new LinkedList<Player>(this.viewers)) {
                this.teleport(viewer, null);
            }
        }
    }

    static final class BossBar
    extends BukkitFacet.BossBar {
        private static final Class<?> CLASS_CRAFT_BOSS_BAR = MinecraftReflection.findCraftClass("boss.CraftBossBar");
        private static final Class<?> CLASS_BOSS_BAR_ACTION = MinecraftReflection.findNmsClass("PacketPlayOutBoss$Action");
        private static final Object BOSS_BAR_ACTION_TITLE = MinecraftReflection.findEnum(CLASS_BOSS_BAR_ACTION, "UPDATE_NAME", 3);
        private static final MethodHandle CRAFT_BOSS_BAR_HANDLE;
        private static final MethodHandle NMS_BOSS_BATTLE_SET_NAME;
        private static final MethodHandle NMS_BOSS_BATTLE_SEND_UPDATE;

        private BossBar(@NonNull Collection<Player> viewers) {
            super(viewers);
        }

        @Override
        public void bossBarNameChanged(@NonNull ca.stellardrift.permissionsex.ext.kyori.adventure.bossbar.BossBar bar, @NonNull Component oldName, @NonNull Component newName) {
            try {
                Object handle = CRAFT_BOSS_BAR_HANDLE.invoke(this.bar);
                Object text = MinecraftComponentSerializer.get().serialize(newName);
                NMS_BOSS_BATTLE_SET_NAME.invoke(handle, text);
                NMS_BOSS_BATTLE_SEND_UPDATE.invoke(handle, BOSS_BAR_ACTION_TITLE);
            }
            catch (Throwable error) {
                Knob.logError(error, "Failed to set CraftBossBar name: %s %s", this.bar, newName);
                super.bossBarNameChanged(bar, oldName, newName);
            }
        }

        static {
            MethodHandle craftBossBarHandle = null;
            MethodHandle nmsBossBattleSetName = null;
            MethodHandle nmsBossBattleSendUpdate = null;
            if (CLASS_CRAFT_BOSS_BAR != null && CLASS_CHAT_COMPONENT != null && BOSS_BAR_ACTION_TITLE != null) {
                try {
                    Field craftBossBarHandleField = MinecraftReflection.needField(CLASS_CRAFT_BOSS_BAR, "handle");
                    craftBossBarHandle = MinecraftReflection.lookup().unreflectGetter(craftBossBarHandleField);
                    Class<?> nmsBossBattleType = craftBossBarHandleField.getType();
                    nmsBossBattleSetName = MinecraftReflection.lookup().findSetter(nmsBossBattleType, "title", CLASS_CHAT_COMPONENT);
                    nmsBossBattleSendUpdate = MinecraftReflection.lookup().findVirtual(nmsBossBattleType, "sendUpdate", MethodType.methodType(Void.TYPE, CLASS_BOSS_BAR_ACTION));
                }
                catch (Throwable error) {
                    Knob.logError(error, "Failed to initialize CraftBossBar constructor", new Object[0]);
                }
            }
            CRAFT_BOSS_BAR_HANDLE = craftBossBarHandle;
            NMS_BOSS_BATTLE_SET_NAME = nmsBossBattleSetName;
            NMS_BOSS_BATTLE_SEND_UPDATE = nmsBossBattleSendUpdate;
        }

        public static class Builder
        extends CraftBukkitFacet<Player>
        implements Facet.BossBar.Builder<Player, BossBar> {
            protected Builder() {
                super(Player.class);
            }

            @Override
            public boolean isSupported() {
                return super.isSupported() && CLASS_CRAFT_BOSS_BAR != null && CRAFT_BOSS_BAR_HANDLE != null && NMS_BOSS_BATTLE_SET_NAME != null && NMS_BOSS_BATTLE_SEND_UPDATE != null;
            }

            @Override
            public @NonNull BossBar createBossBar(@NonNull Collection<Player> viewers) {
                return new BossBar(viewers);
            }
        }
    }

    static final class BookPre1_13
    extends AbstractBook {
        private static final String PACKET_TYPE_BOOK_OPEN = "MC|BOpen";
        private static final Class<?> CLASS_BYTE_BUF = MinecraftReflection.findClass("io.netty.buffer.ByteBuf");
        private static final Class<?> CLASS_PACKET_CUSTOM_PAYLOAD = MinecraftReflection.findNmsClass("PacketPlayOutCustomPayload");
        private static final Class<?> CLASS_PACKET_DATA_SERIALIZER = MinecraftReflection.findNmsClass("PacketDataSerializer");
        private static final MethodHandle NEW_PACKET_CUSTOM_PAYLOAD = MinecraftReflection.findConstructor(CLASS_PACKET_CUSTOM_PAYLOAD, String.class, CLASS_PACKET_DATA_SERIALIZER);
        private static final MethodHandle NEW_PACKET_BYTE_BUF = MinecraftReflection.findConstructor(CLASS_PACKET_DATA_SERIALIZER, CLASS_BYTE_BUF);

        BookPre1_13() {
        }

        @Override
        public boolean isSupported() {
            return super.isSupported() && CLASS_BYTE_BUF != null && CLASS_PACKET_CUSTOM_PAYLOAD != null && NEW_PACKET_CUSTOM_PAYLOAD != null;
        }

        @Override
        protected void sendOpenPacket(@NonNull Player viewer) throws Throwable {
            ByteBuf data = Unpooled.buffer();
            data.writeByte(0);
            Object packetByteBuf = NEW_PACKET_BYTE_BUF.invoke(data);
            this.sendMessage(viewer, NEW_PACKET_CUSTOM_PAYLOAD.invoke(PACKET_TYPE_BOOK_OPEN, packetByteBuf));
        }
    }

    static final class Book1_13
    extends AbstractBook {
        private static final Class<?> CLASS_BYTE_BUF = MinecraftReflection.findClass("io.netty.buffer.ByteBuf");
        private static final Class<?> CLASS_PACKET_CUSTOM_PAYLOAD = MinecraftReflection.findNmsClass("PacketPlayOutCustomPayload");
        private static final Class<?> CLASS_FRIENDLY_BYTE_BUF = MinecraftReflection.findNmsClass("PacketDataSerializer");
        private static final Class<?> CLASS_RESOURCE_LOCATION = MinecraftReflection.findNmsClass("MinecraftKey");
        private static final Object PACKET_TYPE_BOOK_OPEN;
        private static final MethodHandle NEW_PACKET_CUSTOM_PAYLOAD;
        private static final MethodHandle NEW_FRIENDLY_BYTE_BUF;

        Book1_13() {
        }

        @Override
        public boolean isSupported() {
            return super.isSupported() && CLASS_BYTE_BUF != null && NEW_PACKET_CUSTOM_PAYLOAD != null && PACKET_TYPE_BOOK_OPEN != null;
        }

        @Override
        protected void sendOpenPacket(@NonNull Player viewer) throws Throwable {
            ByteBuf data = Unpooled.buffer();
            data.writeByte(0);
            Object packetByteBuf = NEW_FRIENDLY_BYTE_BUF.invoke(data);
            this.sendMessage(viewer, NEW_PACKET_CUSTOM_PAYLOAD.invoke(PACKET_TYPE_BOOK_OPEN, packetByteBuf));
        }

        static {
            NEW_PACKET_CUSTOM_PAYLOAD = MinecraftReflection.findConstructor(CLASS_PACKET_CUSTOM_PAYLOAD, CLASS_RESOURCE_LOCATION, CLASS_FRIENDLY_BYTE_BUF);
            NEW_FRIENDLY_BYTE_BUF = MinecraftReflection.findConstructor(CLASS_FRIENDLY_BYTE_BUF, CLASS_BYTE_BUF);
            Object packetType = null;
            if (CLASS_RESOURCE_LOCATION != null) {
                try {
                    packetType = CLASS_RESOURCE_LOCATION.getConstructor(String.class).newInstance("minecraft:book_open");
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
            PACKET_TYPE_BOOK_OPEN = packetType;
        }
    }

    static final class BookPost1_13
    extends AbstractBook {
        private static final Class<?> CLASS_ENUM_HAND = MinecraftReflection.findNmsClass("EnumHand");
        private static final Object HAND_MAIN = MinecraftReflection.findEnum(CLASS_ENUM_HAND, "MAIN_HAND", 0);
        private static final Class<?> PACKET_OPEN_BOOK = MinecraftReflection.findNmsClass("PacketPlayOutOpenBook");
        private static final MethodHandle NEW_PACKET_OPEN_BOOK = MinecraftReflection.findConstructor(PACKET_OPEN_BOOK, CLASS_ENUM_HAND);

        BookPost1_13() {
        }

        @Override
        public boolean isSupported() {
            return super.isSupported() && HAND_MAIN != null && NEW_PACKET_OPEN_BOOK != null;
        }

        @Override
        protected void sendOpenPacket(@NonNull Player viewer) throws Throwable {
            this.sendMessage(viewer, NEW_PACKET_OPEN_BOOK.invoke(HAND_MAIN));
        }
    }

    protected static abstract class AbstractBook
    extends PacketFacet<Player>
    implements Facet.Book<Player, Object, ItemStack> {
        protected static final int HAND_MAIN = 0;
        private static final Material BOOK_TYPE = (Material)MinecraftReflection.findEnum(Material.class, "WRITTEN_BOOK");
        private static final ItemStack BOOK_STACK = BOOK_TYPE == null ? null : new ItemStack(BOOK_TYPE);
        private static final String BOOK_TITLE = "title";
        private static final String BOOK_AUTHOR = "author";
        private static final String BOOK_PAGES = "pages";
        private static final String BOOK_RESOLVED = "resolved";
        private static final Class<?> CLASS_NBT_TAG_COMPOUND = MinecraftReflection.findNmsClass("NBTTagCompound");
        private static final Class<?> CLASS_NBT_IO = MinecraftReflection.findNmsClass("NBTCompressedStreamTools");
        private static final MethodHandle NBT_IO_DESERIALIZE;
        private static final Class<?> CLASS_CRAFT_ITEMSTACK;
        private static final Class<?> CLASS_MC_ITEMSTACK;
        private static final MethodHandle MC_ITEMSTACK_SET_TAG;
        private static final MethodHandle MC_ITEMSTACK_GET_TAG;
        private static final MethodHandle CRAFT_ITEMSTACK_NMS_COPY;
        private static final MethodHandle CRAFT_ITEMSTACK_CRAFT_MIRROR;

        protected AbstractBook() {
        }

        protected abstract void sendOpenPacket(@NonNull Player var1) throws Throwable;

        @Override
        public boolean isSupported() {
            return super.isSupported() && NBT_IO_DESERIALIZE != null && MC_ITEMSTACK_SET_TAG != null && CRAFT_ITEMSTACK_CRAFT_MIRROR != null && CRAFT_ITEMSTACK_NMS_COPY != null && BOOK_STACK != null;
        }

        @Override
        public @NonNull String createMessage(@NonNull Player viewer, @NonNull Component message) {
            return (String)BukkitComponentSerializer.gson().serialize(message);
        }

        @Override
        public @NonNull ItemStack createBook(@NonNull Object title, @NonNull Object author, @NonNull Iterable<Object> pages) {
            return this.applyTag(BOOK_STACK, AbstractBook.tagFor(title, author, pages));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public void openBook(@NonNull Player viewer, @NonNull ItemStack book) {
            PlayerInventory inventory = viewer.getInventory();
            ItemStack current = inventory.getItemInHand();
            try {
                inventory.setItemInHand(book);
                this.sendOpenPacket(viewer);
            }
            catch (Throwable error) {
                Knob.logError(error, "Failed to send openBook packet: %s", book);
            }
            finally {
                inventory.setItemInHand(current);
            }
        }

        private static CompoundBinaryTag tagFor(@NonNull Object title, @NonNull Object author, @NonNull Iterable<Object> pages) {
            ListBinaryTag.Builder<StringBinaryTag> builder = ListBinaryTag.builder(BinaryTagTypes.STRING);
            for (Object page : pages) {
                builder.add(StringBinaryTag.of((String)page));
            }
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString(BOOK_TITLE, (String)title)).putString(BOOK_AUTHOR, (String)author)).put(BOOK_PAGES, builder.build())).putByte(BOOK_RESOLVED, (byte)1)).build();
        }

        private @NonNull Object createTag(@NonNull CompoundBinaryTag tag) throws IOException {
            Object object;
            TrustedByteArrayOutputStream output = new TrustedByteArrayOutputStream();
            BinaryTagIO.writeOutputStream(tag, output);
            DataInputStream dis = new DataInputStream(output.toInputStream());
            try {
                object = NBT_IO_DESERIALIZE.invoke(dis);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        dis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable err) {
                    throw new IOException(err);
                }
            }
            dis.close();
            return object;
        }

        private ItemStack applyTag(@NonNull ItemStack input, CompoundBinaryTag binTag) {
            if (CRAFT_ITEMSTACK_NMS_COPY == null || MC_ITEMSTACK_SET_TAG == null || CRAFT_ITEMSTACK_CRAFT_MIRROR == null) {
                return input;
            }
            try {
                Object stack = CRAFT_ITEMSTACK_NMS_COPY.invoke(input);
                Object tag = this.createTag(binTag);
                MC_ITEMSTACK_SET_TAG.invoke(stack, tag);
                return CRAFT_ITEMSTACK_CRAFT_MIRROR.invoke(stack);
            }
            catch (Throwable error) {
                Knob.logError(error, "Failed to apply NBT tag to ItemStack: %s %s", input, binTag);
                return input;
            }
        }

        static {
            MethodHandle nbtIoDeserialize = null;
            if (CLASS_NBT_IO != null) {
                for (Method method : CLASS_NBT_IO.getDeclaredMethods()) {
                    Class<?> firstParam;
                    if (!Modifier.isStatic(method.getModifiers()) || !method.getReturnType().equals(CLASS_NBT_TAG_COMPOUND) || method.getParameterCount() != 1 || !(firstParam = method.getParameterTypes()[0]).equals(DataInputStream.class) && !firstParam.equals(DataInput.class)) continue;
                    try {
                        nbtIoDeserialize = MinecraftReflection.lookup().unreflect(method);
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                    break;
                }
            }
            NBT_IO_DESERIALIZE = nbtIoDeserialize;
            CLASS_CRAFT_ITEMSTACK = MinecraftReflection.findCraftClass("inventory.CraftItemStack");
            CLASS_MC_ITEMSTACK = MinecraftReflection.findNmsClass("ItemStack");
            MC_ITEMSTACK_SET_TAG = MinecraftReflection.findMethod(CLASS_MC_ITEMSTACK, "setTag", Void.TYPE, CLASS_NBT_TAG_COMPOUND);
            MC_ITEMSTACK_GET_TAG = MinecraftReflection.findMethod(CLASS_MC_ITEMSTACK, "getTag", CLASS_NBT_TAG_COMPOUND, new Class[0]);
            CRAFT_ITEMSTACK_NMS_COPY = MinecraftReflection.findStaticMethod(CLASS_CRAFT_ITEMSTACK, "asNMSCopy", CLASS_MC_ITEMSTACK, ItemStack.class);
            CRAFT_ITEMSTACK_CRAFT_MIRROR = MinecraftReflection.findStaticMethod(CLASS_CRAFT_ITEMSTACK, "asCraftMirror", CLASS_CRAFT_ITEMSTACK, CLASS_MC_ITEMSTACK);
        }

        private static final class TrustedByteArrayOutputStream
        extends ByteArrayOutputStream {
            private TrustedByteArrayOutputStream() {
            }

            public InputStream toInputStream() {
                return new ByteArrayInputStream(this.buf, 0, this.count);
            }
        }
    }

    static class Title
    extends PacketFacet<Player>
    implements Facet.Title<Player, Object, List<?>> {
        Title() {
        }

        @Override
        public boolean isSupported() {
            return super.isSupported() && CONSTRUCTOR_TITLE_MESSAGE != null && CONSTRUCTOR_TITLE_TIMES != null;
        }

        @Override
        public @NonNull List<?> createTitle(@Nullable Object title, @Nullable Object subTitle, int inTicks, int stayTicks, int outTicks) {
            LinkedList<Object> packets = new LinkedList<Object>();
            try {
                if (subTitle != null) {
                    packets.add(CONSTRUCTOR_TITLE_MESSAGE.invoke(TITLE_ACTION_SUBTITLE, subTitle));
                }
                if (inTicks != -1 || stayTicks != -1 || outTicks != -1) {
                    packets.add(CONSTRUCTOR_TITLE_TIMES.invoke(inTicks, stayTicks, outTicks));
                }
                if (title != null) {
                    packets.add(CONSTRUCTOR_TITLE_MESSAGE.invoke(TITLE_ACTION_TITLE, title));
                }
            }
            catch (Throwable error) {
                Knob.logError(error, "Failed to invoke PacketPlayOutTitle constructor", new Object[0]);
            }
            return packets;
        }

        @Override
        public void showTitle(@NonNull Player viewer, @NonNull List<?> packets) {
            for (Object packet : packets) {
                this.sendMessage(viewer, packet);
            }
        }

        @Override
        public void clearTitle(@NonNull Player viewer) {
            try {
                if (TITLE_ACTION_CLEAR != null) {
                    this.sendPacket(viewer, CONSTRUCTOR_TITLE_MESSAGE.invoke(TITLE_ACTION_CLEAR, null));
                } else {
                    viewer.sendTitle("", "", -1, -1, -1);
                }
            }
            catch (Throwable error) {
                Knob.logError(error, "Failed to clear title", new Object[0]);
            }
        }

        @Override
        public void resetTitle(@NonNull Player viewer) {
            try {
                if (TITLE_ACTION_RESET != null) {
                    this.sendPacket(viewer, CONSTRUCTOR_TITLE_MESSAGE.invoke(TITLE_ACTION_RESET, null));
                } else {
                    viewer.resetTitle();
                }
            }
            catch (Throwable error) {
                Knob.logError(error, "Failed to clear title", new Object[0]);
            }
        }
    }

    static class ActionBarLegacy
    extends PacketFacet<Player>
    implements Facet.ActionBar<Player, Object> {
        ActionBarLegacy() {
        }

        @Override
        public boolean isSupported() {
            return super.isSupported() && LEGACY_CHAT_PACKET_CONSTRUCTOR != null;
        }

        @Override
        public @Nullable Object createMessage(@NonNull Player viewer, @NonNull Component message) {
            TextComponent legacyMessage = Component.text(BukkitComponentSerializer.legacy().serialize(message));
            try {
                return LEGACY_CHAT_PACKET_CONSTRUCTOR.invoke(super.createMessage(viewer, (Component)legacyMessage), (byte)2);
            }
            catch (Throwable error) {
                Knob.logError(error, "Failed to invoke PacketPlayOutChat constructor: %s", legacyMessage);
                return null;
            }
        }
    }

    static class ActionBar
    extends PacketFacet<Player>
    implements Facet.ActionBar<Player, Object> {
        ActionBar() {
        }

        @Override
        public boolean isSupported() {
            return super.isSupported() && TITLE_ACTION_ACTIONBAR != null;
        }

        @Override
        public @Nullable Object createMessage(@NonNull Player viewer, @NonNull Component message) {
            try {
                return CONSTRUCTOR_TITLE_MESSAGE.invoke(TITLE_ACTION_ACTIONBAR, super.createMessage(viewer, message));
            }
            catch (Throwable error) {
                Knob.logError(error, "Failed to invoke PacketPlayOutTitle constructor: %s", message);
                return null;
            }
        }
    }

    static class Chat
    extends PacketFacet<CommandSender>
    implements Facet.Chat<CommandSender, Object> {
        Chat() {
        }

        @Override
        public boolean isSupported() {
            return super.isSupported() && CHAT_PACKET_CONSTRUCTOR != null;
        }

        @Override
        public void sendMessage(@NonNull CommandSender viewer, @NonNull Identity source, @NonNull Object message, @NonNull MessageType type) {
            Object messageType = type == MessageType.CHAT ? MESSAGE_TYPE_CHAT : MESSAGE_TYPE_SYSTEM;
            try {
                this.sendMessage(viewer, CHAT_PACKET_CONSTRUCTOR.invoke(message, messageType, source.uuid()));
            }
            catch (Throwable error) {
                Knob.logError(error, "Failed to invoke PacketPlayOutChat constructor: %s %s", message, messageType);
            }
        }
    }

    static class PacketFacet<V extends CommandSender>
    extends CraftBukkitFacet<V>
    implements Facet.Message<V, Object> {
        protected PacketFacet() {
            super(CLASS_CRAFT_PLAYER);
        }

        public void sendPacket(@NonNull Player player, @Nullable Object packet) {
            if (packet == null) {
                return;
            }
            try {
                PLAYER_CONNECTION_SEND_PACKET.invoke(ENTITY_PLAYER_GET_CONNECTION.invoke(CRAFT_PLAYER_GET_HANDLE.invoke(player)), packet);
            }
            catch (Throwable error) {
                Knob.logError(error, "Failed to invoke CraftBukkit sendPacket: %s", packet);
            }
        }

        public void sendMessage(@NonNull V player, @Nullable Object packet) {
            this.sendPacket((Player)player, packet);
        }

        @Override
        public @Nullable Object createMessage(@NonNull V viewer, @NonNull Component message) {
            try {
                return MinecraftComponentSerializer.get().serialize(message);
            }
            catch (Throwable error) {
                Knob.logError(error, "Failed to serialize net.minecraft.server IChatBaseComponent: %s", message);
                return null;
            }
        }
    }
}

