/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.kyori.adventure.text;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.AbstractComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.AbstractComponentBuilder;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.ComponentLike;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.NBTComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.NBTComponentBuilder;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.format.Style;
import ca.stellardrift.permissionsex.ext.kyori.examination.ExaminableProperty;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

abstract class NBTComponentImpl<C extends NBTComponent<C, B>, B extends NBTComponentBuilder<C, B>>
extends AbstractComponent
implements NBTComponent<C, B> {
    static final boolean INTERPRET_DEFAULT = false;
    final String nbtPath;
    final boolean interpret;

    NBTComponentImpl(@NonNull List<? extends ComponentLike> children, @NonNull Style style, String nbtPath, boolean interpret) {
        super(children, style);
        this.nbtPath = nbtPath;
        this.interpret = interpret;
    }

    @Override
    public @NonNull String nbtPath() {
        return this.nbtPath;
    }

    @Override
    public boolean interpret() {
        return this.interpret;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NBTComponent)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        NBTComponent that = (NBTComponent)other;
        return Objects.equals(this.nbtPath, that.nbtPath()) && this.interpret == that.interpret();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.nbtPath.hashCode();
        result = 31 * result + Boolean.hashCode(this.interpret);
        return result;
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.concat(Stream.of(ExaminableProperty.of("nbtPath", this.nbtPath), ExaminableProperty.of("interpret", this.interpret)), super.examinableProperties());
    }

    static abstract class BuilderImpl<C extends NBTComponent<C, B>, B extends NBTComponentBuilder<C, B>>
    extends AbstractComponentBuilder<C, B>
    implements NBTComponentBuilder<C, B> {
        protected @Nullable String nbtPath;
        protected boolean interpret = false;

        BuilderImpl() {
        }

        BuilderImpl(@NonNull C component) {
            super(component);
            this.nbtPath = component.nbtPath();
            this.interpret = component.interpret();
        }

        @Override
        public @NonNull B nbtPath(@NonNull String nbtPath) {
            this.nbtPath = nbtPath;
            return (B)this;
        }

        @Override
        public @NonNull B interpret(boolean interpret) {
            this.interpret = interpret;
            return (B)this;
        }
    }
}

