/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.kyori.adventure.text;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.AbstractComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.AbstractComponentBuilder;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.ComponentLike;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.TextComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.format.Style;
import ca.stellardrift.permissionsex.ext.kyori.examination.ExaminableProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

final class TextComponentImpl
extends AbstractComponent
implements TextComponent {
    static final TextComponent EMPTY = TextComponentImpl.createDirect("");
    static final TextComponent NEWLINE = TextComponentImpl.createDirect("\n");
    static final TextComponent SPACE = TextComponentImpl.createDirect(" ");
    private final String content;

    private static @NonNull TextComponent createDirect(@NonNull String content) {
        return new TextComponentImpl(Collections.emptyList(), Style.empty(), content);
    }

    TextComponentImpl(@NonNull List<? extends ComponentLike> children, @NonNull Style style, @NonNull String content) {
        super(children, style);
        this.content = content;
    }

    @Override
    public @NonNull String content() {
        return this.content;
    }

    @Override
    public @NonNull TextComponent content(@NonNull String content) {
        if (Objects.equals(this.content, content)) {
            return this;
        }
        return new TextComponentImpl(this.children, this.style, Objects.requireNonNull(content, "content"));
    }

    @Override
    public @NonNull TextComponent children(@NonNull List<? extends ComponentLike> children) {
        return new TextComponentImpl(children, this.style, this.content);
    }

    @Override
    public @NonNull TextComponent style(@NonNull Style style) {
        return new TextComponentImpl(this.children, style, this.content);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextComponentImpl)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        TextComponentImpl that = (TextComponentImpl)other;
        return Objects.equals(this.content, that.content);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.content.hashCode();
        return result;
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.concat(Stream.of(ExaminableProperty.of("content", this.content)), super.examinableProperties());
    }

    @Override
    public @NonNull TextComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    extends AbstractComponentBuilder<TextComponent, TextComponent.Builder>
    implements TextComponent.Builder {
        private String content = "";

        BuilderImpl() {
        }

        BuilderImpl(@NonNull TextComponent component) {
            super(component);
            this.content = component.content();
        }

        @Override
        public @NonNull TextComponent.Builder content(@NonNull String content) {
            this.content = Objects.requireNonNull(content, "content");
            return this;
        }

        @Override
        public @NonNull String content() {
            return this.content;
        }

        @Override
        public @NonNull TextComponent build() {
            if (this.isEmpty()) {
                return Component.empty();
            }
            return new TextComponentImpl(this.children, this.buildStyle(), this.content);
        }

        private boolean isEmpty() {
            return this.content.isEmpty() && this.children.isEmpty() && !this.hasStyle();
        }
    }
}

