/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.kyori.adventure.text;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.regex.qual.Regex;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.ComponentLike;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.PatternReplacementResult;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.TextComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.TextReplacementConfigImpl;
import ca.stellardrift.permissionsex.ext.kyori.adventure.util.Buildable;
import ca.stellardrift.permissionsex.ext.kyori.adventure.util.IntFunction2;
import ca.stellardrift.permissionsex.ext.kyori.examination.Examinable;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public interface TextReplacementConfig
extends Buildable<TextReplacementConfig, Builder>,
Examinable {
    public static @NonNull Builder builder() {
        return new TextReplacementConfigImpl.Builder();
    }

    public @NonNull Pattern matchPattern();

    public static interface Builder
    extends Buildable.Builder<TextReplacementConfig> {
        default public Builder matchLiteral(String literal) {
            return this.match(Pattern.compile(literal, 16));
        }

        default public @NonNull Builder match(@NonNull @Regex String pattern) {
            return this.match(Pattern.compile(pattern));
        }

        public @NonNull Builder match(@NonNull Pattern var1);

        default public @NonNull Builder once() {
            return this.times(1);
        }

        default public @NonNull Builder times(int times) {
            return this.condition((index, replaced) -> replaced < times ? PatternReplacementResult.REPLACE : PatternReplacementResult.STOP);
        }

        public @NonNull Builder condition(@NonNull IntFunction2<PatternReplacementResult> var1);

        default public @NonNull Builder replacement(@NonNull String replacement) {
            Objects.requireNonNull(replacement, "replacement");
            return this.replacement((TextComponent.Builder builder) -> builder.content(replacement));
        }

        default public @NonNull Builder replacement(@Nullable ComponentLike replacement) {
            @Nullable Component baked = replacement == null ? null : replacement.asComponent();
            return this.replacement((MatchResult result, TextComponent.Builder input) -> baked);
        }

        default public @NonNull Builder replacement(@NonNull Function<TextComponent.Builder, @Nullable ComponentLike> replacement) {
            Objects.requireNonNull(replacement, "replacement");
            return this.replacement((MatchResult result, TextComponent.Builder input) -> (ComponentLike)replacement.apply((TextComponent.Builder)input));
        }

        public @NonNull Builder replacement(@NonNull BiFunction<MatchResult, TextComponent.Builder, @Nullable ComponentLike> var1);
    }
}

