/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.kyori.adventure.text.renderer;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.BlockNBTComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.EntityNBTComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.KeybindComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.NBTComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.ScoreComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.SelectorComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.StorageNBTComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.TextComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.TranslatableComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.renderer.ComponentRenderer;

public abstract class AbstractComponentRenderer<C>
implements ComponentRenderer<C> {
    @Override
    public @NonNull Component render(@NonNull Component component, @NonNull C context) {
        if (component instanceof TextComponent) {
            return this.renderText((TextComponent)component, context);
        }
        if (component instanceof TranslatableComponent) {
            return this.renderTranslatable((TranslatableComponent)component, context);
        }
        if (component instanceof KeybindComponent) {
            return this.renderKeybind((KeybindComponent)component, context);
        }
        if (component instanceof ScoreComponent) {
            return this.renderScore((ScoreComponent)component, context);
        }
        if (component instanceof SelectorComponent) {
            return this.renderSelector((SelectorComponent)component, context);
        }
        if (component instanceof NBTComponent) {
            if (component instanceof BlockNBTComponent) {
                return this.renderBlockNbt((BlockNBTComponent)component, context);
            }
            if (component instanceof EntityNBTComponent) {
                return this.renderEntityNbt((EntityNBTComponent)component, context);
            }
            if (component instanceof StorageNBTComponent) {
                return this.renderStorageNbt((StorageNBTComponent)component, context);
            }
        }
        return component;
    }

    protected abstract @NonNull Component renderBlockNbt(@NonNull BlockNBTComponent var1, @NonNull C var2);

    protected abstract @NonNull Component renderEntityNbt(@NonNull EntityNBTComponent var1, @NonNull C var2);

    protected abstract @NonNull Component renderStorageNbt(@NonNull StorageNBTComponent var1, @NonNull C var2);

    protected abstract @NonNull Component renderKeybind(@NonNull KeybindComponent var1, @NonNull C var2);

    protected abstract @NonNull Component renderScore(@NonNull ScoreComponent var1, @NonNull C var2);

    protected abstract @NonNull Component renderSelector(@NonNull SelectorComponent var1, @NonNull C var2);

    protected abstract @NonNull Component renderText(@NonNull TextComponent var1, @NonNull C var2);

    protected abstract @NonNull Component renderTranslatable(@NonNull TranslatableComponent var1, @NonNull C var2);
}

