/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.kyori.adventure.text.serializer.craftbukkit;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.checkerframework.common.reflection.qual.ForName;
import com.google.common.annotations.Beta;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.Objects;
import org.bukkit.Bukkit;

@Beta
public final class MinecraftReflection {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final String PREFIX_NMS = "net.minecraft.server";
    private static final String PREFIX_CRAFTBUKKIT = "org.bukkit.craftbukkit";
    private static final String CRAFT_SERVER = "CraftServer";
    private static final @Nullable String VERSION;

    private MinecraftReflection() {
    }

    @ForName
    public static @Nullable Class<?> findClass(@NonNull String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean hasClass(@NonNull String className) {
        return MinecraftReflection.findClass(className) != null;
    }

    public static @Nullable MethodHandle findMethod(@Nullable Class<?> holderClass, String methodName, @Nullable Class<?> returnClass, Class<?> ... parameterClasses) {
        if (holderClass == null || returnClass == null) {
            return null;
        }
        for (Class<?> parameterClass : parameterClasses) {
            if (parameterClass != null) continue;
            return null;
        }
        try {
            return LOOKUP.findVirtual(holderClass, methodName, MethodType.methodType(returnClass, parameterClasses));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }

    public static @Nullable MethodHandle findStaticMethod(@Nullable Class<?> holderClass, String methodName, @Nullable Class<?> returnClass, Class<?> ... parameterClasses) {
        if (holderClass == null || returnClass == null) {
            return null;
        }
        for (Class<?> parameterClass : parameterClasses) {
            if (parameterClass != null) continue;
            return null;
        }
        try {
            return LOOKUP.findStatic(holderClass, methodName, MethodType.methodType(returnClass, parameterClasses));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }

    public static boolean hasMethod(@Nullable Class<?> holderClass, String methodName, Class<?> ... parameterClasses) {
        if (holderClass == null) {
            return false;
        }
        for (Class<?> parameterClass : parameterClasses) {
            if (parameterClass != null) continue;
            return false;
        }
        try {
            holderClass.getMethod(methodName, parameterClasses);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static @Nullable MethodHandle findConstructor(@Nullable Class<?> holderClass, Class<?> ... parameterClasses) {
        if (holderClass == null) {
            return null;
        }
        for (Class<?> parameterClass : parameterClasses) {
            if (parameterClass != null) continue;
            return null;
        }
        try {
            return LOOKUP.findConstructor(holderClass, MethodType.methodType(Void.TYPE, parameterClasses));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }

    public static @NonNull Field needField(@NonNull Class<?> holderClass, @NonNull String fieldName) throws NoSuchFieldException {
        Field field = holderClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field;
    }

    public static @Nullable Field findField(@Nullable Class<?> holderClass, @NonNull String fieldName) {
        return MinecraftReflection.findField(holderClass, fieldName, null);
    }

    public static @Nullable Field findField(@Nullable Class<?> holderClass, @NonNull String fieldName, @Nullable Class<?> expectedType) {
        Field field;
        if (holderClass == null) {
            return null;
        }
        try {
            field = holderClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
        field.setAccessible(true);
        if (expectedType != null && !expectedType.isAssignableFrom(field.getType())) {
            return null;
        }
        return field;
    }

    public static @Nullable MethodHandle findSetterOf(@Nullable Field field) {
        if (field == null) {
            return null;
        }
        try {
            return LOOKUP.unreflectSetter(field);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static @Nullable MethodHandle findGetterOf(@Nullable Field field) {
        if (field == null) {
            return null;
        }
        try {
            return LOOKUP.unreflectGetter(field);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static @Nullable Object findEnum(@Nullable Class<?> enumClass, @NonNull String enumName) {
        return MinecraftReflection.findEnum(enumClass, enumName, Integer.MAX_VALUE);
    }

    public static @Nullable Object findEnum(@Nullable Class<?> enumClass, @NonNull String enumName, int enumFallbackOrdinal) {
        if (enumClass == null || !Enum.class.isAssignableFrom(enumClass)) {
            return null;
        }
        try {
            return Enum.valueOf(enumClass.asSubclass(Enum.class), enumName);
        }
        catch (IllegalArgumentException e) {
            ?[] constants = enumClass.getEnumConstants();
            if (constants.length > enumFallbackOrdinal) {
                return constants[enumFallbackOrdinal];
            }
            return null;
        }
    }

    public static boolean isCraftBukkit() {
        return VERSION != null;
    }

    public static @Nullable String findCraftClassName(@NonNull String className) {
        return MinecraftReflection.isCraftBukkit() ? PREFIX_CRAFTBUKKIT + VERSION + className : null;
    }

    @ForName
    public static @Nullable Class<?> findCraftClass(@NonNull String className) {
        String craftClassName = MinecraftReflection.findCraftClassName(className);
        if (craftClassName == null) {
            return null;
        }
        return MinecraftReflection.findClass(craftClassName);
    }

    @ForName
    public static <T> @Nullable Class<? extends T> findCraftClass(@NonNull String className, @NonNull Class<T> superClass) {
        Class<?> craftClass = MinecraftReflection.findCraftClass(className);
        if (craftClass == null || !Objects.requireNonNull(superClass, "superClass").isAssignableFrom(craftClass)) {
            return null;
        }
        return craftClass.asSubclass(superClass);
    }

    @ForName
    public static @NonNull Class<?> needCraftClass(@NonNull String className) {
        return Objects.requireNonNull(MinecraftReflection.findCraftClass(className), "Could not find org.bukkit.craftbukkit class " + className);
    }

    public static @Nullable String findNmsClassName(@NonNull String className) {
        return MinecraftReflection.isCraftBukkit() ? PREFIX_NMS + VERSION + className : null;
    }

    @ForName
    public static @Nullable Class<?> findNmsClass(@NonNull String className) {
        String nmsClassName = MinecraftReflection.findNmsClassName(className);
        if (nmsClassName == null) {
            return null;
        }
        return MinecraftReflection.findClass(nmsClassName);
    }

    @ForName
    public static @NonNull Class<?> needNmsClass(@NonNull String className) {
        return Objects.requireNonNull(MinecraftReflection.findNmsClass(className), "Could not find net.minecraft.server class " + className);
    }

    public static @NonNull MethodHandles.Lookup lookup() {
        return LOOKUP;
    }

    static {
        Class<?> serverClass = Bukkit.getServer().getClass();
        if (!serverClass.getSimpleName().equals(CRAFT_SERVER)) {
            VERSION = null;
        } else if (serverClass.getName().equals("org.bukkit.craftbukkit.CraftServer")) {
            VERSION = ".";
        } else {
            String name = serverClass.getName();
            name = name.substring(PREFIX_CRAFTBUKKIT.length());
            VERSION = name = name.substring(0, name.length() - CRAFT_SERVER.length());
        }
    }
}

