/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.kyori.adventure.text.serializer.plain;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.KeybindComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.ScoreComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.SelectorComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.TextComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.TranslatableComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.serializer.ComponentSerializer;
import java.util.function.Function;

public class PlainComponentSerializer
implements ComponentSerializer<Component, TextComponent, String> {
    private static final PlainComponentSerializer INSTANCE = new PlainComponentSerializer();
    private final @Nullable Function<KeybindComponent, String> keybind;
    private final @Nullable Function<TranslatableComponent, String> translatable;

    public static @NonNull PlainComponentSerializer plain() {
        return INSTANCE;
    }

    public PlainComponentSerializer() {
        this(null, null);
    }

    public PlainComponentSerializer(@Nullable Function<KeybindComponent, String> keybind, @Nullable Function<TranslatableComponent, String> translatable) {
        this.keybind = keybind;
        this.translatable = translatable;
    }

    @Override
    public @NonNull TextComponent deserialize(@NonNull String input) {
        return Component.text(input);
    }

    @Override
    public @NonNull String serialize(@NonNull Component component) {
        StringBuilder sb = new StringBuilder();
        this.serialize(sb, component);
        return sb.toString();
    }

    public void serialize(@NonNull StringBuilder sb, @NonNull Component component) {
        if (component instanceof KeybindComponent) {
            if (this.keybind != null) {
                sb.append(this.keybind.apply((KeybindComponent)component));
            }
        } else if (component instanceof ScoreComponent) {
            sb.append(((ScoreComponent)component).value());
        } else if (component instanceof SelectorComponent) {
            sb.append(((SelectorComponent)component).pattern());
        } else if (component instanceof TextComponent) {
            sb.append(((TextComponent)component).content());
        } else if (component instanceof TranslatableComponent) {
            if (this.translatable != null) {
                sb.append(this.translatable.apply((TranslatableComponent)component));
            }
        } else {
            throw new UnsupportedOperationException("Don't know how to turn " + component.getClass().getSimpleName() + " into a string");
        }
        for (Component child : component.children()) {
            this.serialize(sb, child);
        }
    }
}

