/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.kyori.adventure.title;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.kyori.adventure.title.Title;
import ca.stellardrift.permissionsex.ext.kyori.examination.ExaminableProperty;
import ca.stellardrift.permissionsex.ext.kyori.examination.string.StringExaminer;
import java.time.Duration;
import java.util.Objects;
import java.util.stream.Stream;

final class TitleImpl
implements Title {
    private final Component title;
    private final Component subtitle;
    private final @Nullable Title.Times times;

    TitleImpl(@NonNull Component title, @NonNull Component subtitle, @Nullable Title.Times times) {
        this.title = title;
        this.subtitle = subtitle;
        this.times = times;
    }

    @Override
    public @NonNull Component title() {
        return this.title;
    }

    @Override
    public @NonNull Component subtitle() {
        return this.subtitle;
    }

    @Override
    public @Nullable Title.Times times() {
        return this.times;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TitleImpl that = (TitleImpl)other;
        return this.title.equals(that.title) && this.subtitle.equals(that.subtitle) && Objects.equals(this.times, that.times);
    }

    public int hashCode() {
        int result = this.title.hashCode();
        result = 31 * result + this.subtitle.hashCode();
        result = 31 * result + Objects.hashCode(this.times);
        return result;
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("title", this.title), ExaminableProperty.of("subtitle", this.subtitle), ExaminableProperty.of("times", this.times));
    }

    public String toString() {
        return this.examine(StringExaminer.simpleEscaping());
    }

    static class TimesImpl
    implements Title.Times {
        private final Duration fadeIn;
        private final Duration stay;
        private final Duration fadeOut;

        TimesImpl(Duration fadeIn, Duration stay, Duration fadeOut) {
            this.fadeIn = fadeIn;
            this.stay = stay;
            this.fadeOut = fadeOut;
        }

        @Override
        public @NonNull Duration fadeIn() {
            return this.fadeIn;
        }

        @Override
        public @NonNull Duration stay() {
            return this.stay;
        }

        @Override
        public @NonNull Duration fadeOut() {
            return this.fadeOut;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            TimesImpl that = (TimesImpl)other;
            return this.fadeIn.equals(that.fadeIn) && this.stay.equals(that.stay) && this.fadeOut.equals(that.fadeOut);
        }

        public int hashCode() {
            int result = this.fadeIn.hashCode();
            result = 31 * result + this.stay.hashCode();
            result = 31 * result + this.fadeOut.hashCode();
            return result;
        }

        @Override
        public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of("fadeIn", this.fadeIn), ExaminableProperty.of("stay", this.stay), ExaminableProperty.of("fadeOut", this.fadeOut));
        }

        public String toString() {
            return this.examine(StringExaminer.simpleEscaping());
        }
    }
}

