/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.ext.pcollections;

import ca.stellardrift.permissionsex.ext.pcollections.Empty;
import ca.stellardrift.permissionsex.ext.pcollections.PCollection;
import ca.stellardrift.permissionsex.ext.pcollections.PQueue;
import ca.stellardrift.permissionsex.ext.pcollections.PStack;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class AmortizedPQueue<E>
extends AbstractQueue<E>
implements PQueue<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final AmortizedPQueue<Object> EMPTY = new AmortizedPQueue();
    private final PStack<E> front;
    private final PStack<E> back;

    public static <E> AmortizedPQueue<E> empty() {
        return EMPTY;
    }

    private AmortizedPQueue() {
        this.front = Empty.stack();
        this.back = Empty.stack();
    }

    private AmortizedPQueue(AmortizedPQueue<E> queue, E e) {
        if (queue.front.size() == 0) {
            this.front = queue.front.plus(e);
            this.back = queue.back;
        } else {
            this.front = queue.front;
            this.back = queue.back.plus(e);
        }
    }

    private AmortizedPQueue(PStack<E> front, PStack<E> back) {
        this.front = front;
        this.back = back;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private PQueue<E> queue;
            {
                this.queue = AmortizedPQueue.this;
            }

            @Override
            public boolean hasNext() {
                return this.queue.size() > 0;
            }

            @Override
            public E next() {
                Object e = this.queue.peek();
                if (e == null && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.queue = this.queue.minus();
                return e;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.front.size() + this.back.size();
    }

    @Override
    public E peek() {
        if (this.size() == 0) {
            return null;
        }
        return this.front.get(0);
    }

    @Override
    public AmortizedPQueue<E> minus() {
        if (this.size() == 0) {
            return this;
        }
        int fsize = this.front.size();
        if (fsize == 0) {
            return new AmortizedPQueue(Empty.stack().plusAll(this.back), Empty.stack()).minus();
        }
        if (fsize == 1) {
            return new AmortizedPQueue(Empty.stack().plusAll(this.back), Empty.stack());
        }
        return new AmortizedPQueue<E>(this.front.minus(0), this.back);
    }

    @Override
    public AmortizedPQueue<E> plus(E e) {
        return new AmortizedPQueue<E>(this, e);
    }

    @Override
    public AmortizedPQueue<E> plusAll(Collection<? extends E> list) {
        PQueue<E> result = this;
        for (E e : list) {
            result = result.plus((Object)e);
        }
        return result;
    }

    @Override
    public PCollection<E> minus(Object e) {
        return Empty.vector().plusAll(this).minus(e);
    }

    @Override
    public PCollection<E> minusAll(Collection<?> list) {
        return Empty.vector().plusAll(this).minusAll(list);
    }

    @Override
    public boolean offer(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E poll() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) {
        PQueue queue = new AmortizedPQueue();
        PQueue original = queue = ((AmortizedPQueue)((AmortizedPQueue)((AmortizedPQueue)((AmortizedPQueue)((AmortizedPQueue)((AmortizedPQueue)((AmortizedPQueue)((AmortizedPQueue)((AmortizedPQueue)((AmortizedPQueue)queue).plus((Object)1)).minus()).minus()).plus((Object)2)).plus((Object)3)).plus((Object)4)).plus((Object)5)).minus()).plus((Object)6)).plus((Object)7);
        System.out.println("    \t" + ((AmortizedPQueue)queue).front + " " + ((AmortizedPQueue)queue).back);
        while (((AmortizedPQueue)queue).size() > 0) {
            int i = (Integer)((AmortizedPQueue)queue).peek();
            queue = ((AmortizedPQueue)queue).minus();
            System.out.println(i + " <- \t" + ((AmortizedPQueue)queue).front + " " + ((AmortizedPQueue)queue).back);
        }
        System.out.println(original);
    }
}

