/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.backend;

import ca.stellardrift.permissionsex.PermissionsEngine;
import ca.stellardrift.permissionsex.context.ContextInheritance;
import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.datastore.DataStore;
import ca.stellardrift.permissionsex.datastore.DataStoreContext;
import ca.stellardrift.permissionsex.datastore.DataStoreFactory;
import ca.stellardrift.permissionsex.datastore.ProtoDataStore;
import ca.stellardrift.permissionsex.exception.PermissionsException;
import ca.stellardrift.permissionsex.exception.PermissionsLoadingException;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.configurate.ConfigurationNode;
import ca.stellardrift.permissionsex.ext.configurate.serialize.SerializationException;
import ca.stellardrift.permissionsex.ext.configurate.util.CheckedSupplier;
import ca.stellardrift.permissionsex.ext.configurate.util.UnmodifiableCollections;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.impl.backend.Messages;
import ca.stellardrift.permissionsex.impl.util.CacheListenerHolder;
import ca.stellardrift.permissionsex.impl.util.Util;
import ca.stellardrift.permissionsex.rank.RankLadder;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public abstract class AbstractDataStore<T extends AbstractDataStore<T, C>, C>
implements DataStore {
    private final DataStoreContext context;
    private final ProtoDataStore<C> properties;
    private boolean firstRun;
    protected final CacheListenerHolder<Map.Entry<String, String>, ImmutableSubjectData> listeners = new CacheListenerHolder();
    protected final CacheListenerHolder<String, RankLadder> rankLadderListeners = new CacheListenerHolder();
    protected final CacheListenerHolder<Boolean, ContextInheritance> contextInheritanceListeners = new CacheListenerHolder();

    protected AbstractDataStore(DataStoreContext context, ProtoDataStore<C> props) {
        this.context = context;
        this.properties = props;
    }

    @Override
    public String name() {
        return this.properties.identifier();
    }

    @Override
    public boolean firstRun() {
        return this.firstRun;
    }

    protected void markFirstRun() {
        this.firstRun = true;
    }

    protected final PermissionsEngine engine() {
        return this.context.engine();
    }

    protected final DataStoreContext context() {
        return this.context;
    }

    protected C config() {
        return this.properties.config();
    }

    protected abstract void load() throws PermissionsLoadingException;

    @Override
    public final CompletableFuture<ImmutableSubjectData> getData(String type, String identifier, @Nullable Consumer<ImmutableSubjectData> listener) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(identifier, "identifier");
        CompletableFuture<ImmutableSubjectData> ret = this.getDataInternal(type, identifier);
        ret.thenRun(() -> {
            if (listener != null) {
                this.listeners.addListener(UnmodifiableCollections.immutableMapEntry(type, identifier), listener);
            }
        });
        return ret;
    }

    @Override
    public final CompletableFuture<ImmutableSubjectData> setData(String type, String identifier, @Nullable ImmutableSubjectData data) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(identifier, "identifier");
        Map.Entry<String, String> lookupKey = UnmodifiableCollections.immutableMapEntry(type, identifier);
        return this.setDataInternal(type, identifier, data).thenApply(newData -> {
            if (newData != null) {
                this.listeners.call(lookupKey, (ImmutableSubjectData)newData);
            }
            return newData;
        });
    }

    protected <V> CompletableFuture<V> runAsync(CheckedSupplier<V, ?> supplier) {
        return Util.asyncFailableFuture(supplier, this.context.asyncExecutor());
    }

    protected CompletableFuture<Void> runAsync(Runnable run) {
        return CompletableFuture.runAsync(run, this.context.asyncExecutor());
    }

    protected final void applyDefaultData() {
        SubjectRef<SubjectType<SubjectType<?>>> defaultSubject = SubjectRef.subject(this.engine().defaults(), this.engine().defaults().type());
        ((CompletableFuture)this.getData(defaultSubject, null).thenApply(data -> data.withSegment(Collections.singleton(new ContextValue("localip", "127.0.0.1")), s -> s.withFallbackPermission(1)))).thenCompose(data -> this.setData(defaultSubject, (ImmutableSubjectData)data));
    }

    protected abstract CompletableFuture<ImmutableSubjectData> getDataInternal(String var1, String var2);

    protected abstract CompletableFuture<ImmutableSubjectData> setDataInternal(String var1, String var2, @Nullable ImmutableSubjectData var3);

    @Override
    public final Stream<Map.Entry<String, ImmutableSubjectData>> getAll(String type) {
        Objects.requireNonNull(type, "type");
        return this.getAllIdentifiers(type).map(id -> UnmodifiableCollections.immutableMapEntry(id, this.getData(type, (String)id, null).join()));
    }

    public final <V> CompletableFuture<V> performBulkOperation(Function<DataStore, V> function) {
        return Util.asyncFailableFuture(() -> this.performBulkOperationSync(function), this.context.asyncExecutor());
    }

    @Override
    public final CompletableFuture<RankLadder> getRankLadder(String ladderName, @Nullable Consumer<RankLadder> listener) {
        Objects.requireNonNull(ladderName, "ladderName");
        CompletableFuture<RankLadder> ladder = this.getRankLadderInternal(ladderName);
        if (listener != null) {
            this.rankLadderListeners.addListener(ladderName.toLowerCase(), listener);
        }
        return ladder;
    }

    @Override
    public final CompletableFuture<RankLadder> setRankLadder(String identifier, @Nullable RankLadder ladder) {
        return this.setRankLadderInternal(identifier, ladder).thenApply(newData -> {
            if (newData != null) {
                this.rankLadderListeners.call(identifier, (RankLadder)newData);
            }
            return newData;
        });
    }

    protected abstract CompletableFuture<RankLadder> getRankLadderInternal(String var1);

    protected abstract CompletableFuture<RankLadder> setRankLadderInternal(String var1, @Nullable RankLadder var2);

    @Override
    public final CompletableFuture<ContextInheritance> getContextInheritance(@Nullable Consumer<ContextInheritance> listener) {
        CompletableFuture<ContextInheritance> inheritance = this.getContextInheritanceInternal();
        if (listener != null) {
            this.contextInheritanceListeners.addListener(true, listener);
        }
        return inheritance;
    }

    @Override
    public final CompletableFuture<ContextInheritance> setContextInheritance(ContextInheritance contextInheritance) {
        return this.setContextInheritanceInternal(contextInheritance).thenApply(newData -> {
            if (newData != null) {
                this.contextInheritanceListeners.call(true, (ContextInheritance)newData);
            }
            return newData;
        });
    }

    protected abstract CompletableFuture<ContextInheritance> getContextInheritanceInternal();

    protected abstract CompletableFuture<ContextInheritance> setContextInheritanceInternal(ContextInheritance var1);

    protected abstract <V> V performBulkOperationSync(Function<DataStore, V> var1) throws Exception;

    @Override
    public CompletableFuture<Void> moveData(String oldType, String oldIdentifier, String newType, String newIdentifier) {
        return ((CompletableFuture)this.isRegistered(oldType, oldIdentifier).thenCombine(this.isRegistered(newType, newIdentifier), (oldRegistered, newRegistered) -> {
            if (oldRegistered.booleanValue() && !newRegistered.booleanValue()) {
                return ((CompletableFuture)((CompletableFuture)this.getData(oldType, oldIdentifier, null).thenCompose(oldData -> this.setData(newType, newIdentifier, (ImmutableSubjectData)oldData))).thenCompose(newData -> this.setData(oldType, oldIdentifier, null))).thenApply(inp -> null);
            }
            return Util.failedFuture(new PermissionsException(Messages.DATASTORE_MOVE_ERROR.tr(new Object[0])));
        })).thenCompose(future -> future);
    }

    public static abstract class Factory<T extends AbstractDataStore<T, C>, C>
    implements DataStoreFactory<C> {
        private final String name;
        private final Class<C> configType;
        private final BiFunction<DataStoreContext, ProtoDataStore<C>, T> newInstanceSupplier;
        private final Component friendlyName;

        protected Factory(String name, Class<C> clazz, BiFunction<DataStoreContext, ProtoDataStore<C>, T> newInstanceSupplier) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(clazz, "clazz");
            this.name = name;
            this.friendlyName = Component.text(name);
            this.configType = clazz;
            this.newInstanceSupplier = newInstanceSupplier;
        }

        @Override
        public Component friendlyName() {
            return this.friendlyName;
        }

        @Override
        public final String name() {
            return this.name;
        }

        @Override
        public final ProtoDataStore<C> create(String identifier, ConfigurationNode config) throws PermissionsLoadingException {
            try {
                C dataStoreConfig = config.get(this.configType);
                return ProtoDataStore.of(identifier, dataStoreConfig, this);
            }
            catch (SerializationException e) {
                throw new PermissionsLoadingException(Messages.DATASTORE_ERROR_DESERIALIZE.tr(identifier), (Throwable)e);
            }
        }

        @Override
        public DataStore defrost(DataStoreContext context, ProtoDataStore<C> properties) throws PermissionsLoadingException {
            Objects.requireNonNull(context, "context");
            AbstractDataStore store = (AbstractDataStore)this.newInstanceSupplier.apply(context, properties);
            store.load();
            return store;
        }

        @Override
        public void serialize(ConfigurationNode node, ProtoDataStore<C> protoStore) throws SerializationException {
            node.set(protoStore.config());
        }
    }
}

