/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.backend.file;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.exception.PermissionsLoadingException;
import ca.stellardrift.permissionsex.ext.configurate.ConfigurationNode;
import ca.stellardrift.permissionsex.ext.configurate.serialize.SerializationException;
import ca.stellardrift.permissionsex.ext.pcollections.PMap;
import ca.stellardrift.permissionsex.ext.pcollections.PSet;
import ca.stellardrift.permissionsex.impl.backend.file.Messages;
import ca.stellardrift.permissionsex.impl.backend.memory.MemorySubjectData;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import java.util.HashMap;
import java.util.Map;

public final class FileSubjectData
extends MemorySubjectData {
    static final String KEY_CONTEXTS = "contexts";

    static FileSubjectData fromNode(ConfigurationNode node) throws SerializationException, PermissionsLoadingException {
        PMap<PSet<ContextValue<?>>, MemorySubjectData.MemorySegment> map = PCollections.map();
        if (node.isList()) {
            for (ConfigurationNode configurationNode : node.childrenList()) {
                if (!configurationNode.isMap()) {
                    throw new PermissionsLoadingException(Messages.FILE_LOAD_CONTEXT.tr(new Object[0]));
                }
                PSet<ContextValue<?>> contexts = FileSubjectData.contextsFrom(configurationNode);
                MemorySubjectData.MemorySegment value = (MemorySubjectData.MemorySegment)MAPPER.load(configurationNode);
                map = map.plus(contexts, value);
            }
        }
        return new FileSubjectData(map);
    }

    FileSubjectData() {
    }

    FileSubjectData(PMap<PSet<ContextValue<?>>, MemorySubjectData.MemorySegment> contexts) {
        super(contexts);
    }

    @Override
    protected MemorySubjectData newData(PMap<PSet<ContextValue<?>>, MemorySubjectData.MemorySegment> contexts) {
        return new FileSubjectData(contexts);
    }

    private static PSet<ContextValue<?>> contextsFrom(ConfigurationNode node) {
        PSet<ContextValue<Object>> contexts = PCollections.set();
        ConfigurationNode contextsNode = node.node(KEY_CONTEXTS);
        if (contextsNode.isMap()) {
            contexts = contextsNode.childrenMap().entrySet().stream().map(ent -> new ContextValue(ent.getKey().toString(), ((ConfigurationNode)ent.getValue()).getString())).collect(PCollections.toPSet());
        }
        return contexts;
    }

    void serialize(ConfigurationNode node) throws SerializationException {
        if (!node.isList()) {
            node.raw(null);
        }
        HashMap existingSections = new HashMap();
        for (ConfigurationNode configurationNode : node.childrenList()) {
            existingSections.put(FileSubjectData.contextsFrom(configurationNode), configurationNode);
        }
        for (Map.Entry entry : this.segments.entrySet()) {
            ConfigurationNode contextSection = (ConfigurationNode)existingSections.remove(entry.getKey());
            if (contextSection == null) {
                contextSection = node.appendListNode();
                ConfigurationNode contextsNode = contextSection.node(KEY_CONTEXTS);
                for (ContextValue context : (PSet)entry.getKey()) {
                    contextsNode.node(context.key()).set(context.rawValue());
                }
            }
            MAPPER.save((MemorySubjectData.MemorySegment)entry.getValue(), contextSection);
        }
        for (ConfigurationNode configurationNode : existingSections.values()) {
            configurationNode.raw(null);
        }
    }

    @Override
    public String toString() {
        return "FileSubjectData{segments=" + this.segments + '}';
    }
}

