/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.backend.file;

import ca.stellardrift.permissionsex.ext.configurate.ConfigurationNode;
import ca.stellardrift.permissionsex.ext.configurate.NodePath;
import ca.stellardrift.permissionsex.ext.configurate.ScopedConfigurationNode;
import ca.stellardrift.permissionsex.ext.configurate.transformation.ConfigurationTransformation;
import ca.stellardrift.permissionsex.ext.configurate.transformation.TransformAction;
import ca.stellardrift.permissionsex.ext.configurate.util.UnmodifiableCollections;
import ca.stellardrift.permissionsex.impl.backend.file.Messages;
import ca.stellardrift.permissionsex.legacy.LegacyConversions;
import ca.stellardrift.permissionsex.logging.FormattedLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SchemaMigrations {
    public static final int LATEST_VERSION = 4;
    private static final TransformAction MOVE_PREFIX_SUFFIX_ACTION = (nodePath, configurationNode) -> {
        ConfigurationNode defaultNode;
        ConfigurationNode suffixNode;
        ConfigurationNode prefixNode = configurationNode.node("prefix");
        if (!prefixNode.virtual()) {
            configurationNode.node("options", "prefix").from(prefixNode);
            prefixNode.set(null);
        }
        if (!(suffixNode = configurationNode.node("suffix")).virtual()) {
            configurationNode.node("options", "suffix").from(suffixNode);
            suffixNode.raw(null);
        }
        if (!(defaultNode = configurationNode.node("default")).virtual()) {
            configurationNode.node("options", "default").from(defaultNode);
            defaultNode.raw(null);
        }
        return null;
    };

    private SchemaMigrations() {
    }

    private static ConfigurationTransformation.Builder tBuilder() {
        return ConfigurationTransformation.builder();
    }

    static <N extends ScopedConfigurationNode<N>> ConfigurationTransformation versionedMigration(FormattedLogger logger) {
        return ConfigurationTransformation.versionedBuilder().versionKey("schema-version").addVersion(4, SchemaMigrations.threeToFour()).addVersion(3, SchemaMigrations.twoTo3()).addVersion(2, SchemaMigrations.oneTo2(logger)).addVersion(1, SchemaMigrations.initialTo1()).build();
    }

    static ConfigurationTransformation threeToFour() {
        return ConfigurationTransformation.chain(SchemaMigrations.tBuilder().addAction(NodePath.path("worlds", ConfigurationTransformation.WILDCARD_OBJECT, "inheritance"), (inputPath, valueAtPath) -> {
            List<String> items = valueAtPath.getList(String.class);
            valueAtPath.raw(null);
            items.stream().map(input -> "world:" + input).forEach(longer -> valueAtPath.appendListNode().raw(longer));
            return new Object[]{"context-inheritance", "world:" + inputPath.get(1)};
        }).build(), SchemaMigrations.tBuilder().addAction(NodePath.path("worlds"), (inputPath, valueAtPath) -> {
            valueAtPath.raw(null);
            return null;
        }).build());
    }

    static ConfigurationTransformation twoTo3() {
        HashMap convertedRanks = new HashMap();
        return ConfigurationTransformation.chain(SchemaMigrations.tBuilder().addAction(NodePath.path(ConfigurationTransformation.WILDCARD_OBJECT), (nodePath, configurationNode) -> {
            if (configurationNode.isMap()) {
                String lastPath = nodePath.get(0).toString();
                if (lastPath.endsWith("s")) {
                    lastPath = lastPath.substring(0, lastPath.length() - 1);
                }
                return new Object[]{"subjects", lastPath};
            }
            return null;
        }).build(), SchemaMigrations.tBuilder().addAction(NodePath.path("subjects", "group", ConfigurationTransformation.WILDCARD_OBJECT), (nodePath, configurationNode) -> {
            for (ConfigurationNode configurationNode2 : configurationNode.childrenList()) {
                if (!configurationNode2.node("contexts").virtual() && !configurationNode2.node("contexts").childrenMap().isEmpty()) continue;
                ConfigurationNode optionsNode = configurationNode2.node("options");
                if (optionsNode.virtual()) {
                    return null;
                }
                ConfigurationNode rank = optionsNode.node("rank");
                if (rank.virtual()) continue;
                String rankLadder = optionsNode.node("rank-ladder").getString("default");
                List tempVals = convertedRanks.computeIfAbsent(rankLadder.toLowerCase(), k -> new ArrayList());
                tempVals.add(UnmodifiableCollections.immutableMapEntry(configurationNode.key().toString(), rank.getInt()));
                rank.raw(null);
                optionsNode.node("rank-ladder").raw(null);
                if (!optionsNode.childrenMap().isEmpty()) continue;
                optionsNode.raw(null);
            }
            return null;
        }).build(), SchemaMigrations.tBuilder().addAction(NodePath.path(), (nodePath, configurationNode) -> {
            for (Map.Entry ent : convertedRanks.entrySet()) {
                ((List)ent.getValue()).sort((a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue()));
                ConfigurationNode ladderNode = configurationNode.node("rank-ladders", ent.getKey());
                for (Map.Entry grp : (List)ent.getValue()) {
                    ladderNode.appendListNode().set("group:" + (String)grp.getKey());
                }
            }
            return null;
        }).build());
    }

    static ConfigurationTransformation oneTo2(FormattedLogger logger) {
        return ConfigurationTransformation.chain(SchemaMigrations.tBuilder().addAction(NodePath.path(ConfigurationTransformation.WILDCARD_OBJECT, ConfigurationTransformation.WILDCARD_OBJECT), (nodePath, configurationNode) -> {
            ConfigurationNode src = configurationNode.copy();
            configurationNode.appendListNode().from(src);
            return null;
        }).build(), SchemaMigrations.tBuilder().addAction(NodePath.path(ConfigurationTransformation.WILDCARD_OBJECT, ConfigurationTransformation.WILDCARD_OBJECT, 0, "worlds"), (nodePath, configurationNode) -> {
            ConfigurationNode entityNode = configurationNode.parent().parent();
            for (Map.Entry<Object, ? extends ConfigurationNode> ent : configurationNode.childrenMap().entrySet()) {
                entityNode.appendListNode().from(ent.getValue()).node("contexts", "world").set(ent.getKey());
            }
            configurationNode.raw(null);
            return null;
        }).build(), SchemaMigrations.tBuilder().addAction(NodePath.path(ConfigurationTransformation.WILDCARD_OBJECT, ConfigurationTransformation.WILDCARD_OBJECT, ConfigurationTransformation.WILDCARD_OBJECT, "permissions"), (nodePath, configurationNode) -> {
            List<String> existing = configurationNode.getList(String.class, Collections.emptyList());
            if (!existing.isEmpty()) {
                configurationNode.raw(Collections.emptyMap());
            }
            for (String permission : existing) {
                int value;
                int n = value = permission.startsWith("-") ? -1 : 1;
                if (value < 0) {
                    permission = permission.substring(1);
                }
                if (permission.equals("*")) {
                    configurationNode.parent().node("permissions-default").set(value);
                    continue;
                }
                if ((permission = LegacyConversions.convertLegacyPermission(permission)).contains("*")) {
                    logger.warn(Messages.FILE_CONVERSION_ILLEGAL_CHAR.tr(configurationNode.path()));
                }
                configurationNode.node(permission).raw(value);
            }
            if (configurationNode.empty()) {
                configurationNode.raw(null);
            }
            return null;
        }).addAction(NodePath.path("users", ConfigurationTransformation.WILDCARD_OBJECT, ConfigurationTransformation.WILDCARD_OBJECT, "group"), (nodePath, configurationNode) -> {
            Object[] retPath = nodePath.array();
            retPath[retPath.length - 1] = "parents";
            for (ConfigurationNode configurationNode2 : configurationNode.childrenList()) {
                configurationNode2.set("group:" + configurationNode2.getString());
            }
            return retPath;
        }).addAction(NodePath.path("groups", ConfigurationTransformation.WILDCARD_OBJECT, ConfigurationTransformation.WILDCARD_OBJECT, "inheritance"), (nodePath, configurationNode) -> {
            Object[] retPath = nodePath.array();
            retPath[retPath.length - 1] = "parents";
            for (ConfigurationNode configurationNode2 : configurationNode.childrenList()) {
                configurationNode2.set("group:" + configurationNode2.getString());
            }
            return retPath;
        }).addAction(NodePath.path("groups", ConfigurationTransformation.WILDCARD_OBJECT, ConfigurationTransformation.WILDCARD_OBJECT), (inputPath, valueAtPath) -> {
            ConfigurationNode defaultNode = valueAtPath.node("options", "default");
            if (!defaultNode.virtual()) {
                if (defaultNode.getBoolean()) {
                    ConfigurationNode addToNode = null;
                    ConfigurationNode defaultsParent = valueAtPath.parent().parent().parent().node("fallbacks", "user");
                    Object contexts = valueAtPath.node("contexts").raw();
                    for (ConfigurationNode configurationNode : defaultsParent.childrenList()) {
                        if (!Objects.equals(configurationNode.node("contexts").raw(), contexts)) continue;
                        addToNode = configurationNode;
                        break;
                    }
                    if (addToNode == null) {
                        addToNode = defaultsParent.appendListNode();
                        addToNode.node("contexts").set(valueAtPath.node("contexts"));
                    }
                    addToNode.node("parents").appendListNode().set("group:" + valueAtPath.parent().key());
                }
                defaultNode.raw(null);
                ConfigurationNode optionsNode = valueAtPath.node("options");
                if (optionsNode.childrenMap().isEmpty()) {
                    optionsNode.raw(null);
                }
            }
            return null;
        }).build());
    }

    static ConfigurationTransformation initialTo1() {
        return ConfigurationTransformation.builder().addAction(NodePath.path(ConfigurationTransformation.WILDCARD_OBJECT, ConfigurationTransformation.WILDCARD_OBJECT), MOVE_PREFIX_SUFFIX_ACTION).addAction(NodePath.path(ConfigurationTransformation.WILDCARD_OBJECT, ConfigurationTransformation.WILDCARD_OBJECT, "worlds", ConfigurationTransformation.WILDCARD_OBJECT), MOVE_PREFIX_SUFFIX_ACTION).build();
    }
}

