/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.backend.memory;

import ca.stellardrift.permissionsex.context.ContextInheritance;
import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.ext.configurate.objectmapping.ConfigSerializable;
import ca.stellardrift.permissionsex.ext.configurate.objectmapping.meta.Setting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ConfigSerializable
public class MemoryContextInheritance
implements ContextInheritance {
    @Setting(value="context-inheritance")
    private Map<String, List<String>> contextInheritance = new HashMap<String, List<String>>();

    protected MemoryContextInheritance() {
    }

    protected MemoryContextInheritance(Map<String, List<String>> data) {
        this.contextInheritance = data;
    }

    @Override
    public List<ContextValue<?>> parents(ContextValue<?> context) {
        List<String> inheritance = this.contextInheritance.get(MemoryContextInheritance.ctxToString(context));
        if (inheritance == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Lists.transform(inheritance, MemoryContextInheritance::ctxFromString));
    }

    @Override
    public ContextInheritance parents(ContextValue<?> context, List<ContextValue<?>> parents) {
        HashMap<String, List<String>> newData = new HashMap<String, List<String>>(this.contextInheritance);
        newData.put(MemoryContextInheritance.ctxToString(context), (List<String>)ImmutableList.copyOf((Collection)Lists.transform((List)ImmutableList.copyOf(parents), MemoryContextInheritance::ctxToString)));
        return this.newCopy(newData);
    }

    @Override
    public Map<ContextValue<?>, List<ContextValue<?>>> allParents() {
        ImmutableMap.Builder ret = ImmutableMap.builder();
        for (Map.Entry<String, List<String>> entry : this.contextInheritance.entrySet()) {
            ret.put(MemoryContextInheritance.ctxFromString(entry.getKey()), (Object)Lists.transform(entry.getValue(), MemoryContextInheritance::ctxFromString));
        }
        return ret.build();
    }

    protected MemoryContextInheritance newCopy(Map<String, List<String>> raw) {
        return new MemoryContextInheritance(raw);
    }

    public static MemoryContextInheritance fromExistingContextInheritance(ContextInheritance inheritance) {
        if (inheritance instanceof MemoryContextInheritance) {
            return (MemoryContextInheritance)inheritance;
        }
        HashMap<String, List<String>> data = new HashMap<String, List<String>>();
        for (Map.Entry<ContextValue<?>, List<ContextValue<?>>> ent : inheritance.allParents().entrySet()) {
            data.put(MemoryContextInheritance.ctxToString(ent.getKey()), Lists.transform(ent.getValue(), MemoryContextInheritance::ctxToString));
        }
        return new MemoryContextInheritance(data);
    }

    public static ContextValue<?> ctxFromString(String input) {
        String[] values = input.split(":", 2);
        if (values.length != 2) {
            throw new IllegalArgumentException("Invalid format for context!");
        }
        return new ContextValue(values[0], values[1]);
    }

    public static String ctxToString(ContextValue<?> input) {
        return input.key() + ":" + input.rawValue();
    }
}

