/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.config;

import ca.stellardrift.permissionsex.datastore.ProtoDataStore;
import ca.stellardrift.permissionsex.exception.PEBKACException;
import ca.stellardrift.permissionsex.exception.PermissionsException;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.MonotonicNonNull;
import ca.stellardrift.permissionsex.ext.configurate.ConfigurateException;
import ca.stellardrift.permissionsex.ext.configurate.ConfigurationNode;
import ca.stellardrift.permissionsex.ext.configurate.ConfigurationOptions;
import ca.stellardrift.permissionsex.ext.configurate.hocon.HoconConfigurationLoader;
import ca.stellardrift.permissionsex.ext.configurate.loader.ConfigurationLoader;
import ca.stellardrift.permissionsex.ext.configurate.objectmapping.ConfigSerializable;
import ca.stellardrift.permissionsex.ext.configurate.objectmapping.ObjectMapper;
import ca.stellardrift.permissionsex.ext.configurate.objectmapping.meta.NodeResolver;
import ca.stellardrift.permissionsex.ext.configurate.objectmapping.meta.Setting;
import ca.stellardrift.permissionsex.ext.configurate.serialize.SerializationException;
import ca.stellardrift.permissionsex.ext.configurate.serialize.TypeSerializerCollection;
import ca.stellardrift.permissionsex.ext.configurate.util.CheckedSupplier;
import ca.stellardrift.permissionsex.ext.geantyref.TypeFactory;
import ca.stellardrift.permissionsex.ext.geantyref.TypeToken;
import ca.stellardrift.permissionsex.ext.pcollections.PSet;
import ca.stellardrift.permissionsex.ext.pcollections.PStack;
import ca.stellardrift.permissionsex.ext.pcollections.PVector;
import ca.stellardrift.permissionsex.impl.config.ConfigTransformations;
import ca.stellardrift.permissionsex.impl.config.Messages;
import ca.stellardrift.permissionsex.impl.config.PCollectionSerializer;
import ca.stellardrift.permissionsex.impl.config.PMapSerializer;
import ca.stellardrift.permissionsex.impl.config.PermissionsExConfiguration;
import ca.stellardrift.permissionsex.impl.config.ProtoDataStoreSerializer;
import ca.stellardrift.permissionsex.impl.config.SupplierSerializer;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@ConfigSerializable
public final class FilePermissionsExConfiguration<T>
implements PermissionsExConfiguration<T> {
    private static final TypeSerializerCollection PEX_SERIALIZERS = FilePermissionsExConfiguration.populateSerializers(TypeSerializerCollection.defaults().childBuilder()).build();
    public static final ConfigurationOptions PEX_OPTIONS = ConfigurationOptions.defaults().implicitInitialization(true).shouldCopyDefaults(true).serializers(PEX_SERIALIZERS);
    private final ConfigurationLoader<?> loader;
    private final ConfigurationNode node;
    private final Class<T> platformConfigClass;
    private @MonotonicNonNull Instance<T> instance;

    public static ConfigurationOptions decorateOptions(ConfigurationOptions input) {
        return input.implicitInitialization(true).shouldCopyDefaults(true).serializers(PEX_SERIALIZERS);
    }

    FilePermissionsExConfiguration(ConfigurationLoader<?> loader, ConfigurationNode node, Class<T> platformConfigClass) {
        this.loader = loader;
        this.node = node;
        this.platformConfigClass = platformConfigClass;
    }

    public static FilePermissionsExConfiguration<?> fromLoader(ConfigurationLoader<?> loader) throws ConfigurateException {
        return FilePermissionsExConfiguration.fromLoader(loader, Void.class);
    }

    public static TypeSerializerCollection.Builder populateSerializers(TypeSerializerCollection.Builder coll) {
        return coll.register(new TypeToken<PVector<?>>(){}, new PCollectionSerializer<PVector>(PCollections::vector)).register(new TypeToken<PSet<?>>(){}, new PCollectionSerializer<PSet>(PCollections::set)).register(new TypeToken<PStack<?>>(){}, new PCollectionSerializer<PStack>(PCollections::stack)).register(PMapSerializer.TYPE, PMapSerializer.INSTANCE).register(new TypeToken<ProtoDataStore<?>>(){}, new ProtoDataStoreSerializer()).register(new TypeToken<CheckedSupplier<?, SerializationException>>(){}, SupplierSerializer.INSTANCE).registerAnnotatedObjects(ObjectMapper.factoryBuilder().addNodeResolver(NodeResolver.onlyWithSetting()).build());
    }

    public static <T> FilePermissionsExConfiguration<T> fromLoader(ConfigurationLoader<?> loader, Class<T> platformConfigClass) throws ConfigurateException {
        ConfigurationNode fallbackConfig;
        Object node = loader.load(loader.defaultOptions().serializers(PEX_SERIALIZERS).implicitInitialization(true).shouldCopyDefaults(true));
        try {
            fallbackConfig = FilePermissionsExConfiguration.loadDefaultConfiguration();
        }
        catch (ConfigurateException e) {
            throw new Error("PEX's default configuration could not be loaded!", e);
        }
        ConfigTransformations.versions().apply((ConfigurationNode)node);
        node.mergeFrom(fallbackConfig);
        ConfigurationNode defBackendNode = node.node("default-backend");
        if (defBackendNode.empty()) {
            defBackendNode.set("default-file");
        }
        FilePermissionsExConfiguration<T> config = new FilePermissionsExConfiguration<T>(loader, (ConfigurationNode)node, platformConfigClass);
        super.load();
        return config;
    }

    private void load() throws ConfigurateException {
        this.instance = (Instance)this.node.get(TypeFactory.parameterizedClass(Instance.class, this.platformConfigClass));
        this.instance.platform = this.platformConfigClass == Void.class ? null : this.platformConfigNode().get(this.platformConfigClass);
        this.loader.save(this.node);
    }

    @Override
    public void save() throws IOException {
        this.node.set(TypeFactory.parameterizedClass(Instance.class, this.platformConfigClass), this.instance);
        if (this.platformConfigClass != Void.class) {
            this.platformConfigNode().set(this.platformConfigClass, this.instance.platform);
        }
        this.loader.save(this.node);
    }

    private ConfigurationNode platformConfigNode() {
        return this.node.node("platform");
    }

    @Override
    public ProtoDataStore<?> getDataStore(String name) {
        return (ProtoDataStore)((Instance)this.instance).backends.get(name);
    }

    @Override
    public ProtoDataStore<?> getDefaultDataStore() {
        return (ProtoDataStore)((Instance)this.instance).backends.get(((Instance)this.instance).defaultBackend);
    }

    @Override
    public boolean isDebugEnabled() {
        return ((Instance)this.instance).debug;
    }

    @Override
    public List<String> getServerTags() {
        return Collections.unmodifiableList(((Instance)this.instance).serverTags);
    }

    @Override
    public void validate() throws PEBKACException {
        this.instance.validate();
    }

    @Override
    public T getPlatformConfig() {
        return this.instance.platform;
    }

    @Override
    public FilePermissionsExConfiguration<T> reload() throws IOException {
        try {
            Object node = this.loader.load();
            FilePermissionsExConfiguration<T> ret = new FilePermissionsExConfiguration<T>(this.loader, (ConfigurationNode)node, this.platformConfigClass);
            super.load();
            return ret;
        }
        catch (ConfigurateException ex) {
            throw new IOException(ex);
        }
    }

    public static ConfigurationNode loadDefaultConfiguration() throws ConfigurateException {
        URL defaultConfig = FilePermissionsExConfiguration.class.getResource("default.conf");
        if (defaultConfig == null) {
            throw new Error(new PermissionsException(Messages.CONFIG_ERROR_DEFAULT_CONFIG.tr(new Object[0])));
        }
        HoconConfigurationLoader fallbackLoader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().defaultOptions(FilePermissionsExConfiguration::decorateOptions)).url(defaultConfig)).build();
        return fallbackLoader.load();
    }

    @ConfigSerializable
    static class Instance<T> {
        @Setting
        private Map<String, ProtoDataStore<?>> backends;
        @Setting
        private String defaultBackend;
        @Setting
        private boolean debug;
        @Setting
        private List<String> serverTags;
        T platform;

        Instance() {
        }

        void validate() throws PEBKACException {
            if (this.backends.isEmpty()) {
                throw new PEBKACException(Messages.CONFIG_ERROR_NO_BACKENDS.tr(new Object[0]));
            }
            if (this.defaultBackend == null) {
                throw new PEBKACException(Messages.CONFIG_ERROR_NO_DEFAULT.tr(new Object[0]));
            }
            if (!this.backends.containsKey(this.defaultBackend)) {
                throw new PEBKACException(Messages.CONFIG_ERROR_INVALID_DEFAULT.tr(this.defaultBackend, this.backends.keySet()));
            }
        }
    }
}

