/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.config;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.configurate.ConfigurationNode;
import ca.stellardrift.permissionsex.ext.configurate.ConfigurationOptions;
import ca.stellardrift.permissionsex.ext.configurate.serialize.SerializationException;
import ca.stellardrift.permissionsex.ext.configurate.serialize.TypeSerializer;
import ca.stellardrift.permissionsex.ext.configurate.util.Types;
import ca.stellardrift.permissionsex.ext.pcollections.PCollection;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

final class PCollectionSerializer<T extends PCollection<?>>
implements TypeSerializer<T> {
    private final Supplier<T> emptySupplier;

    PCollectionSerializer(Supplier<T> emptySupplier) {
        this.emptySupplier = emptySupplier;
    }

    @Override
    public final T deserialize(Type type, ConfigurationNode node) throws SerializationException {
        Type entryType = this.elementType(type);
        @Nullable TypeSerializer<?> entrySerial = node.options().serializers().get(entryType);
        if (entrySerial == null) {
            throw new SerializationException(node, entryType, "No applicable type serializer for type");
        }
        if (node.isList()) {
            List<? extends ConfigurationNode> values = node.childrenList();
            PCollection<?> ret = (PCollection<?>)this.emptySupplier.get();
            for (ConfigurationNode configurationNode : values) {
                try {
                    ret = ret.plus(entrySerial.deserialize(entryType, configurationNode));
                }
                catch (SerializationException ex) {
                    ex.initPath(configurationNode::path);
                    throw ex;
                }
            }
            return (T)ret;
        }
        @Nullable Object unwrappedVal = node.raw();
        if (unwrappedVal != null) {
            return (T)((PCollection)this.emptySupplier.get()).plus(entrySerial.deserialize(entryType, node));
        }
        return (T)((PCollection)this.emptySupplier.get());
    }

    @Override
    public final void serialize(Type type, @Nullable T obj, ConfigurationNode node) throws SerializationException {
        Type entryType = this.elementType(type);
        @Nullable TypeSerializer<?> entrySerial = node.options().serializers().get(entryType);
        if (entrySerial == null) {
            throw new SerializationException(node, entryType, "No applicable type serializer for type");
        }
        node.raw(Collections.emptyList());
        if (obj != null) {
            for (Object el : obj) {
                ConfigurationNode child = node.appendListNode();
                try {
                    entrySerial.serialize(entryType, el, child);
                }
                catch (SerializationException ex) {
                    ex.initPath(child::path);
                    throw ex;
                }
            }
        }
    }

    @Override
    public T emptyValue(Type specificType, ConfigurationOptions options) {
        return (T)((PCollection)this.emptySupplier.get());
    }

    private Type elementType(Type containerType) {
        Types.requireCompleteParameters(containerType);
        return ((ParameterizedType)containerType).getActualTypeArguments()[0];
    }
}

