/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.config;

import ca.stellardrift.permissionsex.datastore.DataStoreFactory;
import ca.stellardrift.permissionsex.datastore.ProtoDataStore;
import ca.stellardrift.permissionsex.exception.PermissionsLoadingException;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.configurate.ConfigurationNode;
import ca.stellardrift.permissionsex.ext.configurate.serialize.SerializationException;
import ca.stellardrift.permissionsex.ext.configurate.serialize.TypeSerializer;
import java.lang.reflect.Type;

public class ProtoDataStoreSerializer
implements TypeSerializer<ProtoDataStore<?>> {
    @Override
    public ProtoDataStore<?> deserialize(Type type, ConfigurationNode value) throws SerializationException {
        String dataStoreType = value.node("type").getString(value.key().toString());
        @Nullable DataStoreFactory<?> factory = DataStoreFactory.forType(dataStoreType);
        if (factory == null) {
            throw new SerializationException("Unknown DataStore type " + dataStoreType);
        }
        try {
            return factory.create(value.key().toString(), value);
        }
        catch (PermissionsLoadingException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public void serialize(Type type, @Nullable ProtoDataStore<?> store, ConfigurationNode value) throws SerializationException {
        if (store == null) {
            value.set(null);
            return;
        }
        store.serialize(value);
        value.node("type").set(store.factory().name());
    }
}

