/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.config;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.configurate.ConfigurationNode;
import ca.stellardrift.permissionsex.ext.configurate.serialize.SerializationException;
import ca.stellardrift.permissionsex.ext.configurate.serialize.TypeSerializer;
import ca.stellardrift.permissionsex.ext.configurate.util.CheckedSupplier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

class SupplierSerializer
implements TypeSerializer<CheckedSupplier<?, SerializationException>> {
    static final SupplierSerializer INSTANCE = new SupplierSerializer();

    private SupplierSerializer() {
    }

    @Override
    public CheckedSupplier<?, SerializationException> deserialize(Type type, ConfigurationNode value) throws SerializationException {
        if (!(type instanceof ParameterizedType)) {
            throw new SerializationException("Raw types are not supported for a supplier");
        }
        Type wrappedType = ((ParameterizedType)type).getActualTypeArguments()[0];
        @Nullable TypeSerializer<?> wrappedSerializer = value.options().serializers().get(wrappedType);
        if (wrappedSerializer == null) {
            throw new SerializationException("No type serializer available for type $wrappedType");
        }
        return () -> wrappedSerializer.deserialize(wrappedType, value);
    }

    @Override
    public void serialize(Type type, @Nullable CheckedSupplier<?, SerializationException> obj, ConfigurationNode value) throws SerializationException {
        if (!(type instanceof ParameterizedType)) {
            throw new SerializationException("Raw types are not supported for a supplier");
        }
        Type wrappedType = ((ParameterizedType)type).getActualTypeArguments()[0];
        @Nullable TypeSerializer<?> wrappedSerializer = value.options().serializers().get(wrappedType);
        if (wrappedSerializer == null) {
            throw new SerializationException("No type serializer available for wrapped type " + wrappedType);
        }
        wrappedSerializer.serialize(wrappedType, obj == null ? null : (Object)obj.get(), value);
    }
}

