/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.logging;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.impl.logging.Messages;
import ca.stellardrift.permissionsex.logging.FormattedLogger;
import ca.stellardrift.permissionsex.logging.PermissionCheckNotifier;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class DebugPermissionCheckNotifier
implements PermissionCheckNotifier {
    private final FormattedLogger logger;
    private final PermissionCheckNotifier delegate;
    private final Predicate<String> filterPredicate;

    public DebugPermissionCheckNotifier(FormattedLogger logger, PermissionCheckNotifier delegate, @Nullable Predicate<String> filterPredicate) {
        this.logger = logger;
        this.delegate = delegate;
        this.filterPredicate = filterPredicate == null ? x -> true : filterPredicate;
    }

    private <I> String stringIdentifier(SubjectRef<I> identifier) {
        return identifier.type().name() + " " + identifier.type().serializeIdentifier(identifier.identifier());
    }

    public PermissionCheckNotifier getDelegate() {
        return this.delegate;
    }

    @Override
    public void onPermissionCheck(SubjectRef<?> subject, Set<ContextValue<?>> contexts, String permission, int value) {
        if (this.filterPredicate.test(permission)) {
            this.logger.info(Messages.CHECK_PERMISSION.tr(permission, contexts, this.stringIdentifier(subject), value));
        }
        this.delegate.onPermissionCheck(subject, contexts, permission, value);
    }

    @Override
    public void onOptionCheck(SubjectRef<?> subject, Set<ContextValue<?>> contexts, String option, String value) {
        if (this.filterPredicate.test(option)) {
            this.logger.info(Messages.CHECK_OPTION.tr(option, contexts, this.stringIdentifier(subject), value));
        }
        this.delegate.onOptionCheck(subject, contexts, option, value);
    }

    @Override
    public void onParentCheck(SubjectRef<?> subject, Set<ContextValue<?>> contexts, List<SubjectRef<?>> parents) {
        this.logger.info(Messages.CHECK_PARENT.tr(contexts, this.stringIdentifier(subject), parents));
        this.delegate.onParentCheck(subject, contexts, parents);
    }
}

