/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.logging;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.serializer.ComponentSerializer;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import ca.stellardrift.permissionsex.ext.kyori.adventure.translation.GlobalTranslator;
import ca.stellardrift.permissionsex.ext.slf4j.Logger;
import ca.stellardrift.permissionsex.ext.slf4j.Marker;
import ca.stellardrift.permissionsex.logging.FormattedLogger;
import java.util.Locale;

public class WrappingFormattedLogger
implements FormattedLogger {
    private final Logger wrapping;
    private @Nullable String prefix;
    private final boolean supportsFormatting;

    public static FormattedLogger of(Logger logger, boolean supportsFormatting) {
        return logger instanceof FormattedLogger ? (FormattedLogger)logger : new WrappingFormattedLogger(logger, supportsFormatting);
    }

    public WrappingFormattedLogger(Logger wrapping, boolean supportsFormatting) {
        this.wrapping = wrapping;
        this.supportsFormatting = supportsFormatting;
    }

    @Override
    public Locale logLocale() {
        return Locale.getDefault();
    }

    @Override
    public Locale logLocale(@Nullable Marker marker) {
        return this.logLocale();
    }

    @Override
    public @Nullable String prefix() {
        return this.prefix;
    }

    @Override
    public void prefix(@Nullable String prefix) {
        this.prefix = prefix;
    }

    @Override
    public ComponentSerializer<Component, ?, String> serializer() {
        if (this.supportsFormatting) {
            return LegacyComponentSerializer.legacySection();
        }
        return PlainComponentSerializer.plain();
    }

    @Override
    public String formatText(Component component, @Nullable Marker marker) {
        return this.serializer().serialize(GlobalTranslator.render(component, this.logLocale(marker)));
    }

    private String applyPrefix(String input) {
        @Nullable String prefix = this.prefix;
        return prefix == null ? input : prefix + input;
    }

    @Override
    public String getName() {
        return this.wrapping.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.wrapping.isTraceEnabled();
    }

    @Override
    public void trace(String msg) {
        this.wrapping.trace(this.applyPrefix(msg));
    }

    @Override
    public void trace(String format, Object arg) {
        this.wrapping.trace(this.applyPrefix(format), arg);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        this.wrapping.trace(this.applyPrefix(format), arg1, arg2);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.wrapping.trace(this.applyPrefix(format), arguments);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.wrapping.trace(this.applyPrefix(msg), t);
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.wrapping.isTraceEnabled(marker);
    }

    @Override
    public void trace(Marker marker, String msg) {
        this.wrapping.trace(marker, this.applyPrefix(msg));
    }

    @Override
    public void trace(Marker marker, String format, Object arg) {
        this.wrapping.trace(marker, this.applyPrefix(format), arg);
    }

    @Override
    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.wrapping.trace(marker, this.applyPrefix(format), arg1, arg2);
    }

    @Override
    public void trace(Marker marker, String format, Object ... argArray) {
        this.wrapping.trace(marker, this.applyPrefix(format), argArray);
    }

    @Override
    public void trace(Marker marker, String msg, Throwable t) {
        this.wrapping.trace(marker, this.applyPrefix(msg), t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.wrapping.isDebugEnabled();
    }

    @Override
    public void debug(String msg) {
        this.wrapping.debug(this.applyPrefix(msg));
    }

    @Override
    public void debug(String format, Object arg) {
        this.wrapping.debug(this.applyPrefix(format), arg);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        this.wrapping.debug(this.applyPrefix(format), arg1, arg2);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.wrapping.debug(this.applyPrefix(format), arguments);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.wrapping.debug(this.applyPrefix(msg), t);
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.wrapping.isDebugEnabled(marker);
    }

    @Override
    public void debug(Marker marker, String msg) {
        this.wrapping.debug(marker, this.applyPrefix(msg));
    }

    @Override
    public void debug(Marker marker, String format, Object arg) {
        this.wrapping.debug(marker, this.applyPrefix(format), arg);
    }

    @Override
    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.wrapping.debug(marker, this.applyPrefix(format), arg1, arg2);
    }

    @Override
    public void debug(Marker marker, String format, Object ... arguments) {
        this.wrapping.debug(marker, this.applyPrefix(format), arguments);
    }

    @Override
    public void debug(Marker marker, String msg, Throwable t) {
        this.wrapping.debug(marker, this.applyPrefix(msg), t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.wrapping.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        this.wrapping.info(this.applyPrefix(msg));
    }

    @Override
    public void info(String format, Object arg) {
        this.wrapping.info(this.applyPrefix(format), arg);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        this.wrapping.info(this.applyPrefix(format), arg1, arg2);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.wrapping.info(this.applyPrefix(format), arguments);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.wrapping.info(this.applyPrefix(msg), t);
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.wrapping.isInfoEnabled(marker);
    }

    @Override
    public void info(Marker marker, String msg) {
        this.wrapping.info(marker, this.applyPrefix(msg));
    }

    @Override
    public void info(Marker marker, String format, Object arg) {
        this.wrapping.info(marker, this.applyPrefix(format), arg);
    }

    @Override
    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.wrapping.info(marker, this.applyPrefix(format), arg1, arg2);
    }

    @Override
    public void info(Marker marker, String format, Object ... arguments) {
        this.wrapping.info(marker, this.applyPrefix(format), arguments);
    }

    @Override
    public void info(Marker marker, String msg, Throwable t) {
        this.wrapping.info(marker, this.applyPrefix(msg), t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.wrapping.isWarnEnabled();
    }

    @Override
    public void warn(String msg) {
        this.wrapping.warn(this.applyPrefix(msg));
    }

    @Override
    public void warn(String format, Object arg) {
        this.wrapping.warn(this.applyPrefix(format), arg);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.wrapping.warn(this.applyPrefix(format), arguments);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        this.wrapping.warn(this.applyPrefix(format), arg1, arg2);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.wrapping.warn(this.applyPrefix(msg), t);
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.wrapping.isWarnEnabled(marker);
    }

    @Override
    public void warn(Marker marker, String msg) {
        this.wrapping.warn(marker, this.applyPrefix(msg));
    }

    @Override
    public void warn(Marker marker, String format, Object arg) {
        this.wrapping.warn(marker, this.applyPrefix(format), arg);
    }

    @Override
    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.wrapping.warn(marker, this.applyPrefix(format), arg1, arg2);
    }

    @Override
    public void warn(Marker marker, String format, Object ... arguments) {
        this.wrapping.warn(marker, this.applyPrefix(format), arguments);
    }

    @Override
    public void warn(Marker marker, String msg, Throwable t) {
        this.wrapping.warn(marker, this.applyPrefix(msg), t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.wrapping.isErrorEnabled();
    }

    @Override
    public void error(String msg) {
        this.wrapping.error(this.applyPrefix(msg));
    }

    @Override
    public void error(String format, Object arg) {
        this.wrapping.error(this.applyPrefix(format), arg);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        this.wrapping.error(this.applyPrefix(format), arg1, arg2);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.wrapping.error(this.applyPrefix(format), arguments);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.wrapping.error(this.applyPrefix(msg), t);
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.wrapping.isErrorEnabled(marker);
    }

    @Override
    public void error(Marker marker, String msg) {
        this.wrapping.error(marker, this.applyPrefix(msg));
    }

    @Override
    public void error(Marker marker, String format, Object arg) {
        this.wrapping.error(marker, this.applyPrefix(format), arg);
    }

    @Override
    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.wrapping.error(marker, this.applyPrefix(format), arg1, arg2);
    }

    @Override
    public void error(Marker marker, String format, Object ... arguments) {
        this.wrapping.error(marker, this.applyPrefix(format), arguments);
    }

    @Override
    public void error(Marker marker, String msg, Throwable t) {
        this.wrapping.error(marker, this.applyPrefix(msg), t);
    }
}

