/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.rank;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.TextComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.event.ClickEvent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.event.HoverEvent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.format.TextDecoration;
import ca.stellardrift.permissionsex.ext.pcollections.PVector;
import ca.stellardrift.permissionsex.impl.rank.Messages;
import ca.stellardrift.permissionsex.rank.RankLadder;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public abstract class AbstractRankLadder
implements RankLadder {
    private final String name;

    protected AbstractRankLadder(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public final ImmutableSubjectData promote(Set<ContextValue<?>> contexts, ImmutableSubjectData input) {
        if (this.ranks().isEmpty()) {
            return input;
        }
        return input.withSegment(contexts, seg -> {
            List<SubjectRef<?>> originalParents = seg.parents();
            if (originalParents.isEmpty()) {
                return seg.plusParent((SubjectRef)this.ranks().get(0));
            }
            ArrayList parents = new ArrayList(originalParents);
            boolean found = false;
            ListIterator<SubjectRef> it = parents.listIterator();
            while (it.hasNext()) {
                SubjectRef parent = (SubjectRef)it.next();
                int index = this.ranks().indexOf(parent);
                if (index <= -1) continue;
                if (index == this.ranks().size() - 1) {
                    return seg;
                }
                it.set((SubjectRef)this.ranks().get(index + 1));
                found = true;
            }
            if (found) {
                return seg.withParents(parents);
            }
            return seg.plusParent((SubjectRef)this.ranks().get(0));
        });
    }

    @Override
    public final ImmutableSubjectData demote(Set<ContextValue<?>> contexts, ImmutableSubjectData input) {
        if (this.ranks().isEmpty()) {
            return input;
        }
        return input.withSegment(contexts, seg -> {
            List<SubjectRef<?>> originalParents = seg.parents();
            if (originalParents.isEmpty()) {
                return seg;
            }
            ArrayList parents = new ArrayList(originalParents);
            boolean found = false;
            ListIterator<SubjectRef> it = parents.listIterator();
            while (it.hasNext()) {
                SubjectRef parent = (SubjectRef)it.next();
                int index = this.ranks().indexOf(parent);
                if (index <= -1) continue;
                if (index == 0) {
                    it.remove();
                } else {
                    it.set((SubjectRef)this.ranks().get(index - 1));
                }
                found = true;
            }
            if (found) {
                return seg.withParents(parents);
            }
            return seg;
        });
    }

    @Override
    public final boolean isOnLadder(Set<ContextValue<?>> contexts, ImmutableSubjectData subject) {
        if (this.ranks().isEmpty()) {
            return false;
        }
        for (SubjectRef<?> par : subject.segment(contexts).parents()) {
            if (!this.ranks().contains(par)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final int indexOf(SubjectRef<?> subject) {
        return this.ranks().indexOf(subject);
    }

    @Override
    public final RankLadder with(SubjectRef<?> subject) {
        int indexOf = this.ranks().indexOf(subject);
        if (indexOf != -1) {
            return this.newWithRanks(this.ranks().minus(indexOf).plus(SubjectRef.mapKeySafe(subject)));
        }
        return this.newWithRanks(this.ranks().plus(SubjectRef.mapKeySafe(subject)));
    }

    @Override
    public final RankLadder with(SubjectRef<?> subject, int index) {
        if (index > this.ranks().size() || index < 0) {
            return this;
        }
        PVector<SubjectRef<?>> entries = this.ranks();
        int indexOf = entries.indexOf(subject);
        entries = entries.plus(index, subject);
        if (indexOf != -1) {
            if (indexOf >= index) {
                ++indexOf;
            }
            entries = entries.minus(indexOf);
        }
        return this.newWithRanks(entries);
    }

    @Override
    public final RankLadder without(SubjectRef<?> subject) {
        PVector<SubjectRef<?>> out = this.ranks().minus(subject);
        return this.ranks() == out ? this : this.newWithRanks(out);
    }

    public abstract PVector<SubjectRef<?>> ranks();

    protected abstract RankLadder newWithRanks(PVector<SubjectRef<?>> var1);

    @Override
    public final Component asComponent() {
        return Component.text(build -> ((TextComponent.Builder)((TextComponent.Builder)build.content(this.name()).decoration(TextDecoration.BOLD, true)).hoverEvent(HoverEvent.showText(Messages.FORMATTER_BUTTON_INFO_PROMPT.tr(new Object[0])))).clickEvent(ClickEvent.runCommand("/pex rank " + this.name())));
    }
}

