/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.rank;

import ca.stellardrift.permissionsex.datastore.DataStore;
import ca.stellardrift.permissionsex.ext.caffeine.cache.AsyncLoadingCache;
import ca.stellardrift.permissionsex.ext.caffeine.cache.Caffeine;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.impl.util.CacheListenerHolder;
import ca.stellardrift.permissionsex.rank.RankLadder;
import ca.stellardrift.permissionsex.rank.RankLadderCollection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public class RankLadderCache
implements RankLadderCollection {
    private final DataStore dataStore;
    private final AsyncLoadingCache<String, RankLadder> cache;
    private final Map<String, Consumer<RankLadder>> cacheHolders = new ConcurrentHashMap<String, Consumer<RankLadder>>();
    private final CacheListenerHolder<String, RankLadder> listeners;

    public RankLadderCache(DataStore dataStore) {
        this(null, dataStore);
    }

    public RankLadderCache(@Nullable RankLadderCache existing, DataStore dataStore) {
        this.dataStore = dataStore;
        this.cache = Caffeine.newBuilder().maximumSize(256L).buildAsync((key, executor) -> dataStore.getRankLadder((String)key, this.clearListener((String)key)));
        if (existing != null) {
            this.listeners = existing.listeners;
            existing.cache.synchronous().asMap().forEach((key, rankLadder) -> this.get((String)key, null).thenAccept(data -> this.listeners.call((String)key, (RankLadder)data)));
        } else {
            this.listeners = new CacheListenerHolder();
        }
    }

    @Override
    public CompletableFuture<RankLadder> get(String identifier, @Nullable Consumer<RankLadder> listener) {
        Objects.requireNonNull(identifier, "identifier");
        CompletableFuture<RankLadder> ret = this.cache.get(identifier);
        ret.thenRun(() -> {
            if (listener != null) {
                this.listeners.addListener(identifier, listener);
            }
        });
        return ret;
    }

    @Override
    public CompletableFuture<RankLadder> update(String identifier, UnaryOperator<RankLadder> updateFunc) {
        return this.cache.get(identifier).thenCompose(oldLadder -> {
            RankLadder newLadder = (RankLadder)updateFunc.apply((RankLadder)oldLadder);
            if (oldLadder == newLadder) {
                return CompletableFuture.completedFuture(newLadder);
            }
            return this.set(identifier, newLadder);
        });
    }

    public void load(String identifier) {
        Objects.requireNonNull(identifier, "identifier");
        this.cache.synchronous().refresh(identifier);
    }

    public void invalidate(String identifier) {
        Objects.requireNonNull(identifier, "identifier");
        this.cache.synchronous().invalidate(identifier);
        this.cacheHolders.remove(identifier);
        this.listeners.removeAll(identifier);
    }

    @Override
    public CompletableFuture<Boolean> has(String identifier) {
        Objects.requireNonNull(identifier, "identifier");
        if (this.cache.synchronous().getIfPresent(identifier) != null) {
            return CompletableFuture.completedFuture(true);
        }
        return this.dataStore.hasRankLadder(identifier);
    }

    @Override
    public CompletableFuture<RankLadder> set(String identifier, RankLadder newData) {
        Objects.requireNonNull(identifier, "identifier");
        return this.dataStore.setRankLadder(identifier, newData);
    }

    private Consumer<RankLadder> clearListener(String name) {
        Consumer<RankLadder> ret = newData -> {
            this.cache.synchronous().put(name, newData);
            this.listeners.call(name, (RankLadder)newData);
        };
        this.cacheHolders.put(name, ret);
        return ret;
    }

    @Override
    public void addListener(String identifier, Consumer<RankLadder> listener) {
        Objects.requireNonNull(identifier, "identifier");
        Objects.requireNonNull(listener, "listener");
        this.listeners.addListener(identifier, listener);
    }

    @Override
    public Stream<String> names() {
        return this.dataStore.getAllRankLadders();
    }
}

