/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.subject;

import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.util.NodeTree;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class BakedSubjectData {
    private final NodeTree permissions;
    private final List<SubjectRef<?>> parents;
    private final Map<String, String> options;

    BakedSubjectData(NodeTree permissions, List<SubjectRef<?>> parents, Map<String, String> options) {
        Objects.requireNonNull(permissions, "permissions");
        Objects.requireNonNull(parents, "parents");
        Objects.requireNonNull(options, "options");
        this.permissions = permissions;
        this.parents = parents;
        this.options = options;
    }

    public NodeTree permissions() {
        return this.permissions;
    }

    public List<SubjectRef<?>> parents() {
        return this.parents;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BakedSubjectData)) {
            return false;
        }
        BakedSubjectData that = (BakedSubjectData)other;
        if (!this.options.equals(that.options)) {
            return false;
        }
        if (!this.parents.equals(that.parents)) {
            return false;
        }
        return this.permissions.equals(that.permissions);
    }

    public int hashCode() {
        int result = this.permissions.hashCode();
        result = 31 * result + this.parents.hashCode();
        result = 31 * result + this.options.hashCode();
        return result;
    }

    public String toString() {
        return "BakedSubjectData{permissions=" + this.permissions + ", parents=" + this.parents + ", options=" + this.options + '}';
    }
}

