/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.subject;

import ca.stellardrift.permissionsex.context.ContextDefinition;
import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.ext.caffeine.cache.AsyncLoadingCache;
import ca.stellardrift.permissionsex.ext.caffeine.cache.Caffeine;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.MonotonicNonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.configurate.BasicConfigurationNode;
import ca.stellardrift.permissionsex.ext.configurate.ConfigurationNode;
import ca.stellardrift.permissionsex.impl.PermissionsEx;
import ca.stellardrift.permissionsex.impl.subject.BakedSubjectData;
import ca.stellardrift.permissionsex.impl.subject.SubjectDataBaker;
import ca.stellardrift.permissionsex.impl.subject.SubjectTypeCollectionImpl;
import ca.stellardrift.permissionsex.impl.subject.ToDataSubjectRefImpl;
import ca.stellardrift.permissionsex.impl.util.CachingValue;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import ca.stellardrift.permissionsex.subject.CalculatedSubject;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.util.NodeTree;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class CalculatedSubjectImpl<I>
implements Consumer<ImmutableSubjectData>,
CalculatedSubject {
    private final SubjectDataBaker baker;
    private final SubjectRef<I> identifier;
    private final SubjectTypeCollectionImpl<I> type;
    private @MonotonicNonNull ToDataSubjectRefImpl<I> ref;
    private @MonotonicNonNull ToDataSubjectRefImpl<I> transientRef;
    private final AsyncLoadingCache<Set<ContextValue<?>>, BakedSubjectData> data;
    private final Set<Consumer<CalculatedSubject>> updateListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private @MonotonicNonNull CachingValue<Set<ContextValue<?>>> activeContexts;

    CalculatedSubjectImpl(SubjectDataBaker baker, SubjectRef<I> identifier, SubjectTypeCollectionImpl<I> type) {
        this.baker = baker;
        this.identifier = identifier;
        this.type = type;
        this.data = Caffeine.newBuilder().maximumSize(32L).expireAfterAccess(1L, TimeUnit.MINUTES).executor(type.engine().asyncExecutor()).buildAsync((key, executor) -> this.baker.bake(this, (Set<ContextValue<?>>)key));
    }

    void initialize(ToDataSubjectRefImpl<I> persistentRef, ToDataSubjectRefImpl<I> transientRef) {
        this.ref = persistentRef;
        this.transientRef = transientRef;
        this.activeContexts = CachingValue.timeBased(50L, () -> {
            HashSet acc = new HashSet();
            for (ContextDefinition<?> contextDefinition : this.getManager().registeredContextTypes()) {
                this.handleAccumulateSingle(contextDefinition, acc);
            }
            return acc;
        });
    }

    public SubjectRef<I> identifier() {
        return this.identifier;
    }

    public SubjectTypeCollectionImpl<I> containingType() {
        return this.type;
    }

    PermissionsEx<?> getManager() {
        return this.type.engine();
    }

    private BakedSubjectData getData(Set<ContextValue<?>> contexts) {
        Objects.requireNonNull(contexts, "contexts");
        return (BakedSubjectData)this.data.synchronous().get(PCollections.asSet(contexts));
    }

    @Override
    public NodeTree permissions(Set<ContextValue<?>> contexts) {
        return this.getData(contexts).permissions();
    }

    @Override
    public Map<String, String> options(Set<ContextValue<?>> contexts) {
        return this.getData(contexts).options();
    }

    @Override
    public List<SubjectRef<?>> parents(Set<ContextValue<?>> contexts) {
        List<SubjectRef<?>> parents = this.getData(contexts).parents();
        this.getManager().getNotifier().onParentCheck(this.identifier(), contexts, parents);
        return parents;
    }

    private Set<Set<ContextValue<?>>> getCachedContexts() {
        return this.data.synchronous().asMap().keySet();
    }

    @Override
    public Set<ContextValue<?>> activeContexts() {
        if (this.activeContexts == null) {
            throw new IllegalStateException("This subject has not yet been initialized! This is normally done before the future provided by PEX completes.");
        }
        return new HashSet((Collection)this.activeContexts.get());
    }

    @Override
    public CompletableFuture<Set<ContextValue<?>>> usedContextValues() {
        return this.getManager().usedContextTypes().thenApply(defs -> {
            HashSet acc = new HashSet();
            defs.forEach(def -> this.handleAccumulateSingle((ContextDefinition)def, acc));
            return acc;
        });
    }

    private <T> void handleAccumulateSingle(ContextDefinition<T> def, Set<ContextValue<?>> acc) {
        def.accumulateCurrentValues(this, val -> acc.add(def.createValue(val)));
    }

    @Override
    public int permission(Set<ContextValue<?>> contexts, String permission) {
        int ret = this.permissions(contexts).get(Objects.requireNonNull(permission, "permission"));
        this.getManager().getNotifier().onPermissionCheck(this.identifier(), contexts, permission, ret);
        return ret;
    }

    @Override
    public boolean hasPermission(Set<ContextValue<?>> contexts, String permission) {
        int perm = this.permission(contexts, permission);
        if (perm == 0) {
            return ((SubjectTypeCollectionImpl)this.containingType()).type().undefinedPermissionValue(this.identifier.identifier());
        }
        return perm > 0;
    }

    @Override
    public Optional<String> option(Set<ContextValue<?>> contexts, String option) {
        @Nullable String val = this.options(contexts).get(Objects.requireNonNull(option, "option"));
        this.getManager().getNotifier().onOptionCheck(this.identifier(), contexts, option, val);
        return Optional.ofNullable(val);
    }

    @Override
    public ConfigurationNode optionNode(Set<ContextValue<?>> contexts, String option) {
        String val = this.options(contexts).get(Objects.requireNonNull(option, "option"));
        this.getManager().getNotifier().onOptionCheck(this.identifier(), contexts, option, val);
        return BasicConfigurationNode.root().raw(val);
    }

    public ToDataSubjectRefImpl<I> data() {
        return this.ref;
    }

    public ToDataSubjectRefImpl<I> transientData() {
        return this.transientRef;
    }

    @Override
    public @Nullable Object associatedObject() {
        return this.type.type().getAssociatedObject(this.identifier.identifier());
    }

    @Override
    public void registerListener(Consumer<CalculatedSubject> listener) {
        this.updateListeners.add(Objects.requireNonNull(listener));
    }

    @Override
    public void unregisterListener(Consumer<CalculatedSubject> listener) {
        this.updateListeners.remove(Objects.requireNonNull(listener));
    }

    @Override
    public void accept(ImmutableSubjectData newData) {
        this.data.synchronous().invalidateAll();
        this.getManager().loadedSubjectTypes().stream().flatMap(type -> type.activeSubjects().stream()).map(it -> (CalculatedSubjectImpl)it).filter(subj -> {
            for (Set<ContextValue<?>> ent : subj.getCachedContexts()) {
                if (!subj.parents(ent).contains(this.identifier)) continue;
                return true;
            }
            return false;
        }).forEach(subj -> subj.data.synchronous().invalidateAll());
        this.updateListeners.forEach(listener -> listener.accept(this));
    }
}

