/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.subject;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.ext.pcollections.PSet;
import ca.stellardrift.permissionsex.impl.PermissionsEx;
import ca.stellardrift.permissionsex.impl.subject.BakedSubjectData;
import ca.stellardrift.permissionsex.impl.subject.CalculatedSubjectImpl;
import ca.stellardrift.permissionsex.impl.subject.Messages;
import ca.stellardrift.permissionsex.impl.subject.SubjectDataBaker;
import ca.stellardrift.permissionsex.impl.subject.SubjectDataCacheImpl;
import ca.stellardrift.permissionsex.impl.subject.SubjectTypeCollectionImpl;
import ca.stellardrift.permissionsex.impl.subject.ToDataSubjectRefImpl;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import ca.stellardrift.permissionsex.impl.util.Util;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import ca.stellardrift.permissionsex.subject.Segment;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;
import ca.stellardrift.permissionsex.subject.SubjectTypeCollection;
import ca.stellardrift.permissionsex.util.NodeTree;
import ca.stellardrift.permissionsex.util.glob.GlobParseException;
import ca.stellardrift.permissionsex.util.glob.Globs;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

class InheritanceSubjectDataBaker
implements SubjectDataBaker {
    private static final int CIRCULAR_INHERITANCE_THRESHOLD = 3;
    static final SubjectDataBaker INSTANCE = new InheritanceSubjectDataBaker();

    private InheritanceSubjectDataBaker() {
    }

    private static CompletableFuture<Set<ContextValue<?>>> processContexts(PermissionsEx<?> pex, Set<ContextValue<?>> rawContexts) {
        return pex.contextInheritance().thenApply(inheritance -> {
            ContextValue context;
            ArrayDeque inProgressContexts = new ArrayDeque(rawContexts);
            PSet<ContextValue> contexts = PCollections.set();
            while ((context = (ContextValue)inProgressContexts.poll()) != null) {
                if (contexts.contains(context)) continue;
                contexts = contexts.plus(context);
                inProgressContexts.addAll(inheritance.parents(context));
            }
            return contexts;
        });
    }

    @Override
    public CompletableFuture<BakedSubjectData> bake(CalculatedSubjectImpl<?> data, Set<ContextValue<?>> activeContexts) {
        SubjectRef<?> subject = data.identifier();
        return ((CompletableFuture)InheritanceSubjectDataBaker.processContexts(data.getManager(), activeContexts).thenCompose(processedContexts -> {
            SubjectRef<SubjectType<?>> defIdentifier;
            BakeState state = new BakeState(data, (Set<ContextValue<?>>)processedContexts);
            HashMultiset visitedSubjects = HashMultiset.create();
            CompletionStage<Void> ret = this.visitSubject(state, subject, (Multiset<SubjectRef<?>>)visitedSubjects, 0);
            SubjectType<SubjectType<?>> fallbackType = data.getManager().fallbacksType();
            if (state.parents.isEmpty() && state.combinedPermissions.isEmpty() && state.options.isEmpty() && state.defaultValue == 0 && (!subject.type().equals(fallbackType) || !subject.identifier().equals(fallbackType))) {
                ret = ret.thenCompose(arg_0 -> this.lambda$bake$1(state, fallbackType, subject, (Multiset)visitedSubjects, arg_0));
            }
            if (!subject.equals(defIdentifier = ((ToDataSubjectRefImpl)data.data()).getCache().getDefaultIdentifier())) {
                ret = ((CompletableFuture)ret.thenCompose(arg_0 -> this.lambda$bake$2(state, defIdentifier, (Multiset)visitedSubjects, arg_0))).thenCompose(arg_0 -> this.lambda$bake$3(state, data, (Multiset)visitedSubjects, arg_0));
            }
            return ret.thenApply(none -> state);
        })).thenApply(state -> new BakedSubjectData(NodeTree.of(state.combinedPermissions, state.defaultValue), PCollections.asVector(state.parents), PCollections.asMap(state.options)));
    }

    private <I> CompletableFuture<Void> visitSubject(BakeState state, SubjectRef<I> subject, Multiset<SubjectRef<?>> visitedSubjects, int inheritanceLevel) {
        if (visitedSubjects.count(subject) > 3) {
            state.pex.logger().warn(Messages.BAKER_ERROR_CIRCULAR_INHERITANCE.tr(state.base.identifier(), subject));
            return Util.emptyFuture();
        }
        visitedSubjects.add(subject);
        SubjectTypeCollection type = state.pex.subjects((SubjectType)subject.type());
        return ((CompletableFuture)((SubjectDataCacheImpl)((SubjectTypeCollectionImpl)type).persistentData()).data(subject.identifier(), state.base).thenCombine(((SubjectDataCacheImpl)((SubjectTypeCollectionImpl)type).transientData()).data(subject.identifier(), state.base), (arg_0, arg_1) -> this.lambda$visitSubject$7(state, (SubjectTypeCollectionImpl)type, visitedSubjects, inheritanceLevel, arg_0, arg_1))).thenCompose(res -> res);
    }

    private List<PSet<ContextValue<?>>> processContexts(Set<? extends Set<ContextValue<?>>> possibilities, Set<? extends Set<ContextValue<?>>> transientPossibilities, BakeState state) {
        ArrayList ret = new ArrayList();
        HashSet seen = new HashSet(possibilities.size());
        this.processSingleDataContexts(ret, seen, possibilities, state);
        this.processSingleDataContexts(ret, seen, transientPossibilities, state);
        ret.sort(Comparator.comparingInt(Set::size).reversed());
        return ret;
    }

    private void processSingleDataContexts(List<PSet<ContextValue<?>>> accum, Set<PSet<ContextValue<?>>> seen, Set<? extends Set<ContextValue<?>>> possibilities, BakeState state) {
        block0: for (Set<ContextValue<?>> rawSegmentContexts : possibilities) {
            PSet<ContextValue<?>> segmentContexts = PCollections.asSet(rawSegmentContexts);
            if (seen.contains(segmentContexts)) continue;
            seen.add(segmentContexts);
            for (ContextValue contextValue : segmentContexts) {
                boolean matched = false;
                for (ContextValue<?> possibility : state.activeContexts) {
                    if (!this.checkSingleContextMatch(contextValue, possibility, state.pex)) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                continue block0;
            }
            accum.add(segmentContexts);
        }
    }

    private <T> boolean checkSingleContextMatch(ContextValue<T> value, ContextValue<?> other, PermissionsEx<?> pex) {
        return value.key().equals(other.key()) && value.tryResolve(pex) && value.definition().matches((T)value, (T)other.getParsedValue(value.definition()));
    }

    private CompletableFuture<Void> visitSubjectSingle(BakeState state, ImmutableSubjectData data, CompletableFuture<Void> initial, Set<ContextValue<?>> activeCombo, Multiset<SubjectRef<?>> visitedSubjects, int inheritanceLevel) {
        Segment active = data.segment(activeCombo);
        initial = ((CompletableFuture)initial).thenRun(() -> this.visitSingle(state, active, inheritanceLevel));
        for (SubjectRef<?> parent : active.parents()) {
            initial = ((CompletableFuture)initial).thenCompose(none -> this.visitSubject(state, parent, visitedSubjects, inheritanceLevel + 1));
        }
        return initial;
    }

    private void putPermIfNecessary(BakeState state, String perm, int val) {
        Integer existing = state.combinedPermissions.get(perm);
        if (existing == null || Math.abs(val) > Math.abs(existing)) {
            state.combinedPermissions.put(perm, val);
        }
    }

    private void visitSingle(BakeState state, Segment data, int inheritanceLevel) {
        for (Map.Entry<String, Integer> entry : data.permissions().entrySet()) {
            String perm = entry.getKey();
            if (entry.getKey().startsWith("#")) {
                if (inheritanceLevel > 1) continue;
                perm = perm.substring(1);
            }
            try {
                for (String matched : Globs.parse(perm)) {
                    this.putPermIfNecessary(state, matched, entry.getValue());
                }
            }
            catch (GlobParseException e) {
                this.putPermIfNecessary(state, perm, entry.getValue());
            }
        }
        for (SubjectRef subjectRef : data.parents()) {
            state.parents.add(SubjectRef.mapKeySafe(subjectRef));
        }
        for (Map.Entry entry : data.options().entrySet()) {
            if (state.options.containsKey(entry.getKey())) continue;
            state.options.put((String)entry.getKey(), (String)entry.getValue());
        }
        if (Math.abs(data.fallbackPermission()) > Math.abs(state.defaultValue)) {
            state.defaultValue = data.fallbackPermission();
        }
    }

    private /* synthetic */ CompletableFuture lambda$visitSubject$7(BakeState state, SubjectTypeCollectionImpl type, Multiset visitedSubjects, int inheritanceLevel, ImmutableSubjectData persistent, ImmutableSubjectData transientData) {
        CompletableFuture<Void> ret = Util.emptyFuture();
        for (Set set : this.processContexts(persistent.activeContexts(), transientData.activeContexts(), state)) {
            if (type.type().transientHasPriority()) {
                ret = this.visitSubjectSingle(state, transientData, ret, set, visitedSubjects, inheritanceLevel);
                ret = this.visitSubjectSingle(state, persistent, ret, set, visitedSubjects, inheritanceLevel);
                continue;
            }
            ret = this.visitSubjectSingle(state, persistent, ret, set, visitedSubjects, inheritanceLevel);
            ret = this.visitSubjectSingle(state, transientData, ret, set, visitedSubjects, inheritanceLevel);
        }
        return ret;
    }

    private /* synthetic */ CompletionStage lambda$bake$3(BakeState state, CalculatedSubjectImpl data, Multiset visitedSubjects, Void none) {
        return this.visitSubject(state, SubjectRef.subject(data.getManager().defaultsType(), data.getManager().defaultsType()), visitedSubjects, 2);
    }

    private /* synthetic */ CompletionStage lambda$bake$2(BakeState state, SubjectRef defIdentifier, Multiset visitedSubjects, Void none) {
        return this.visitSubject(state, defIdentifier, visitedSubjects, 1);
    }

    private /* synthetic */ CompletionStage lambda$bake$1(BakeState state, SubjectType fallbackType, SubjectRef subject, Multiset visitedSubjects, Void none) {
        return this.visitSubject(state, SubjectRef.subject(fallbackType, subject.type()), visitedSubjects, 0);
    }

    private static final class BakeState {
        final Map<String, Integer> combinedPermissions = new HashMap<String, Integer>();
        final List<SubjectRef<?>> parents = new ArrayList();
        final Map<String, String> options = new HashMap<String, String>();
        int defaultValue;
        final CalculatedSubjectImpl<?> base;
        final PermissionsEx<?> pex;
        final Set<ContextValue<?>> activeContexts;

        BakeState(CalculatedSubjectImpl<?> base, Set<ContextValue<?>> activeContexts) {
            this.base = base;
            this.activeContexts = activeContexts;
            this.pex = base.getManager();
        }
    }
}

