/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.util;

import ca.stellardrift.permissionsex.ext.pcollections.ConsPStack;
import ca.stellardrift.permissionsex.ext.pcollections.HashTreePMap;
import ca.stellardrift.permissionsex.ext.pcollections.HashTreePSet;
import ca.stellardrift.permissionsex.ext.pcollections.PBag;
import ca.stellardrift.permissionsex.ext.pcollections.PMap;
import ca.stellardrift.permissionsex.ext.pcollections.PSet;
import ca.stellardrift.permissionsex.ext.pcollections.PStack;
import ca.stellardrift.permissionsex.ext.pcollections.PVector;
import ca.stellardrift.permissionsex.ext.pcollections.TreePVector;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collector;

public final class PCollections {
    private PCollections() {
    }

    public static <K, V> PMap<K, V> asMap(Map<K, V> map) {
        if (map instanceof PMap) {
            return (PMap)map;
        }
        return HashTreePMap.from(map);
    }

    public static <KI, VI, KO, VO> PMap<KO, VO> asMap(Map<KI, VI> map, BiFunction<KI, VI, KO> keyMapper, BiFunction<KI, VI, VO> valueMapper) {
        PMap<KO, VO> out = PCollections.map();
        for (Map.Entry<KI, VI> entry : map.entrySet()) {
            out = out.plus(keyMapper.apply(entry.getKey(), entry.getValue()), valueMapper.apply(entry.getKey(), entry.getValue()));
        }
        return out;
    }

    public static <E> PSet<E> asSet(Collection<E> set) {
        if (set instanceof PSet) {
            return (PSet)set;
        }
        return HashTreePSet.from(set);
    }

    public static <I, O> PSet<O> asSet(Collection<I> list, Function<? super I, ? extends O> xform) {
        PSet<O> out = HashTreePSet.empty();
        for (I ent : list) {
            out = out.plus(xform.apply(ent));
        }
        return out;
    }

    public static <E> PVector<E> asVector(Collection<E> list) {
        if (list instanceof PVector) {
            return (PVector)list;
        }
        return TreePVector.from(list);
    }

    public static <I, O> PVector<O> asVector(Collection<I> list, Function<? super I, ? extends O> xform) {
        PVector<O> out = TreePVector.empty();
        for (I ent : list) {
            out = out.plus(xform.apply(ent));
        }
        return out;
    }

    public static <E> PStack<E> asStack(Collection<E> stack) {
        if (stack instanceof PStack) {
            return (PStack)stack;
        }
        return ConsPStack.from(stack);
    }

    public static <I, O> PStack<O> asStack(Collection<I> list, Function<? super I, ? extends O> xform) {
        PStack<O> out = ConsPStack.empty();
        for (I ent : list) {
            out = out.plus(xform.apply(ent));
        }
        return out;
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, PMap<K, V>> toPMap() {
        return Collector.of(() -> new PMap[]{HashTreePMap.empty()}, (arr, v) -> {
            arr[0] = arr[0].plus(v.getKey(), v.getValue());
        }, (a, b) -> new PMap[]{a[0].plusAll(b[0])}, a -> a[0], new Collector.Characteristics[0]);
    }

    public static <E> Collector<E, ?, PSet<E>> toPSet() {
        return Collector.of(() -> new PSet[]{HashTreePSet.empty()}, (arr, v) -> {
            arr[0] = arr[0].plus(v);
        }, (a, b) -> new PSet[]{a[0].plusAll(b[0])}, a -> a[0], new Collector.Characteristics[0]);
    }

    public static <E> Collector<E, ?, PVector<E>> toPVector() {
        return Collector.of(() -> new PVector[]{TreePVector.empty()}, (arr, v) -> {
            arr[0] = arr[0].plus(v);
        }, (a, b) -> new PVector[]{a[0].plusAll(b[0])}, a -> a[0], new Collector.Characteristics[0]);
    }

    public static <E> Collector<E, ?, PStack<E>> toPStack() {
        return Collector.of(() -> new PStack[]{ConsPStack.empty()}, (arr, v) -> {
            arr[0] = arr[0].plus(v);
        }, (a, b) -> new PStack[]{a[0].plusAll(b[0])}, a -> a[0], new Collector.Characteristics[0]);
    }

    public static <K1 extends K2, V1 extends V2, K2, V2> PMap<K2, V2> narrow(PMap<K1, V1> input) {
        return input;
    }

    public static <E1 extends E2, E2> PSet<E2> narrow(PSet<E1> input) {
        return input;
    }

    public static <E1 extends E2, E2> PVector<E2> narrow(PVector<E1> input) {
        return input;
    }

    public static <E1 extends E2, E2> PStack<E2> narrow(PStack<E1> input) {
        return input;
    }

    public static <E1 extends E2, E2> PBag<E2> narrow(PBag<E1> input) {
        return input;
    }

    public static <K, V> PMap<K, V> map() {
        return HashTreePMap.empty();
    }

    public static <K, V> PMap<K, V> map(K key, V value) {
        return HashTreePMap.singleton(key, value);
    }

    public static <E> PSet<E> set() {
        return HashTreePSet.empty();
    }

    public static <E> PSet<E> set(E element) {
        return HashTreePSet.singleton(element);
    }

    @SafeVarargs
    public static <E> PSet<E> set(E ... elements) {
        PSet<E> out = PCollections.set();
        for (E element : elements) {
            out = out.plus(element);
        }
        return out;
    }

    public static <E> PVector<E> vector() {
        return TreePVector.empty();
    }

    public static <E> PVector<E> vector(E element) {
        return TreePVector.singleton(element);
    }

    @SafeVarargs
    public static <E> PVector<E> vector(E ... elements) {
        PVector<E> out = PCollections.vector();
        for (E element : elements) {
            out = out.plus(element);
        }
        return out;
    }

    public static <E> PStack<E> stack() {
        return ConsPStack.empty();
    }

    public static <E> PStack<E> stack(E element) {
        return ConsPStack.singleton(element);
    }

    @SafeVarargs
    public static <E> PStack<E> stack(E ... elements) {
        PStack<E> out = PCollections.stack();
        for (E element : elements) {
            out = out.plus(element);
        }
        return out;
    }
}

