/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.impl.util;

import ca.stellardrift.permissionsex.ext.configurate.util.CheckedFunction;
import ca.stellardrift.permissionsex.ext.configurate.util.CheckedSupplier;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class Util {
    private static final CompletableFuture<Object> EMPTY_FUTURE = new CompletableFuture();

    public static <T> Optional<T> castOptional(Optional<?> input, Class<T> clazz) {
        return input.filter(clazz::isInstance).map(clazz::cast);
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable error) {
        CompletableFuture ret = new CompletableFuture();
        ret.completeExceptionally(error);
        return ret;
    }

    public static <T> CompletableFuture<T> emptyFuture() {
        return EMPTY_FUTURE;
    }

    public static <I, T> CompletableFuture<T> failableFuture(I value, CheckedFunction<I, T, ?> func) {
        return Util.failableFuture(() -> func.apply(value));
    }

    public static <T> CompletableFuture<T> failableFuture(CheckedSupplier<T, ?> func) {
        CompletableFuture<T> ret = new CompletableFuture<T>();
        try {
            ret.complete(func.get());
        }
        catch (Throwable e) {
            ret.completeExceptionally(e);
        }
        return ret;
    }

    public static <T> CompletableFuture<T> asyncFailableFuture(CheckedSupplier<T, ?> supplier, Executor exec) {
        CompletableFuture ret = new CompletableFuture();
        exec.execute(() -> {
            try {
                ret.complete(supplier.get());
            }
            catch (Throwable e) {
                ret.completeExceptionally(e);
            }
        });
        return ret;
    }

    static {
        EMPTY_FUTURE.complete(null);
    }
}

