/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft;

import ca.stellardrift.permissionsex.datastore.DataStoreFactory;
import ca.stellardrift.permissionsex.exception.PermissionsLoadingException;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.MonotonicNonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.CommandManager;
import ca.stellardrift.permissionsex.ext.commandframework.CommandTree;
import ca.stellardrift.permissionsex.ext.commandframework.execution.AsynchronousCommandExecutionCoordinator;
import ca.stellardrift.permissionsex.ext.commandframework.execution.CommandExecutionCoordinator;
import ca.stellardrift.permissionsex.ext.commandframework.meta.CommandMeta;
import ca.stellardrift.permissionsex.ext.commandframework.minecraft.extras.MinecraftExceptionHandler;
import ca.stellardrift.permissionsex.ext.kyori.adventure.audience.Audience;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.ComponentLike;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.format.NamedTextColor;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.format.TextColor;
import ca.stellardrift.permissionsex.impl.BaseDirectoryScope;
import ca.stellardrift.permissionsex.impl.ImplementationInterface;
import ca.stellardrift.permissionsex.impl.PermissionsEx;
import ca.stellardrift.permissionsex.impl.config.PermissionsExConfiguration;
import ca.stellardrift.permissionsex.minecraft.BrigadierRegistration;
import ca.stellardrift.permissionsex.minecraft.Messages;
import ca.stellardrift.permissionsex.minecraft.command.CallbackController;
import ca.stellardrift.permissionsex.minecraft.command.CommandException;
import ca.stellardrift.permissionsex.minecraft.command.CommandRegistrationContext;
import ca.stellardrift.permissionsex.minecraft.command.Commander;
import ca.stellardrift.permissionsex.minecraft.command.Formats;
import ca.stellardrift.permissionsex.minecraft.command.MessageFormatter;
import ca.stellardrift.permissionsex.minecraft.command.PEXCommandPreprocessor;
import ca.stellardrift.permissionsex.minecraft.command.definition.PermissionsExCommand;
import ca.stellardrift.permissionsex.minecraft.command.definition.RankingCommands;
import ca.stellardrift.permissionsex.minecraft.profile.ProfileApiResolver;
import ca.stellardrift.permissionsex.subject.InvalidIdentifierException;
import ca.stellardrift.permissionsex.subject.SubjectType;
import ca.stellardrift.permissionsex.subject.SubjectTypeCollection;
import java.io.Closeable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class MinecraftPermissionsEx<T>
implements Closeable {
    private static final String SUBJECTS_USER = "user";
    private static final String SUBJECTS_GROUP = "group";
    private final PermissionsEx<T> engine;
    private final SubjectType<UUID> users;
    private final SubjectType<String> groups;
    private final ProfileApiResolver resolver;
    private final CallbackController callbacks;
    private final @Nullable CommandManager<Commander> commands;
    private final String commandPrefix;
    private final @Nullable Consumer<CommandRegistrationContext> commandContributor;
    private final MessageFormatter formatter;

    public static <V> Builder<V> builder(PermissionsExConfiguration<V> config) {
        return new Builder<V>(config);
    }

    MinecraftPermissionsEx(Builder<T> builder) throws PermissionsLoadingException {
        this.engine = new PermissionsEx(((Builder)builder).config, ((Builder)builder).implementation);
        this.resolver = ProfileApiResolver.resolver(this.engine.asyncExecutor());
        this.callbacks = new CallbackController();
        this.commands = ((Builder)builder).commandManager;
        this.commandPrefix = ((Builder)builder).commandPrefix;
        this.commandContributor = ((Builder)builder).commandContributor;
        Predicate opProvider = ((Builder)builder).opProvider;
        this.users = SubjectType.builder(SUBJECTS_USER, UUID.class).serializedBy(UUID::toString).deserializedBy(id -> {
            try {
                return UUID.fromString(id);
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidIdentifierException((String)id);
            }
        }).friendlyNameResolvedBy(((Builder)builder).cachedUuidResolver).undefinedValues(opProvider::test).associatedObjects(((Builder)builder).playerProvider).build();
        this.groups = SubjectType.stringIdentBuilder(SUBJECTS_GROUP).build();
        this.convertUuids();
        this.users();
        this.groups().cacheAll();
        this.formatter = (MessageFormatter)((Builder)builder).formatterProvider.apply(this);
        this.configureCommandManager();
    }

    public PermissionsEx<T> engine() {
        return this.engine;
    }

    public SubjectTypeCollection<UUID> users() {
        return this.engine.subjects((SubjectType)this.users);
    }

    public SubjectTypeCollection<String> groups() {
        return this.engine.subjects((SubjectType)this.groups);
    }

    public CallbackController callbackController() {
        return this.callbacks;
    }

    public void describe(Audience receiver, boolean verbose) {
        receiver.sendMessage((ComponentLike)Component.text().content("PermissionsEx v").append((Component)Component.text(this.engine.version())));
        receiver.sendMessage(Messages.DESCRIBE_RESPONSE_ACTIVE_DATA_STORE.tr(this.engine.config().getDefaultDataStore().identifier()));
        receiver.sendMessage(Messages.DESCRIBE_RESPONSE_AVAILABLE_DATA_STORES.tr(DataStoreFactory.all().keySet().toString()));
        receiver.sendMessage(Component.empty());
        if (verbose) {
            receiver.sendMessage((Component)this.formatter.header(Messages.DESCRIBE_BASEDIRS_HEADER.bTr(new Object[0])).build());
            receiver.sendMessage(Messages.DESCRIBE_BASEDIRS_CONFIG.tr(this.engine.baseDirectory(BaseDirectoryScope.CONFIG)));
            receiver.sendMessage(Messages.DESCRIBE_BASEDIRS_JAR.tr(this.engine.baseDirectory(BaseDirectoryScope.JAR)));
            receiver.sendMessage(Messages.DESCRIBE_BASEDIRS_SERVER.tr(this.engine.baseDirectory(BaseDirectoryScope.SERVER)));
            receiver.sendMessage(Messages.DESCRIBE_BASEDIRS_WORLDS.tr(this.engine.baseDirectory(BaseDirectoryScope.WORLDS)));
        }
    }

    public MessageFormatter messageFormatter() {
        return this.formatter;
    }

    private void configureCommandManager() {
        if (this.commands == null) {
            return;
        }
        new MinecraftExceptionHandler().withDefaultHandlers().withHandler(MinecraftExceptionHandler.ExceptionType.ARGUMENT_PARSING, e -> Component.text("Invalid command argument: ", (TextColor)NamedTextColor.RED).append(Formats.message(e.getCause()).colorIfAbsent(NamedTextColor.GRAY))).withDecorator(component -> component.colorIfAbsent(NamedTextColor.RED)).apply(this.commands, cmd -> cmd);
        this.commands.registerExceptionHandler(CommandException.class, (sender, err) -> {
            @Nullable Component message = err.componentMessage();
            sender.error(message == null ? Component.text("An unknown error occurred in this command") : message, err.getCause());
        });
        this.commands.registerCommandPreProcessor(new PEXCommandPreprocessor(this));
        if (this.hasBrigadier()) {
            BrigadierRegistration.registerArgumentTypes(this.commands);
        }
        CommandRegistrationContext regCtx = new CommandRegistrationContext(this.commandPrefix, this, this.commands);
        regCtx.push(regCtx.absoluteBuilder("permissionsex", "pex").meta(CommandMeta.DESCRIPTION, "The command for controlling PermissionsEx"), child -> {
            PermissionsExCommand.register(child);
            this.callbackController().registerCommand((CommandRegistrationContext)child);
        });
        regCtx.register(RankingCommands::promote, "promote", "prom", "rankup");
        regCtx.register(RankingCommands::demote, "demote", "dem", "rankdown");
        if (this.commandContributor != null) {
            this.commandContributor.accept(regCtx);
        }
    }

    private boolean hasBrigadier() {
        try {
            Class.forName("ca.stellardrift.permissionsex.ext.commandframework.brigadier.BrigadierManagerHolder");
            Class.forName("com.mojang.brigadier.CommandDispatcher");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private void convertUuids() {
        try {
            InetAddress.getByName("api.mojang.com");
        }
        catch (UnknownHostException ex) {
            this.engine.logger().warn(Messages.UUIDCONVERSION_ERROR_DNS.tr(new Object[0]));
        }
        ((CompletableFuture)this.engine.doBulkOperation(store -> {
            Set<String> toConvert = store.getAllIdentifiers(SUBJECTS_USER).filter(ident -> {
                if (ident.length() != 36) {
                    return true;
                }
                try {
                    UUID.fromString(ident);
                    return false;
                }
                catch (IllegalArgumentException ex) {
                    return true;
                }
            }).collect(Collectors.toSet());
            if (toConvert.isEmpty()) {
                return CompletableFuture.completedFuture(0L);
            }
            this.engine.logger().info(Messages.UUIDCONVERSION_BEGIN.tr(new Object[0]));
            AtomicInteger successCount = new AtomicInteger();
            Stream<CompletableFuture> results = this.resolver.resolveByName(toConvert).map(profile -> {
                String newIdentifier = profile.uuid().toString();
                String lookupName = profile.name();
                CompletableFuture<Boolean> newRegistered = store.isRegistered(SUBJECTS_USER, newIdentifier);
                CompletionStage oldRegistered = store.isRegistered(SUBJECTS_USER, lookupName).thenCombine(store.isRegistered(SUBJECTS_USER, lookupName.toLowerCase(Locale.ROOT)), (a, b) -> a != false || b != false);
                CompletionStage shouldExecute = newRegistered.thenCombine(oldRegistered, (n, o) -> {
                    if (n.booleanValue()) {
                        this.engine.logger().warn(Messages.UUIDCONVERSION_ERROR_DUPLICATE.tr(newIdentifier));
                        return false;
                    }
                    return o;
                });
                return ((CompletableFuture)shouldExecute).thenCompose(execute -> {
                    if (!execute.booleanValue()) {
                        return CompletableFuture.completedFuture(null);
                    }
                    return store.getData(SUBJECTS_USER, profile.name(), null).thenCompose(oldData -> store.setData(SUBJECTS_USER, newIdentifier, oldData.withSegment(PermissionsEx.GLOBAL_CONTEXT, s -> s.withOption("name", profile.name()))).thenAccept(result -> store.setData(SUBJECTS_USER, profile.name(), null).whenComplete((value, err) -> {
                        if (err != null) {
                            err.printStackTrace();
                        } else {
                            successCount.getAndIncrement();
                        }
                    })));
                });
            });
            CompletableFuture[] futureArray = (CompletableFuture[])results.toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(futureArray).thenApply($ -> successCount.get());
        }).thenAccept(result -> {
            if (result != null && result.intValue() > 0) {
                this.engine.logger().info(Messages.UUIDCONVERSION_END.tr(result));
            }
        })).exceptionally(t -> {
            this.engine.logger().error(Messages.UUIDCONVERSION_ERROR_GENERAL.tr(new Object[0]), (Throwable)t);
            return null;
        });
    }

    @Override
    public void close() {
        this.engine.close();
    }

    public static final class Builder<C> {
        private final PermissionsExConfiguration<C> config;
        private @MonotonicNonNull ImplementationInterface implementation;
        private Function<String, @Nullable UUID> cachedUuidResolver = $ -> null;
        private Predicate<UUID> opProvider = $ -> false;
        private Function<UUID, @Nullable ?> playerProvider = $ -> null;
        private @Nullable CommandManager<Commander> commandManager;
        private String commandPrefix = "";
        private @Nullable Consumer<CommandRegistrationContext> commandContributor;
        private Function<MinecraftPermissionsEx<C>, MessageFormatter> formatterProvider = MessageFormatter::new;

        Builder(PermissionsExConfiguration<C> configInstance) {
            this.config = Objects.requireNonNull(configInstance, "config");
        }

        public Builder<C> implementationInterface(ImplementationInterface impl) {
            this.implementation = Objects.requireNonNull(impl, "impl");
            return this;
        }

        public Builder<C> cachedUuidResolver(Function<String, @Nullable UUID> resolver) {
            this.cachedUuidResolver = Objects.requireNonNull(resolver, "uuid");
            return this;
        }

        public Builder<C> opProvider(Predicate<UUID> provider) {
            this.opProvider = Objects.requireNonNull(provider, "provider");
            return this;
        }

        public Builder<C> playerProvider(Function<UUID, @Nullable ?> playerProvider) {
            this.playerProvider = Objects.requireNonNull(playerProvider, "playerProvider");
            return this;
        }

        public Builder<C> commands(Function<Function<CommandTree<Commander>, CommandExecutionCoordinator<Commander>>, CommandManager<Commander>> manager) {
            this.commands(manager, "");
            return this;
        }

        public Builder<C> commands(Function<Function<CommandTree<Commander>, CommandExecutionCoordinator<Commander>>, CommandManager<Commander>> manager, String commandPrefix) {
            this.commandManager = manager.apply(AsynchronousCommandExecutionCoordinator.newBuilder().withAsynchronousParsing().withExecutor(this.implementation.asyncExecutor()).build());
            this.commandPrefix = Objects.requireNonNull(commandPrefix, "commandPrefix");
            return this;
        }

        public Builder<C> commandContributor(Consumer<CommandRegistrationContext> contributor) {
            this.commandContributor = Objects.requireNonNull(contributor, "contributor");
            return this;
        }

        public Builder<C> messageFormatter(Function<MinecraftPermissionsEx<C>, MessageFormatter> formatterProvider) {
            this.formatterProvider = formatterProvider;
            return this;
        }

        public MinecraftPermissionsEx<C> build() throws PermissionsLoadingException {
            Objects.requireNonNull(this.implementation, "An ImplementationInterface must be provided");
            return new MinecraftPermissionsEx(this);
        }
    }
}

