/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft.command;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.CommandArgument;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.standard.UUIDArgument;
import ca.stellardrift.permissionsex.ext.commandframework.meta.CommandMeta;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import ca.stellardrift.permissionsex.minecraft.command.CommandException;
import ca.stellardrift.permissionsex.minecraft.command.CommandRegistrationContext;
import ca.stellardrift.permissionsex.minecraft.command.Commander;
import ca.stellardrift.permissionsex.minecraft.command.Messages;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;

public final class CallbackController {
    private static final CommandArgument<Commander, UUID> CALLBACK_ID = UUIDArgument.of("id");
    private final ConcurrentMap<String, ConcurrentMap<UUID, CallbackInstance>> knownCallbacks = new ConcurrentHashMap<String, ConcurrentMap<UUID, CallbackInstance>>();

    public String registerCallback(Commander source, Consumer<Commander> callback) {
        UUID id = UUID.randomUUID();
        this.knownCallbacks.computeIfAbsent(this.mapKey(source), $ -> new ConcurrentHashMap()).put(id, new CallbackInstance(source, callback, false));
        return "/pex cb " + id;
    }

    private String mapKey(Commander cmd) {
        @Nullable SubjectRef<?> ident = cmd.subjectIdentifier();
        if (ident != null) {
            return ident.serializedIdentifier();
        }
        return PlainComponentSerializer.plain().serialize(cmd.name());
    }

    public void clearOwnedBy(String name) {
        this.knownCallbacks.remove(name);
    }

    public void clearOwnedBy(UUID name) {
        this.knownCallbacks.remove(name.toString().toLowerCase(Locale.ROOT));
    }

    public void registerCommand(CommandRegistrationContext registration) {
        registration.register(builder -> builder.argument(CALLBACK_ID).meta(CommandMeta.DESCRIPTION, "Trigger a registered command callback").hidden().handler(ctx -> {
            UUID id = ctx.get(CALLBACK_ID);
            Map userCalllbacks = (Map)this.knownCallbacks.get(this.mapKey((Commander)ctx.getSender()));
            if (userCalllbacks == null) {
                throw new CommandException(Messages.COMMAND_CALLBACK_ERROR_UNKNOWN_ID.tr(id));
            }
            CallbackInstance callback = (CallbackInstance)userCalllbacks.get(id);
            if (callback == null) {
                throw new CommandException(Messages.COMMAND_CALLBACK_ERROR_UNKNOWN_ID.tr(id));
            }
            if (!this.mapKey(callback.source).equals(this.mapKey((Commander)ctx.getSender()))) {
                throw new CommandException(Messages.COMMAND_CALLBACK_ERROR_ONLY_OWN_ALLOWED.tr(new Object[0]));
            }
            try {
                callback.callback.accept((Commander)ctx.getSender());
            }
            finally {
                if (callback.oneUse) {
                    userCalllbacks.remove(id);
                }
            }
        }), "callback", "cb").toString();
    }

    static final class CallbackInstance {
        final Commander source;
        final Consumer<Commander> callback;
        final boolean oneUse;

        CallbackInstance(Commander source, Consumer<Commander> callback, boolean oneUse) {
            this.source = source;
            this.callback = callback;
            this.oneUse = oneUse;
        }
    }
}

