/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft.command;

import ca.stellardrift.permissionsex.PermissionsEngine;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.Command;
import ca.stellardrift.permissionsex.ext.commandframework.CommandManager;
import ca.stellardrift.permissionsex.minecraft.MinecraftPermissionsEx;
import ca.stellardrift.permissionsex.minecraft.command.Commander;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.function.Consumer;
import java.util.function.Function;

public final class CommandRegistrationContext {
    private final String commandPrefix;
    private final CommandManager<Commander> commandManager;
    private final MinecraftPermissionsEx<?> manager;
    private final Deque<Command.Builder<Commander>> builderStack = new ArrayDeque<Command.Builder<Commander>>();

    public CommandRegistrationContext(String commandPrefix, MinecraftPermissionsEx<?> manager, CommandManager<Commander> commandManager) {
        this.commandPrefix = commandPrefix;
        this.manager = manager;
        this.commandManager = commandManager;
    }

    public PermissionsEngine engine() {
        return this.manager.engine();
    }

    public MinecraftPermissionsEx<?> manager() {
        return this.manager;
    }

    public String commandPrefix() {
        return this.commandPrefix;
    }

    public CommandManager<Commander> commandManager() {
        return this.commandManager;
    }

    public Command.Builder<Commander> head() {
        @Nullable Command.Builder<Commander> head = this.builderStack.peek();
        if (head == null) {
            throw new IllegalStateException("Tried to peek command registration while stack was empty");
        }
        return head;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Command.Builder<Commander> builder, Consumer<CommandRegistrationContext> handler) {
        int startSize = this.builderStack.size();
        this.builderStack.push(builder);
        try {
            handler.accept(this);
        }
        finally {
            this.builderStack.pop();
            if (this.builderStack.size() != startSize) {
                throw new IllegalStateException("Command registration stack corruption detected while popping " + builder.build());
            }
        }
    }

    public void push(Consumer<CommandRegistrationContext> handler, String primaryAlias, String ... aliases) {
        this.push(this.head().literal(primaryAlias, aliases), handler);
    }

    public Command<Commander> register(Function<Command.Builder<Commander>, Command.Builder<Commander>> maker, String primaryAlias, String ... aliases) {
        @Nullable Command.Builder<Commander> headBuilder = this.builderStack.peek();
        if (headBuilder != null) {
            return this.register(maker.apply(headBuilder.literal(primaryAlias, aliases)));
        }
        return this.register(maker.apply(this.absoluteBuilder(primaryAlias, aliases)));
    }

    public Command<Commander> register(Command.Builder<Commander> builder) {
        Command<Commander> built = builder.manager(this.commandManager).build();
        this.commandManager.command(built);
        return built;
    }

    public Command.Builder<Commander> absoluteBuilder(String primaryAlias, String ... aliases) {
        if (!this.commandPrefix.isEmpty()) {
            primaryAlias = this.commandPrefix + primaryAlias;
            aliases = Arrays.copyOf(aliases, aliases.length);
            int length = aliases.length;
            for (int i = 0; i < length; ++i) {
                aliases[i] = this.commandPrefix + aliases[i];
            }
        }
        return this.commandManager.commandBuilder(primaryAlias, aliases);
    }
}

