/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft.command;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.kyori.adventure.audience.ForwardingAudience;
import ca.stellardrift.permissionsex.ext.kyori.adventure.audience.MessageType;
import ca.stellardrift.permissionsex.ext.kyori.adventure.identity.Identified;
import ca.stellardrift.permissionsex.ext.kyori.adventure.identity.Identity;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.BuildableComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.ComponentBuilder;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.ComponentLike;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.TextComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.event.ClickEvent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.event.HoverEventSource;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.format.NamedTextColor;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.format.TextDecoration;
import ca.stellardrift.permissionsex.minecraft.command.CommandException;
import ca.stellardrift.permissionsex.minecraft.command.CommandPermissionException;
import ca.stellardrift.permissionsex.minecraft.command.MessageFormatter;
import ca.stellardrift.permissionsex.minecraft.command.Messages;
import ca.stellardrift.permissionsex.minecraft.command.Permission;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;

public interface Commander
extends ForwardingAudience.Single {
    public Component name();

    public @Nullable SubjectRef<?> subjectIdentifier();

    public MessageFormatter formatter();

    public boolean hasPermission(String var1);

    default public boolean hasPermission(Permission permission) {
        return this.hasPermission(permission.value());
    }

    default public void checkPermission(String permission) throws CommandPermissionException {
        if (!this.hasPermission(permission)) {
            throw new CommandPermissionException(permission);
        }
    }

    default public void checkPermission(Permission permission) throws CommandPermissionException {
        if (!this.hasPermission(permission)) {
            throw new CommandPermissionException(permission.value());
        }
    }

    default public void checkSubjectPermission(String basePermission, SubjectRef<?> subject) throws CommandException {
        if (!(this.hasPermission(basePermission + '.' + subject.type().name() + '.' + subject.serializedIdentifier()) || Objects.equals(subject, this.subjectIdentifier()) && this.hasPermission(basePermission + ".own"))) {
            throw new CommandException(Messages.EXECUTOR_ERROR_NO_PERMISSION.tr(new Object[0]));
        }
    }

    @Override
    default public void sendMessage(@NonNull Identified source, @NonNull Component message, @NonNull MessageType type) {
        this.audience().sendMessage(source, message.colorIfAbsent(this.formatter().responseColor()), type);
    }

    @Override
    default public void sendMessage(@NonNull Identity source, @NonNull Component message, @NonNull MessageType type) {
        this.audience().sendMessage(source, message.colorIfAbsent(this.formatter().responseColor()), type);
    }

    default public void debug(ComponentLike text) {
        this.sendMessage(text.asComponent().colorIfAbsent(NamedTextColor.GRAY));
    }

    default public void error(ComponentLike text) {
        this.error(text, null);
    }

    default public void error(ComponentLike text, @Nullable Throwable error) {
        if (error != null && this.hasPermission("permissionsex.show-stacktrace-on-hover")) {
            TextComponent.Builder base = Component.text().content("The error that occurred was:");
            for (StackTraceElement line : error.getStackTrace()) {
                ((TextComponent.Builder)base.append((Component)Component.newline())).append((Component)Component.text(line.toString().replace("\t", "    ")));
            }
            this.sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(text)).color(NamedTextColor.RED)).hoverEvent((HoverEventSource<?>)base.build()));
        } else {
            this.sendMessage(text.asComponent().colorIfAbsent(NamedTextColor.RED));
        }
    }

    default public void sendPaginated(ComponentLike title, Iterable<? extends ComponentLike> lines) {
        this.sendPaginated(title, null, lines);
    }

    default public void sendPaginated(ComponentLike title, @Nullable ComponentLike header, Iterable<? extends ComponentLike> lines) {
        TextComponent marker = Component.text("#");
        this.sendMessage(Component.join((ComponentLike)Component.space(), Arrays.asList(marker, title, marker)));
        if (header != null) {
            this.sendMessage(header);
        }
        lines.forEach(this::sendMessage);
        this.sendMessage(Component.text("#############################"));
    }

    default public <C extends BuildableComponent<C, B>, B extends ComponentBuilder<C, B>> B callback(B builder, Consumer<Commander> callback) {
        String command = this.formatter().manager().callbackController().registerCallback(this, callback);
        return builder.decoration(TextDecoration.UNDERLINED, true).color(this.formatter().highlightColor()).clickEvent(ClickEvent.runCommand(this.formatter().transformCommand(command)));
    }
}

