/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft.command;

import ca.stellardrift.permissionsex.PermissionsEngine;
import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.Description;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.CommandArgument;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.flags.CommandFlag;
import ca.stellardrift.permissionsex.ext.commandframework.context.CommandContext;
import ca.stellardrift.permissionsex.ext.commandframework.execution.CommandExecutionHandler;
import ca.stellardrift.permissionsex.ext.configurate.reactive.Publisher;
import ca.stellardrift.permissionsex.ext.configurate.reactive.Subscriber;
import ca.stellardrift.permissionsex.ext.geantyref.TypeToken;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import ca.stellardrift.permissionsex.minecraft.command.CommandException;
import ca.stellardrift.permissionsex.minecraft.command.Commander;
import ca.stellardrift.permissionsex.minecraft.command.Messages;
import ca.stellardrift.permissionsex.minecraft.command.argument.Parsers;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public final class Elements {
    public static final CommandFlag<Void> FLAG_TRANSIENT = CommandFlag.newBuilder("transient").withAliases("t").withDescription(Description.of("Whether flags should be stored transiently")).build();
    public static CommandFlag<ContextValue<?>> FLAG_CONTEXT = CommandFlag.newBuilder("contexts").withAliases("c").withArgument(CommandArgument.ofType(new TypeToken<ContextValue<?>>(){}, "value").withParser(Parsers.contextValue())).withDescription(Description.of("Contexts to apply the settings in")).build();

    public static Set<ContextValue<?>> contexts(CommandContext<?> context) {
        @Nullable ContextValue single = (ContextValue)context.flags().get(FLAG_CONTEXT.getName());
        if (single == null) {
            return PCollections.set();
        }
        return PCollections.set(single);
    }

    public static <V> BiConsumer<V, Throwable> messageSender(Commander src, Component message) {
        return Elements.messageSender(src, (Consumer<Component> send) -> send.accept(message));
    }

    public static <V> BiConsumer<@Nullable V, @Nullable Throwable> messageSender(Commander src, Consumer<Consumer<Component>> callback) {
        return (result, err) -> {
            if (err != null) {
                Throwable cause = err.getCause();
                if (err instanceof CompletionException && cause != null) {
                    err = cause;
                }
                if (err instanceof CommandException) {
                    src.error(((CommandException)err).componentMessage());
                } else {
                    src.error(Messages.EXECUTOR_ERROR_ASYNC_TASK.tr(err.getClass().getSimpleName(), err.getMessage()), (Throwable)err);
                    src.formatter().manager().engine().logger().error(Messages.EXECUTOR_ERROR_ASYNC_TASK_CONSOLE.tr(src.name()), (Throwable)err);
                }
            } else {
                callback.accept(src::sendMessage);
            }
        };
    }

    public static <V> CompletableFuture<V> toCompletableFuture(Publisher<V> publisher) {
        final CompletableFuture ret = new CompletableFuture();
        publisher.subscribe(new Subscriber<V>(){

            @Override
            public void submit(V item) {
                ret.complete(item);
            }

            @Override
            public void onError(Throwable ex) {
                ret.completeExceptionally(ex);
            }
        });
        return ret;
    }

    public static <C> CommandExecutionHandler<C> handler(PexExecutor<C> executor) {
        return ctx -> executor.execute(ctx.getSender(), (PermissionsEngine)ctx.get("permissionsex:engine"), ctx);
    }

    public static <C> BiFunction<CommandContext<C>, String, List<String>> engineCompletions(BiFunction<PermissionsEngine, String, List<String>> completer) {
        return (ctx, input) -> {
            PermissionsEngine engine = (PermissionsEngine)ctx.get("permissionsex:engine");
            return (List)completer.apply(engine, (String)input);
        };
    }

    private Elements() {
    }

    @FunctionalInterface
    public static interface PexExecutor<C> {
        public void execute(C var1, PermissionsEngine var2, CommandContext<C> var3);
    }
}

