/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft.command;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.Command;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.CommandArgument;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.StaticArgument;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.TextComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.TranslatableComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.format.NamedTextColor;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.format.TextColor;
import ca.stellardrift.permissionsex.ext.kyori.adventure.util.ComponentMessageThrowable;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import ca.stellardrift.permissionsex.minecraft.command.MessageFormatter;
import ca.stellardrift.permissionsex.minecraft.command.Messages;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Formats {
    private static final Component BOOL_TRUE = ((TranslatableComponent.Builder)Messages.FORMATTER_BOOLEAN_TRUE.bTr(new Object[0]).color(NamedTextColor.GREEN)).build();
    private static final Component BOOL_FALSE = ((TranslatableComponent.Builder)Messages.FORMATTER_BOOLEAN_FALSE.bTr(new Object[0]).color(NamedTextColor.RED)).build();

    private Formats() {
    }

    public static Component permission(String permission, int value) {
        NamedTextColor color = value > 0 ? NamedTextColor.GREEN : (value < 0 ? NamedTextColor.RED : NamedTextColor.GRAY);
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(permission, (TextColor)color))).append(MessageFormatter.EQUALS_SIGN)).append((Component)Component.text(value))).build();
    }

    public static Component permissionValue(int value) {
        NamedTextColor color = value > 0 ? NamedTextColor.GREEN : (value < 0 ? NamedTextColor.RED : NamedTextColor.GRAY);
        return Component.text(value, (TextColor)color);
    }

    public static Component option(String option, String value) {
        return ((TextComponent.Builder)((TextComponent.Builder)Component.text().content(option).append(MessageFormatter.EQUALS_SIGN)).append((Component)Component.text(value))).build();
    }

    public static Component bool(boolean value) {
        return value ? BOOL_TRUE : BOOL_FALSE;
    }

    public static Component contexts(Set<ContextValue<?>> contexts) {
        if (contexts.isEmpty()) {
            return Messages.COMMON_ARGS_CONTEXT_GLOBAL.tr(new Object[0]);
        }
        return Component.text(contexts.toString());
    }

    public static String formatCommand(Command<?> command, Map<CommandArgument<?, ?>, String> placeholders) {
        return Formats.formatCommand(command.getArguments(), placeholders);
    }

    public static String formatCommand(Command.Builder<?> command, Map<CommandArgument<?, ?>, String> placeholders) {
        return Formats.formatCommand(command.build().getArguments(), placeholders);
    }

    private static String formatCommand(List<? extends CommandArgument<?, ?>> arguments, Map<CommandArgument<?, ?>, String> placeholders) {
        StringBuilder builder = new StringBuilder("/");
        for (CommandArgument<?, ?> argument : arguments) {
            if (argument instanceof StaticArgument) {
                builder.append(argument.getName());
            } else {
                @Nullable String value = placeholders.get(argument);
                if (value == null) break;
                builder.append(value);
            }
            builder.append(" ");
        }
        return builder.toString();
    }

    public static String formatCommand(Command<?> command, CommandArgument<?, ?> arg1, String val1) {
        return Formats.formatCommand(command, PCollections.map(arg1, val1));
    }

    public static String formatCommand(Command<?> command, CommandArgument<?, ?> arg1, String val1, CommandArgument<?, ?> arg2, String val2) {
        return Formats.formatCommand(command, PCollections.map(arg1, val1).plus(arg2, val2));
    }

    public static Component message(Throwable throwable) {
        if (throwable instanceof ComponentMessageThrowable) {
            @Nullable Component msg = ((ComponentMessageThrowable)((Object)throwable)).componentMessage();
            return msg == null ? Component.text("null") : msg;
        }
        return Component.text(throwable.getMessage());
    }

    public static TextColor lerp(double pct, TextColor from, TextColor to) {
        return TextColor.color(Math.round((double)from.red() + pct * (double)(to.red() - from.red())), Math.round((double)from.green() + pct * (double)(to.green() - from.green())), Math.round((double)from.blue() + pct * (double)(to.blue() - from.blue())));
    }
}

