/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft.command;

import ca.stellardrift.permissionsex.context.ContextDefinitionProvider;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.BuildableComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.ComponentBuilder;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.ComponentLike;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.TextComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.event.ClickEvent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.event.HoverEvent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.format.NamedTextColor;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.format.Style;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.format.TextColor;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.format.TextDecoration;
import ca.stellardrift.permissionsex.minecraft.MinecraftPermissionsEx;
import ca.stellardrift.permissionsex.minecraft.command.ButtonType;
import ca.stellardrift.permissionsex.minecraft.command.Messages;
import ca.stellardrift.permissionsex.subject.CalculatedSubject;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;
import ca.stellardrift.permissionsex.subject.SubjectTypeCollection;
import java.util.concurrent.ExecutionException;

public class MessageFormatter {
    public static final TextColor DEFAULT_MESSAGE_COLOR = NamedTextColor.DARK_AQUA;
    public static final TextColor DEFAULT_HIGHLIGHT_COLOR = TextColor.color(0x55CCCC);
    public static final Component EQUALS_SIGN = Component.text("=", (TextColor)NamedTextColor.GRAY);
    public static final Component SLASH = Component.text("/");
    private final MinecraftPermissionsEx<?> manager;
    private final TextColor highlightColor;
    private final TextColor messageColor;

    public MessageFormatter(MinecraftPermissionsEx<?> manager) {
        this(manager, DEFAULT_MESSAGE_COLOR, DEFAULT_HIGHLIGHT_COLOR);
    }

    public MessageFormatter(MinecraftPermissionsEx<?> manager, TextColor messageColor, TextColor highlightColor) {
        this.manager = manager;
        this.messageColor = messageColor;
        this.highlightColor = highlightColor;
    }

    final MinecraftPermissionsEx<?> manager() {
        return this.manager;
    }

    public final TextColor responseColor() {
        return this.messageColor;
    }

    public final TextColor highlightColor() {
        return this.highlightColor;
    }

    protected String transformCommand(String cmd) {
        return cmd;
    }

    protected <I> @Nullable String friendlyName(SubjectRef<I> reference) {
        return null;
    }

    public final Component subject(CalculatedSubject subject) {
        return this.subject(subject.identifier());
    }

    public <I> Component subject(SubjectRef<I> subject) {
        SubjectTypeCollection type = this.manager.engine().subjects((SubjectType)subject.type());
        String serializedIdent = subject.type().serializeIdentifier(subject.identifier());
        @Nullable String name = this.friendlyName(subject);
        if (name == null) {
            try {
                name = type.persistentData().data(subject.identifier(), null).get().segment(ContextDefinitionProvider.GLOBAL_CONTEXT).options().get("name");
            }
            catch (InterruptedException | ExecutionException ex) {
                throw new RuntimeException(ex);
            }
        }
        Object nameText = name != null ? ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(serializedIdent, (TextColor)NamedTextColor.GRAY))).append(SLASH)).append((Component)Component.text(name))).build() : Component.text(serializedIdent);
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text(subject.type().name()).decorate(TextDecoration.BOLD))).append((Component)Component.space())).append((Component)nameText)).hoverEvent(HoverEvent.showText(Messages.FORMATTER_BUTTON_INFO_PROMPT.tr(new Object[0])))).clickEvent(ClickEvent.runCommand(this.transformCommand("/pex " + subject.type().name() + ' ' + serializedIdent + " info")))).build();
    }

    public <C extends BuildableComponent<C, B>, B extends ComponentBuilder<C, B>> Component button(B builder, ButtonType type, @Nullable ComponentLike tooltip, String command, boolean execute) {
        TextColor buttonColor;
        switch (type) {
            case POSITIVE: {
                buttonColor = NamedTextColor.GREEN;
                break;
            }
            case NEGATIVE: {
                buttonColor = NamedTextColor.RED;
                break;
            }
            default: {
                buttonColor = this.highlightColor;
            }
        }
        builder.color(buttonColor);
        if (tooltip != null) {
            builder.hoverEvent(HoverEvent.showText(tooltip));
        }
        if (execute) {
            builder.clickEvent(ClickEvent.runCommand(this.transformCommand(command)));
        } else {
            builder.clickEvent(ClickEvent.suggestCommand(this.transformCommand(command)));
        }
        return builder.build();
    }

    public final <C extends BuildableComponent<C, B>, B extends ComponentBuilder<C, B>> B header(B builder) {
        return builder.decoration(TextDecoration.BOLD, true);
    }

    public final <C extends BuildableComponent<C, B>, B extends ComponentBuilder<C, B>> B hl(B builder) {
        return builder.color(this.highlightColor);
    }

    public final Style.Builder header(Style.Builder builder) {
        return builder.decoration(TextDecoration.BOLD, true);
    }

    public final Style.Builder hl(Style.Builder builder) {
        return builder.color(this.highlightColor);
    }
}

