/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft.command;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.permission.CommandPermission;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.minecraft.command.PermissionImpl;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.immutables.value.Value;

@Value.Immutable(builder=false)
public abstract class Permission
implements CommandPermission {
    public static Permission of(String permission) {
        return Permission.of(permission, Component.empty(), 0);
    }

    public static Permission of(String permission, Component description) {
        return Permission.of(permission, description, 0);
    }

    public static Permission of(String permission, Component component, int defaultValue) {
        return new PermissionImpl(permission, component, defaultValue);
    }

    public static Permission pex(String value) {
        return new PermissionImpl("permissionsex." + value, Component.empty(), 0);
    }

    @Value.Parameter
    public abstract String value();

    public abstract Permission value(String var1);

    @Value.Parameter
    public abstract @Nullable Component description();

    @Value.Parameter
    @Value.Default
    public int defaultValue() {
        return 0;
    }

    public final Permission then(SubjectRef<?> other) {
        Objects.requireNonNull(other, "other");
        return this.value(this.value() + '.' + other.type().name() + '.' + other.serializedIdentifier());
    }

    public final Permission then(String other) {
        Objects.requireNonNull(other, "other");
        return this.value(this.value() + '.' + other);
    }

    @Override
    public final @NonNull Collection<@NonNull CommandPermission> getPermissions() {
        return Collections.singleton(this);
    }

    @Override
    public final String toString() {
        return this.value();
    }
}

