/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft.command.argument;

import ca.stellardrift.permissionsex.context.ContextDefinition;
import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParseResult;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParser;
import ca.stellardrift.permissionsex.ext.commandframework.context.CommandContext;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.parsing.NoInputProvidedException;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import ca.stellardrift.permissionsex.minecraft.MinecraftPermissionsEx;
import ca.stellardrift.permissionsex.minecraft.command.CommandException;
import ca.stellardrift.permissionsex.minecraft.command.Commander;
import ca.stellardrift.permissionsex.minecraft.command.argument.Messages;
import ca.stellardrift.permissionsex.subject.CalculatedSubject;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class ContextValueParser
implements ArgumentParser<Commander, ContextValue<?>> {
    private static final Pattern CONTEXT_SPLIT = Pattern.compile("=");

    ContextValueParser() {
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull ContextValue<?>> parse(@NonNull CommandContext<@NonNull Commander> ctx, @NonNull Queue<@NonNull String> queue) {
        @Nullable String provided = queue.peek();
        if (provided == null) {
            return ArgumentParseResult.failure(new NoInputProvidedException(ContextValueParser.class, ctx));
        }
        String[] contexts = CONTEXT_SPLIT.split(provided, 2);
        if (contexts.length != 2) {
            return ArgumentParseResult.failure(new CommandException(Messages.CONTEXT_ERROR_FORMAT.tr(new Object[0])));
        }
        @Nullable ContextDefinition<?> definition = ((MinecraftPermissionsEx)ctx.get("permissionsex:manager")).engine().contextDefinition(contexts[0]);
        if (definition == null) {
            return ArgumentParseResult.failure(new CommandException(Messages.CONTEXT_ERROR_TYPE.tr(contexts[0])));
        }
        return this.toContextValue(definition, contexts[1]);
    }

    private <V> ArgumentParseResult<ContextValue<?>> toContextValue(ContextDefinition<V> definition, String input) {
        @Nullable V value = definition.deserialize(input);
        if (value == null) {
            return ArgumentParseResult.failure(new CommandException(Messages.CONTEXT_ERROR_VALUE.tr(definition.name())));
        }
        return ArgumentParseResult.success(definition.createValue(value));
    }

    @Override
    public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<Commander> ctx, @NonNull String input) {
        MinecraftPermissionsEx manager = (MinecraftPermissionsEx)ctx.get("permissionsex:manager");
        String[] split = CONTEXT_SPLIT.split(input, 2);
        if (split.length < 2) {
            return manager.engine().registeredContextTypes().stream().map(ContextDefinition::name).collect(Collectors.toList());
        }
        @Nullable ContextDefinition<?> definition = manager.engine().contextDefinition(split[0]);
        @Nullable SubjectRef<?> senderId = ctx.getSender().subjectIdentifier();
        if (definition == null || senderId == null) {
            return Collections.emptyList();
        }
        return this.serializeSuggestions(definition, manager.engine().subject(senderId).join());
    }

    private <V> List<String> serializeSuggestions(ContextDefinition<V> definition, CalculatedSubject subject) {
        return PCollections.asVector(definition.suggestValues(subject), ent -> definition.name() + "=" + definition.serialize(ent));
    }

    @Override
    public boolean isContextFree() {
        return true;
    }
}

