/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft.command.argument;

import ca.stellardrift.permissionsex.ext.commandframework.context.CommandContext;
import ca.stellardrift.permissionsex.minecraft.command.argument.ContextValueParser;
import ca.stellardrift.permissionsex.minecraft.command.argument.PatternParser;
import ca.stellardrift.permissionsex.minecraft.command.argument.PermissionValueParser;
import ca.stellardrift.permissionsex.minecraft.command.argument.RankLadderParser;
import ca.stellardrift.permissionsex.minecraft.command.argument.SubjectIdentifierParser;
import ca.stellardrift.permissionsex.minecraft.command.argument.SubjectTypeParser;
import ca.stellardrift.permissionsex.subject.SubjectType;
import java.util.function.Function;

public final class Parsers {
    private static final ContextValueParser CONTEXT_VALUE = new ContextValueParser();
    private static final PermissionValueParser<Object> PERMISSION_VALUE = new PermissionValueParser();
    private static final RankLadderParser<Object> RANK_LADDER = new RankLadderParser();
    private static final SubjectTypeParser<Object> SUBJECT_TYPE = new SubjectTypeParser();
    private static final PatternParser<Object> GREEDY_PATTERN = new PatternParser(true);
    private static final PatternParser<Object> NON_GREEDY_PATTERN = new PatternParser(false);

    public static ContextValueParser contextValue() {
        return CONTEXT_VALUE;
    }

    public static <C> PermissionValueParser<C> permissionValue() {
        return PERMISSION_VALUE;
    }

    public static <C> RankLadderParser<C> rankLadder() {
        return RANK_LADDER;
    }

    public static <C> SubjectTypeParser<C> subjectType() {
        return SUBJECT_TYPE;
    }

    public static <C, I> SubjectIdentifierParser<C, I> subjectIdentifier(SubjectType<I> type) {
        return new SubjectIdentifierParser(type);
    }

    public static <C> SubjectIdentifierParser<C, Object> subjectIdentifier(Function<CommandContext<C>, SubjectType<?>> typeExtractor) {
        return new SubjectIdentifierParser(typeExtractor);
    }

    public static <C> PatternParser<C> pattern() {
        return NON_GREEDY_PATTERN;
    }

    public static <C> PatternParser<C> greedyPattern() {
        return GREEDY_PATTERN;
    }

    private Parsers() {
    }
}

