/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft.command.argument;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParseResult;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParser;
import ca.stellardrift.permissionsex.ext.commandframework.context.CommandContext;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.parsing.NoInputProvidedException;
import ca.stellardrift.permissionsex.minecraft.command.CommandException;
import ca.stellardrift.permissionsex.minecraft.command.argument.Messages;
import java.util.Queue;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class PatternParser<C>
implements ArgumentParser<C, Pattern> {
    private final boolean greedy;

    PatternParser(boolean greedy) {
        this.greedy = greedy;
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull Pattern> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
        if (inputQueue.isEmpty()) {
            return ArgumentParseResult.failure(new NoInputProvidedException(PatternParser.class, commandContext));
        }
        String input = this.greedy ? String.join((CharSequence)" ", inputQueue) : inputQueue.peek();
        try {
            Pattern result = Pattern.compile(input);
            if (this.greedy) {
                inputQueue.clear();
            } else {
                inputQueue.remove();
            }
            return ArgumentParseResult.success(result);
        }
        catch (PatternSyntaxException ex) {
            return ArgumentParseResult.failure(new PatternParseException(ex));
        }
    }

    public boolean greedy() {
        return this.greedy;
    }

    @Override
    public boolean isContextFree() {
        return true;
    }

    public static final class PatternParseException
    extends CommandException {
        private static final long serialVersionUID = -4380135510811949525L;
        private final String pattern;
        private final String error;
        private final int index;

        public PatternParseException(PatternSyntaxException ex) {
            super(Messages.PATTERN_ERROR_SYNTAX.tr(ex.getPattern(), ex.getIndex(), ex.getDescription()));
            this.pattern = ex.getPattern();
            this.error = ex.getDescription();
            this.index = ex.getIndex();
        }

        public String pattern() {
            return this.pattern;
        }

        public String errorDescription() {
            return this.error;
        }

        public int index() {
            return this.index;
        }
    }
}

