/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft.command.argument;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParseResult;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParser;
import ca.stellardrift.permissionsex.ext.commandframework.context.CommandContext;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.parsing.NoInputProvidedException;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.parsing.NumberParseException;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;

public class PermissionValueParser<C>
implements ArgumentParser<C, Integer> {
    private static final Map<String, Integer> CONSTANTS = PCollections.map("true", 1).plus("yes", 1).plus("false", -1).plus("no", -1).plus("zero", 0).plus("none", 0).plus("null", 0).plus("unset", 0);
    private static final List<String> KEYS = PCollections.asVector(CONSTANTS.keySet());

    PermissionValueParser() {
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull Integer> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
        @Nullable String input = inputQueue.peek();
        if (input == null) {
            return ArgumentParseResult.failure(new NoInputProvidedException(PermissionValueParser.class, commandContext));
        }
        Integer option = CONSTANTS.get(input.toLowerCase(Locale.ROOT));
        if (option == null) {
            try {
                option = Integer.parseInt(input);
            }
            catch (IllegalArgumentException ex) {
                return ArgumentParseResult.failure(new PermissionValueParseException(input, commandContext));
            }
        }
        inputQueue.remove();
        return ArgumentParseResult.success(option);
    }

    @Override
    public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
        return KEYS;
    }

    @Override
    public boolean isContextFree() {
        return true;
    }

    public static final class PermissionValueParseException
    extends NumberParseException {
        private static final long serialVersionUID = -3088598808176112429L;

        PermissionValueParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(input, Integer.MIN_VALUE, Integer.MAX_VALUE, PermissionValueParser.class, context);
        }

        @Override
        public @NonNull String getNumberType() {
            return "permission value";
        }

        @Override
        public boolean hasMax() {
            return false;
        }

        @Override
        public boolean hasMin() {
            return false;
        }
    }
}

