/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft.command.argument;

import ca.stellardrift.permissionsex.PermissionsEngine;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParseResult;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParser;
import ca.stellardrift.permissionsex.ext.commandframework.context.CommandContext;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.parsing.NoInputProvidedException;
import ca.stellardrift.permissionsex.minecraft.command.argument.ContextValueParser;
import ca.stellardrift.permissionsex.rank.RankLadder;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;

public final class RankLadderParser<C>
implements ArgumentParser<C, RankLadder> {
    RankLadderParser() {
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull RankLadder> parse(@NonNull CommandContext<@NonNull C> ctx, @NonNull Queue<@NonNull String> inputQueue) {
        @Nullable String input = inputQueue.poll();
        if (input == null) {
            return ArgumentParseResult.failure(new NoInputProvidedException(ContextValueParser.class, ctx));
        }
        PermissionsEngine engine = (PermissionsEngine)ctx.get("permissionsex:engine");
        return ArgumentParseResult.success(engine.ladders().get(input, null).join());
    }

    @Override
    public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> ctx, @NonNull String input) {
        PermissionsEngine engine = (PermissionsEngine)ctx.get("permissionsex:engine");
        return engine.ladders().names().collect(Collectors.toList());
    }

    @Override
    public boolean isContextFree() {
        return true;
    }
}

