/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft.command.argument;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParseResult;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParser;
import ca.stellardrift.permissionsex.ext.commandframework.context.CommandContext;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.parsing.NoInputProvidedException;
import ca.stellardrift.permissionsex.impl.subject.SubjectTypeCollectionImpl;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import ca.stellardrift.permissionsex.minecraft.MinecraftPermissionsEx;
import ca.stellardrift.permissionsex.subject.InvalidIdentifierException;
import ca.stellardrift.permissionsex.subject.SubjectType;
import java.util.List;
import java.util.Queue;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class SubjectIdentifierParser<C, I>
implements ArgumentParser<C, I> {
    private final boolean contextFree;
    private final Function<CommandContext<C>, SubjectType<I>> subjectTypeExtractor;

    SubjectIdentifierParser(SubjectType<I> identifier) {
        this.subjectTypeExtractor = ctx -> identifier;
        this.contextFree = true;
    }

    SubjectIdentifierParser(Function<CommandContext<C>, SubjectType<I>> subjectTypeExtractor) {
        this.subjectTypeExtractor = subjectTypeExtractor;
        this.contextFree = false;
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull I> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
        I identifier;
        @Nullable String input = inputQueue.peek();
        if (input == null) {
            return ArgumentParseResult.failure(new NoInputProvidedException(SubjectIdentifierParser.class, commandContext));
        }
        SubjectType<I> subjectType = this.subjectTypeExtractor.apply(commandContext);
        InvalidIdentifierException possibleException = null;
        try {
            identifier = subjectType.parseIdentifier(input);
        }
        catch (InvalidIdentifierException ex) {
            possibleException = ex;
            identifier = subjectType.parseOrCoerceIdentifier(input);
        }
        if (identifier == null) {
            return ArgumentParseResult.failure(possibleException);
        }
        inputQueue.remove();
        return ArgumentParseResult.success(identifier);
    }

    @Override
    public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
        MinecraftPermissionsEx manager = (MinecraftPermissionsEx)commandContext.get("permissionsex:manager");
        SubjectType<I> type = this.subjectTypeExtractor.apply(commandContext);
        if (type == null) {
            return PCollections.vector();
        }
        return ((SubjectTypeCollectionImpl)manager.engine().subjects((SubjectType)type)).allIdentifiers().limit(100L).map(type::serializeIdentifier).collect(Collectors.toList());
    }

    @Override
    public boolean isContextFree() {
        return this.contextFree;
    }
}

