/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft.command.argument;

import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.NonNull;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParseResult;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.parser.ArgumentParser;
import ca.stellardrift.permissionsex.ext.commandframework.context.CommandContext;
import ca.stellardrift.permissionsex.ext.commandframework.exceptions.parsing.NoInputProvidedException;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import ca.stellardrift.permissionsex.minecraft.MinecraftPermissionsEx;
import ca.stellardrift.permissionsex.minecraft.command.CommandException;
import ca.stellardrift.permissionsex.minecraft.command.argument.Messages;
import ca.stellardrift.permissionsex.subject.SubjectType;
import java.util.List;
import java.util.Locale;
import java.util.Queue;

public final class SubjectTypeParser<C>
implements ArgumentParser<C, SubjectType<?>> {
    SubjectTypeParser() {
    }

    @Override
    public @NonNull ArgumentParseResult<SubjectType<?>> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<String> inputQueue) {
        @Nullable String input = inputQueue.peek();
        if (input == null) {
            return ArgumentParseResult.failure(new NoInputProvidedException(SubjectTypeParser.class, commandContext));
        }
        MinecraftPermissionsEx pex = (MinecraftPermissionsEx)commandContext.get("permissionsex:manager");
        String lowerInput = input.toLowerCase(Locale.ROOT);
        for (SubjectType<?> type : pex.engine().knownSubjectTypes()) {
            if (!type.name().toLowerCase(Locale.ROOT).startsWith(lowerInput)) continue;
            inputQueue.remove();
            return ArgumentParseResult.success(type);
        }
        return ArgumentParseResult.failure(new CommandException(Messages.SUBJECTTYPE_ERROR_NOTATYPE.tr(input)));
    }

    @Override
    public @NonNull List<String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
        MinecraftPermissionsEx pex = (MinecraftPermissionsEx)commandContext.get("permissionsex:manager");
        return PCollections.asVector(pex.engine().knownSubjectTypes(), SubjectType::name);
    }
}

