/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft.command.definition;

import ca.stellardrift.permissionsex.PermissionsEngine;
import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.ext.commandframework.Command;
import ca.stellardrift.permissionsex.ext.commandframework.meta.CommandMeta;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.BuildableComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.ComponentBuilder;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.ComponentLike;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.TextComponent;
import ca.stellardrift.permissionsex.minecraft.command.Commander;
import ca.stellardrift.permissionsex.minecraft.command.Elements;
import ca.stellardrift.permissionsex.minecraft.command.Formats;
import ca.stellardrift.permissionsex.minecraft.command.Permission;
import ca.stellardrift.permissionsex.minecraft.command.definition.Messages;
import ca.stellardrift.permissionsex.minecraft.command.definition.SubjectRefProvider;
import ca.stellardrift.permissionsex.subject.CalculatedSubject;
import ca.stellardrift.permissionsex.subject.ImmutableSubjectData;
import ca.stellardrift.permissionsex.subject.Segment;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.util.TranslatableProvider;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

final class InfoSubcommand {
    private InfoSubcommand() {
    }

    static Command.Builder<Commander> register(Command.Builder<Commander> builder, SubjectRefProvider subjectProvider) {
        Permission perm = Permission.pex("info");
        return builder.permission(perm).meta(CommandMeta.DESCRIPTION, Messages.INFO_DESCRIPTION.key()).handler(Elements.handler((source, engine, ctx) -> {
            CalculatedSubject subject = subjectProvider.provideCalculated(ctx, perm);
            new Printer((Commander)source, engine, subject).printInfo();
        }));
    }

    static class Printer {
        private static final Component COLON = Component.text(":");
        private static final Component INDENT = Component.text("  ");
        private static final Component DOUBLE_INDENT = Component.text("    ");
        private final Commander source;
        private final PermissionsEngine engine;
        private final CalculatedSubject subject;

        Printer(Commander source, PermissionsEngine engine, CalculatedSubject subject) {
            this.source = source;
            this.engine = engine;
            this.subject = subject;
        }

        void printInfo() {
            Object associatedObject;
            SubjectRef.ToData<?> transientData = this.subject.transientData();
            SubjectRef.ToData<?> persistentData = this.subject.data();
            this.echo((ComponentLike)this.source.formatter().header(Messages.INFO_HEADER.bTr(this.source.formatter().subject(this.subject))));
            if (this.engine.debugMode() && (associatedObject = this.subject.associatedObject()) != null) {
                this.echo((ComponentLike)this.hl(Messages.INFO_ASSOCIATED_OBJECT.bTr(new Object[0])).append((Component)Component.text(associatedObject.toString())));
            }
            this.echo((ComponentLike)this.hlKeyValue(Messages.INFO_ACTIVE_CONTEXTS.bTr(new Object[0]), Component.text(this.subject.activeContexts().toString())));
            this.echo((ComponentLike)this.hlKeyValue(Messages.INFO_ACTIVE_USED_CONTEXTS.bTr(new Object[0]), Component.text(this.subject.usedContextValues().join().toString())));
            this.printPermissions(Messages.INFO_HEADER_PERMISSIONS, persistentData);
            this.printPermissions(Messages.INFO_HEADER_PERMISSIONS_TRANSIENT, transientData);
            this.printOptions(Messages.INFO_HEADER_OPTIONS, persistentData);
            this.printOptions(Messages.INFO_HEADER_OPTIONS_TRANSIENT, transientData);
            this.printParents(Messages.INFO_HEADER_PARENTS, persistentData);
            this.printParents(Messages.INFO_HEADER_PARENTS_TRANSIENT, transientData);
        }

        private void echoHead(TranslatableProvider message) {
            this.source.sendMessage(this.source.formatter().hl(message.bTr(new Object[0])));
        }

        private <C extends BuildableComponent<C, B>, B extends ComponentBuilder<C, B>> B hl(B builder) {
            return this.source.formatter().hl(builder);
        }

        private <C extends BuildableComponent<C, B>, B extends ComponentBuilder<C, B>> Component hlKeyValue(B key, Component value) {
            return TextComponent.ofChildren(this.source.formatter().hl(key), Component.space(), value);
        }

        private void echo(ComponentLike message) {
            this.source.sendMessage(message);
        }

        private void echo(ComponentLike ... message) {
            this.source.sendMessage(TextComponent.ofChildren(message));
        }

        private void printForSegments(TranslatableProvider header, SubjectRef.ToData<?> ref, Predicate<Segment> filter, Consumer<Segment> printer) {
            boolean first = true;
            ImmutableSubjectData data = ref.get();
            for (Map.Entry<Set<ContextValue<?>>, Segment> entry : data.segments().entrySet()) {
                Segment segment = entry.getValue();
                if (!filter.test(segment)) continue;
                if (first) {
                    this.echoHead(header);
                }
                first = false;
                this.echo(INDENT, Formats.contexts(entry.getKey()), COLON);
                printer.accept(segment);
            }
        }

        private void printPermissions(TranslatableProvider header, SubjectRef.ToData<?> ref) {
            this.printForSegments(header, ref, seg -> !seg.permissions().isEmpty() || seg.fallbackPermission() != 0, segment -> {
                this.echo(DOUBLE_INDENT, this.hl(Messages.INFO_PERMISSIONS_DEFAULT.bTr(segment.fallbackPermission())));
                for (Map.Entry<String, Integer> option : segment.permissions().entrySet()) {
                    this.echo(DOUBLE_INDENT, Formats.permission(option.getKey(), option.getValue()));
                }
            });
        }

        private void printOptions(TranslatableProvider header, SubjectRef.ToData<?> ref) {
            this.printForSegments(header, ref, seg -> !seg.options().isEmpty(), segment -> {
                for (Map.Entry<String, String> option : segment.options().entrySet()) {
                    this.echo(DOUBLE_INDENT, Formats.option(option.getKey(), option.getValue()));
                }
            });
        }

        private void printParents(TranslatableProvider header, SubjectRef.ToData<?> ref) {
            this.printForSegments(header, ref, seg -> !seg.parents().isEmpty(), segment -> {
                for (SubjectRef<?> parent : segment.parents()) {
                    this.echo(DOUBLE_INDENT, this.source.formatter().subject(parent));
                }
            });
        }
    }
}

