/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft.command.definition;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.Command;
import ca.stellardrift.permissionsex.ext.commandframework.Description;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.CommandArgument;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.standard.StringArgument;
import ca.stellardrift.permissionsex.impl.PermissionsEx;
import ca.stellardrift.permissionsex.minecraft.command.Commander;
import ca.stellardrift.permissionsex.minecraft.command.Elements;
import ca.stellardrift.permissionsex.minecraft.command.Formats;
import ca.stellardrift.permissionsex.minecraft.command.Permission;
import ca.stellardrift.permissionsex.minecraft.command.definition.Messages;
import ca.stellardrift.permissionsex.minecraft.command.definition.SubjectRefProvider;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import java.util.ArrayList;
import java.util.Set;

final class OptionSubcommand {
    private OptionSubcommand() {
    }

    static Command.Builder<Commander> register(Command.Builder<Commander> builder, SubjectRefProvider subjectProvider) {
        Permission permission = Permission.pex("option.set");
        CommandArgument optionArg = ((StringArgument.Builder)StringArgument.newBuilder("option").single().withSuggestionsProvider(Elements.engineCompletions((engine, input) -> new ArrayList<String>(((PermissionsEx)engine).getRecordingNotifier().getKnownOptions())))).build();
        CommandArgument optionValueArg = StringArgument.optional("value", StringArgument.StringMode.GREEDY);
        return builder.permission(permission).argument(optionArg, Description.of("any option, suggesting from those that have already been checked")).argument(optionValueArg).handler(ctx -> {
            SubjectRef.ToData<?> subject = subjectProvider.provideData(ctx, permission);
            Set<ContextValue<?>> contexts = Elements.contexts(ctx);
            String option = (String)ctx.get(optionArg);
            @Nullable String value = ctx.getOrDefault(optionValueArg, null);
            if (value == null) {
                subject.update(contexts, old -> old.withoutOption(option)).whenComplete(Elements.messageSender((Commander)ctx.getSender(), Messages.OPTION_SUCCESS_UNSET.tr(option, ((Commander)ctx.getSender()).formatter().subject(subject), Formats.contexts(contexts))));
            } else {
                subject.update(contexts, old -> old.withOption(option, value)).whenComplete(Elements.messageSender((Commander)ctx.getSender(), Messages.OPTION_SUCCESS_SET.tr(option, ((Commander)ctx.getSender()).formatter().subject(subject), Formats.contexts(contexts))));
            }
        });
    }
}

