/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft.command.definition;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.ext.commandframework.Command;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.CommandArgument;
import ca.stellardrift.permissionsex.ext.geantyref.TypeToken;
import ca.stellardrift.permissionsex.minecraft.command.CommandRegistrationContext;
import ca.stellardrift.permissionsex.minecraft.command.Commander;
import ca.stellardrift.permissionsex.minecraft.command.Elements;
import ca.stellardrift.permissionsex.minecraft.command.Formats;
import ca.stellardrift.permissionsex.minecraft.command.MessageFormatter;
import ca.stellardrift.permissionsex.minecraft.command.Permission;
import ca.stellardrift.permissionsex.minecraft.command.argument.Parsers;
import ca.stellardrift.permissionsex.minecraft.command.definition.Messages;
import ca.stellardrift.permissionsex.minecraft.command.definition.SubjectRefProvider;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;
import java.util.Set;

final class ParentSubcommand {
    private ParentSubcommand() {
    }

    static void register(CommandRegistrationContext ctx, SubjectRefProvider provider) {
        ctx.register(build -> ParentSubcommand.add(build, provider), "add", "a", "+");
        ctx.register(build -> ParentSubcommand.remove(build, provider), "remove", "rem", "delete", "del", "-");
        ctx.register(build -> ParentSubcommand.set(build, provider), "set", "replace", "=");
    }

    static Command.Builder<Commander> add(Command.Builder<Commander> build, SubjectRefProvider subjectProvider) {
        Permission permission = Permission.pex("parent.add");
        CommandArgument<Commander, SubjectType<?>> parentType = ParentSubcommand.parentTypeArgument();
        CommandArgument<Commander, ?> parentIdentifier = ParentSubcommand.parentIdentifierArgument(parentType);
        SubjectRefProvider parentProvider = SubjectRefProvider.of(parentType, parentIdentifier);
        return build.argument(parentType).argument(parentIdentifier).permission(permission).handler(ctx -> {
            SubjectRef.ToData<?> subject = subjectProvider.provideData(ctx, permission);
            Set<ContextValue<?>> contexts = Elements.contexts(ctx);
            SubjectRef<?> parent = parentProvider.provide(ctx);
            MessageFormatter fmt = ((Commander)ctx.getSender()).formatter();
            Object[] objectArray = new Object[3];
            objectArray[0] = fmt.subject(parent);
            objectArray[1] = fmt.subject(subject).style(fmt::hl);
            objectArray[2] = Formats.contexts(contexts);
            subject.update(contexts, segment -> segment.plusParent(parent)).whenComplete(Elements.messageSender((Commander)ctx.getSender(), Messages.PARENT_ADD_SUCCESS.tr(objectArray)));
        });
    }

    static Command.Builder<Commander> remove(Command.Builder<Commander> build, SubjectRefProvider subjectProvider) {
        Permission permission = Permission.pex("parent.remove");
        CommandArgument<Commander, SubjectType<?>> parentType = ParentSubcommand.parentTypeArgument();
        CommandArgument<Commander, ?> parentIdentifier = ParentSubcommand.parentIdentifierArgument(parentType);
        SubjectRefProvider parentProvider = SubjectRefProvider.of(parentType, parentIdentifier);
        return build.argument(parentType).argument(parentIdentifier).permission(permission).handler(ctx -> {
            SubjectRef.ToData<?> subject = subjectProvider.provideData(ctx, permission);
            Set<ContextValue<?>> contexts = Elements.contexts(ctx);
            SubjectRef<?> parent = parentProvider.provide(ctx);
            MessageFormatter fmt = ((Commander)ctx.getSender()).formatter();
            Object[] objectArray = new Object[3];
            objectArray[0] = fmt.subject(parent);
            objectArray[1] = fmt.subject(subject).style(fmt::hl);
            objectArray[2] = Formats.contexts(contexts);
            subject.update(contexts, segment -> segment.minusParent(parent)).whenComplete(Elements.messageSender((Commander)ctx.getSender(), Messages.PARENT_REMOVE_SUCCESS.tr(objectArray)));
        });
    }

    static Command.Builder<Commander> set(Command.Builder<Commander> build, SubjectRefProvider subjectProvider) {
        Permission permission = Permission.pex("parent.set");
        CommandArgument<Commander, SubjectType<?>> parentType = ParentSubcommand.parentTypeArgument();
        CommandArgument<Commander, ?> parentIdentifier = ParentSubcommand.parentIdentifierArgument(parentType);
        SubjectRefProvider parentProvider = SubjectRefProvider.of(parentType, parentIdentifier);
        return build.argument(parentType).argument(parentIdentifier).permission(permission).handler(ctx -> {
            SubjectRef.ToData<?> subject = subjectProvider.provideData(ctx, permission);
            Set<ContextValue<?>> contexts = Elements.contexts(ctx);
            SubjectRef<?> parent = parentProvider.provide(ctx);
            MessageFormatter fmt = ((Commander)ctx.getSender()).formatter();
            Object[] objectArray = new Object[3];
            objectArray[0] = fmt.subject(parent);
            objectArray[1] = fmt.subject(subject).style(fmt::hl);
            objectArray[2] = Formats.contexts(contexts);
            subject.update(contexts, segment -> segment.withoutParents().plusParent(parent)).whenComplete(Elements.messageSender((Commander)ctx.getSender(), Messages.PARENT_SET_SUCCESS.tr(objectArray)));
        });
    }

    private static CommandArgument<Commander, SubjectType<?>> parentTypeArgument() {
        return CommandArgument.ofType(new TypeToken<SubjectType<?>>(){}, "parent type").withParser(Parsers.subjectType()).build();
    }

    private static CommandArgument<Commander, ?> parentIdentifierArgument(CommandArgument<Commander, SubjectType<?>> parentType) {
        return CommandArgument.ofType(Object.class, "parent identifier").withParser(Parsers.subjectIdentifier(data -> (SubjectType)data.get(parentType))).build();
    }
}

