/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft.command.definition;

import ca.stellardrift.permissionsex.datastore.ConversionResult;
import ca.stellardrift.permissionsex.ext.checkerframework.checker.nullness.qual.Nullable;
import ca.stellardrift.permissionsex.ext.commandframework.Command;
import ca.stellardrift.permissionsex.ext.commandframework.CommandManager;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.CommandArgument;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.flags.CommandFlag;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.standard.StringArgument;
import ca.stellardrift.permissionsex.ext.commandframework.meta.CommandMeta;
import ca.stellardrift.permissionsex.ext.commandframework.minecraft.extras.MinecraftHelp;
import ca.stellardrift.permissionsex.ext.geantyref.TypeToken;
import ca.stellardrift.permissionsex.ext.kyori.adventure.audience.Audience;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.Component;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.TextComponent;
import ca.stellardrift.permissionsex.ext.kyori.adventure.text.format.NamedTextColor;
import ca.stellardrift.permissionsex.impl.PermissionsEx;
import ca.stellardrift.permissionsex.impl.util.PCollections;
import ca.stellardrift.permissionsex.minecraft.MinecraftPermissionsEx;
import ca.stellardrift.permissionsex.minecraft.command.CommandException;
import ca.stellardrift.permissionsex.minecraft.command.CommandRegistrationContext;
import ca.stellardrift.permissionsex.minecraft.command.Commander;
import ca.stellardrift.permissionsex.minecraft.command.Elements;
import ca.stellardrift.permissionsex.minecraft.command.Formats;
import ca.stellardrift.permissionsex.minecraft.command.MessageFormatter;
import ca.stellardrift.permissionsex.minecraft.command.Permission;
import ca.stellardrift.permissionsex.minecraft.command.argument.Parsers;
import ca.stellardrift.permissionsex.minecraft.command.definition.DeleteSubcommand;
import ca.stellardrift.permissionsex.minecraft.command.definition.InfoSubcommand;
import ca.stellardrift.permissionsex.minecraft.command.definition.Messages;
import ca.stellardrift.permissionsex.minecraft.command.definition.OptionSubcommand;
import ca.stellardrift.permissionsex.minecraft.command.definition.ParentSubcommand;
import ca.stellardrift.permissionsex.minecraft.command.definition.PermissionsSubcommands;
import ca.stellardrift.permissionsex.minecraft.command.definition.RankingCommands;
import ca.stellardrift.permissionsex.minecraft.command.definition.SubjectRefProvider;
import ca.stellardrift.permissionsex.subject.SubjectDataCache;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import ca.stellardrift.permissionsex.subject.SubjectType;
import ca.stellardrift.permissionsex.subject.SubjectTypeCollection;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class PermissionsExCommand {
    private PermissionsExCommand() {
    }

    public static void register(CommandRegistrationContext regCtx) {
        Command<Commander> helpCommand = regCtx.register(base -> PermissionsExCommand.help(base, regCtx.commandManager(), regCtx.manager().messageFormatter()), "help", "?");
        regCtx.register(regCtx.head().handler(ctx -> {
            Commander sender = (Commander)ctx.getSender();
            TextComponent version = Component.text("v" + regCtx.manager().engine().version(), sender.formatter().highlightColor());
            sender.sendMessage(Component.text("PermissionsEx ").append(version));
            sender.sendMessage(Component.text("Run " + Formats.formatCommand(helpCommand, PCollections.map()) + "for more information"));
        }));
        regCtx.register(PermissionsExCommand::debug, "debug", "d");
        regCtx.push(RankingCommands::register, "ranking", "rank");
        regCtx.register(PermissionsExCommand::commandImport, "import", new String[0]);
        regCtx.register(PermissionsExCommand::reload, "reload", "rel");
        regCtx.register(PermissionsExCommand::version, "version", new String[0]);
        regCtx.register(PermissionsExCommand.debug(regCtx.head().literal("toggle", new String[0]).literal("debug", new String[0])));
        CommandArgument<Commander, SubjectType<?>> typeArg = CommandArgument.ofType(new TypeToken<SubjectType<?>>(){}, "type").withParser(Parsers.subjectType()).build();
        Command.Builder<Commander> typeBuilder = regCtx.head().argument(typeArg);
        regCtx.register(PermissionsExCommand.list(typeBuilder.literal("list", new String[0]), typeArg));
        CommandArgument identifierArg = CommandArgument.ofType(Object.class, "subject").withParser(Parsers.subjectIdentifier(data -> (SubjectType)data.get(typeArg))).build();
        regCtx.push(typeBuilder.argument(identifierArg), child -> {
            SubjectRefProvider refArg = SubjectRefProvider.of(typeArg, identifierArg);
            child.register(build -> InfoSubcommand.register(build, refArg), "info", "i");
            child.push(child.head().flag(Elements.FLAG_TRANSIENT).flag(Elements.FLAG_CONTEXT), grandchild -> {
                grandchild.register(build -> DeleteSubcommand.register(build, refArg), "delete", "del", "remove", "rem", "rm");
                grandchild.push(build -> ParentSubcommand.register(build, refArg), "parents", "parent", "par");
                grandchild.register(build -> OptionSubcommand.register(build, refArg), "option", "options", "opt", "o", "meta");
                grandchild.register(build -> PermissionsSubcommands.permission(build, refArg), "permission", "permissions", "perm", "perms", "p");
                grandchild.register(build -> PermissionsSubcommands.permissionDefault(build, refArg), "permission-default", "perms-def", "permsdef", "pd", "default", "def");
            });
        });
    }

    private static Command.Builder<Commander> help(Command.Builder<Commander> base, CommandManager<Commander> mgr, MessageFormatter formatter) {
        CommandArgument query = StringArgument.optional("query", StringArgument.StringMode.GREEDY);
        Command.Builder<Commander> helpCommand = base.meta(CommandMeta.DESCRIPTION, "Get help for PermissionsEx").argument(query).permission(Permission.pex("help"));
        MinecraftHelp<Commander> help = new MinecraftHelp<Commander>(Formats.formatCommand(helpCommand, PCollections.map()), cmd -> cmd, mgr);
        help.setHelpColors(MinecraftHelp.HelpColors.of(formatter.responseColor(), formatter.highlightColor(), Formats.lerp(0.4, formatter.highlightColor(), NamedTextColor.BLACK), NamedTextColor.GRAY, NamedTextColor.DARK_GRAY));
        return helpCommand.handler(ctx -> help.queryCommands(ctx.getOrDefault(query, ""), (Commander)ctx.getSender()));
    }

    private static Command.Builder<Commander> debug(Command.Builder<Commander> base) {
        CommandArgument filterArg = CommandArgument.ofType(Pattern.class, "pattern").asOptional().withParser(Parsers.greedyPattern()).build();
        return base.meta(CommandMeta.DESCRIPTION, Messages.DEBUG_DESCRIPTION.key()).permission(Permission.pex("debug")).argument(filterArg).handler(Elements.handler((source, engine, ctx) -> {
            Pattern filter;
            boolean debugEnabled = !engine.debugMode();
            Pattern pattern = filter = ctx.contains(filterArg.getName()) ? (Pattern)ctx.get(filterArg) : null;
            if (filter != null) {
                engine.debugMode(debugEnabled, filter);
                source.sendMessage(Messages.DEBUG_SUCCESS_FILTER.tr(Formats.bool(debugEnabled), source.formatter().hl(Component.text().content(filter.pattern()))));
            } else {
                engine.debugMode(debugEnabled);
                source.sendMessage(Messages.DEBUG_SUCCESS.tr(Formats.bool(debugEnabled)));
            }
        }));
    }

    private static Command.Builder<Commander> commandImport(Command.Builder<Commander> base) {
        CommandArgument dataStoreArg = StringArgument.newBuilder("data store").withSuggestionsProvider((ctx, input) -> {
            PermissionsEx engine = (PermissionsEx)ctx.get("permissionsex:engine");
            return PCollections.asVector(engine.getAvailableConversions(), conv -> conv.store().identifier());
        }).asOptional().build();
        return base.meta(CommandMeta.DESCRIPTION, "Import data from another store").argument(dataStoreArg).permission(Permission.pex("import")).handler(ctx -> {
            String requestedName;
            Commander source = (Commander)ctx.getSender();
            PermissionsEx engine = (PermissionsEx)ctx.get("permissionsex:engine");
            String string = requestedName = ctx.contains(dataStoreArg.getName()) ? (String)ctx.get(dataStoreArg) : null;
            if (requestedName == null) {
                source.sendPaginated(Messages.IMPORT_LISTING_HEADER.tr(new Object[0]), Messages.IMPORT_LISTING_SUBTITLE.tr(source.formatter().hl(Component.text().content("/pex import [id]"))), PCollections.asVector(engine.getAvailableConversions(), conv -> source.callback((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(conv.description())).append((Component)Component.text(" - /pex import "))).append((Component)Component.text(conv.store().identifier())), src -> {
                    src.sendMessage(Messages.IMPORT_ACTION_BEGINNING.tr(conv.description()));
                    engine.importDataFrom((ConversionResult)conv).whenComplete(Elements.messageSender(src, Messages.IMPORT_ACTION_SUCCESS.tr(conv.description())));
                })));
            } else {
                for (ConversionResult result : engine.getAvailableConversions()) {
                    if (!result.store().identifier().equalsIgnoreCase(requestedName)) continue;
                    source.sendMessage(Messages.IMPORT_ACTION_BEGINNING.tr(result.description()));
                    engine.importDataFrom(result).whenComplete(Elements.messageSender(source, Messages.IMPORT_ACTION_SUCCESS.tr(result.description())));
                    return;
                }
                if (engine.config().getDataStore(requestedName) == null) {
                    throw new CommandException(Messages.IMPORT_ERROR_UNKNOWN_STORE.tr(requestedName));
                }
                source.sendMessage(Messages.IMPORT_ACTION_BEGINNING.tr(requestedName));
                engine.importDataFrom(requestedName).whenComplete(Elements.messageSender(source, Messages.IMPORT_ACTION_SUCCESS.tr(requestedName)));
            }
        });
    }

    private static Command.Builder<Commander> reload(Command.Builder<Commander> base) {
        return base.meta(CommandMeta.DESCRIPTION, "Reload PermissionsEx").permission(Permission.pex("reload")).handler(ctx -> {
            ((Commander)ctx.getSender()).sendMessage(Messages.RELOAD_ACTION_BEGIN.tr(new Object[0]));
            ((PermissionsEx)ctx.get("permissionsex:engine")).reload().whenComplete(Elements.messageSender((Commander)ctx.getSender(), Messages.RELOAD_ACTION_SUCCESS.tr(new Object[0])));
        });
    }

    private static Command.Builder<Commander> version(Command.Builder<Commander> base) {
        CommandFlag<Void> verboseFlag = CommandFlag.newBuilder("verbose").withAliases("v").build();
        return base.meta(CommandMeta.DESCRIPTION, "Get details about the currently running PermissionsEx version").permission(Permission.pex("version")).flag(verboseFlag).handler(ctx -> {
            boolean verbose = ctx.flags().isPresent(verboseFlag.getName());
            ((MinecraftPermissionsEx)ctx.get("permissionsex:manager")).describe((Audience)ctx.getSender(), verbose);
        });
    }

    private static Command.Builder<Commander> list(Command.Builder<Commander> base, CommandArgument<Commander, SubjectType<?>> subjectTypeArg) {
        CommandArgument filterArg = StringArgument.optional("filter");
        Permission basePerm = Permission.pex("list");
        return base.meta(CommandMeta.DESCRIPTION, "List all subjects of a certain type").argument(filterArg).flag(Elements.FLAG_TRANSIENT).handler(Elements.handler((source, engine, ctx) -> {
            SubjectType type = (SubjectType)ctx.get(subjectTypeArg);
            source.checkPermission(basePerm.then(type.name()));
            PermissionsExCommand.printList(source, engine.subjects(type), ctx.flags().isPresent(Elements.FLAG_TRANSIENT.getName()), ctx.contains(filterArg.getName()) ? (String)ctx.get(filterArg) : null);
        }));
    }

    private static <I> void printList(Commander source, SubjectTypeCollection<I> collection, boolean transientData, @Nullable String filter) {
        SubjectDataCache<I> data = transientData ? collection.transientData() : collection.persistentData();
        Stream<SubjectRef> identifiers = data.getAllIdentifiers().map(id -> SubjectRef.subject(collection.type(), id));
        if (filter != null && !filter.isEmpty()) {
            String lowerFilter = filter.toLowerCase(Locale.ROOT);
            identifiers = identifiers.filter(it -> it.serializedIdentifier().toLowerCase(Locale.ROOT).startsWith(lowerFilter));
        }
        source.sendPaginated(Messages.PEX_LIST_HEADER.tr(collection.type().name()), Messages.PEX_LIST_SUBTITLE.tr(collection.type().name()), identifiers.map(source.formatter()::subject).collect(Collectors.toList()));
    }
}

