/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.permissionsex.minecraft.command.definition;

import ca.stellardrift.permissionsex.context.ContextValue;
import ca.stellardrift.permissionsex.ext.commandframework.Command;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.CommandArgument;
import ca.stellardrift.permissionsex.ext.commandframework.arguments.standard.StringArgument;
import ca.stellardrift.permissionsex.ext.commandframework.meta.CommandMeta;
import ca.stellardrift.permissionsex.impl.PermissionsEx;
import ca.stellardrift.permissionsex.minecraft.command.Commander;
import ca.stellardrift.permissionsex.minecraft.command.Elements;
import ca.stellardrift.permissionsex.minecraft.command.Formats;
import ca.stellardrift.permissionsex.minecraft.command.Permission;
import ca.stellardrift.permissionsex.minecraft.command.argument.Parsers;
import ca.stellardrift.permissionsex.minecraft.command.definition.Messages;
import ca.stellardrift.permissionsex.minecraft.command.definition.SubjectRefProvider;
import ca.stellardrift.permissionsex.subject.SubjectRef;
import java.util.ArrayList;
import java.util.Set;

final class PermissionsSubcommands {
    private static CommandArgument<Commander, Integer> permissionValueArgument() {
        return CommandArgument.ofType(Integer.class, "state").withParser(Parsers.permissionValue()).build();
    }

    private PermissionsSubcommands() {
    }

    static Command.Builder<Commander> permission(Command.Builder<Commander> builder, SubjectRefProvider subjectProvider) {
        Permission cmdPerm = Permission.pex("permission.set");
        CommandArgument permissionArg = ((StringArgument.Builder)StringArgument.newBuilder("permission").withSuggestionsProvider(Elements.engineCompletions((engine, input) -> new ArrayList<String>(((PermissionsEx)engine).getRecordingNotifier().getKnownPermissions())))).build();
        CommandArgument<Commander, Integer> permissionValueArg = PermissionsSubcommands.permissionValueArgument();
        return builder.meta(CommandMeta.DESCRIPTION, "Set a permission for a subject").argument(permissionArg).argument(permissionValueArg).permission(cmdPerm).handler(ctx -> {
            SubjectRef.ToData<?> subject = subjectProvider.provideData(ctx, cmdPerm);
            Set<ContextValue<?>> contexts = Elements.contexts(ctx);
            String permission = (String)ctx.get(permissionArg);
            int value = (Integer)ctx.get(permissionValueArg);
            subject.update(contexts, segment -> segment.withPermission(permission, value)).whenComplete(Elements.messageSender((Commander)ctx.getSender(), Messages.PERMISSION_SUCCESS.tr(Formats.permission(permission, value), ((Commander)ctx.getSender()).formatter().subject(subject), Formats.contexts(contexts))));
        });
    }

    static Command.Builder<Commander> permissionDefault(Command.Builder<Commander> builder, SubjectRefProvider subjectProvider) {
        Permission cmdPerm = Permission.pex("permission.set-default");
        CommandArgument<Commander, Integer> permissionValueArg = PermissionsSubcommands.permissionValueArgument();
        return builder.meta(CommandMeta.DESCRIPTION, "Set the fallback permission for a subject").argument(permissionValueArg).permission(cmdPerm).handler(ctx -> {
            SubjectRef.ToData<?> subject = subjectProvider.provideData(ctx, cmdPerm);
            Set<ContextValue<?>> contexts = Elements.contexts(ctx);
            int value = (Integer)ctx.get(permissionValueArg);
            Object[] objectArray = new Object[3];
            objectArray[0] = Formats.permissionValue(value);
            objectArray[1] = ((Commander)ctx.getSender()).formatter().subject(subject).style(((Commander)ctx.getSender()).formatter()::hl);
            objectArray[2] = Formats.contexts(contexts);
            subject.update(contexts, segment -> segment.withFallbackPermission(value)).whenComplete(Elements.messageSender((Commander)ctx.getSender(), Messages.PERMISSION_DEFAULT_SUCCESS.tr(objectArray)));
        });
    }
}

